/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.elasticsearch.analysis.common.SnowballAnalyzer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;

public class SnowballAnalyzerProvider
extends AbstractIndexAnalyzerProvider<SnowballAnalyzer> {
    private static final Map<String, CharArraySet> DEFAULT_LANGUAGE_STOP_WORDS = Map.of("English", EnglishAnalyzer.ENGLISH_STOP_WORDS_SET, "Dutch", DutchAnalyzer.getDefaultStopSet(), "German", GermanAnalyzer.getDefaultStopSet(), "German2", GermanAnalyzer.getDefaultStopSet(), "French", FrenchAnalyzer.getDefaultStopSet());
    private final SnowballAnalyzer analyzer;

    SnowballAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        String language = settings.get("language", settings.get("name", "English"));
        CharArraySet defaultStopwords = DEFAULT_LANGUAGE_STOP_WORDS.getOrDefault(language, CharArraySet.EMPTY_SET);
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)defaultStopwords);
        this.analyzer = new SnowballAnalyzer(language, stopWords);
    }

    public SnowballAnalyzer get() {
        return this.analyzer;
    }
}

