/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90HnswVectorsFormat;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.KnnVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.PerFieldKnnVectorsFormatFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.vectors.query.KnnVectorFieldExistsQuery;
import org.elasticsearch.xpack.vectors.query.VectorIndexFieldData;

public class DenseVectorFieldMapper
extends FieldMapper
implements PerFieldKnnVectorsFormatFieldMapper {
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)2048;
    private static final byte INT_BYTES = 4;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()), DenseVectorFieldMapper.notInMultiFields((String)"dense_vector"));
    private final int dims;
    private final boolean indexed;
    private final VectorSimilarity similarity;
    private final IndexOptions indexOptions;
    private final Version indexCreatedVersion;

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, int dims, boolean indexed, VectorSimilarity similarity, IndexOptions indexOptions, Version indexCreatedVersion, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.dims = dims;
        this.indexed = indexed;
        this.similarity = similarity;
        this.indexOptions = indexOptions;
        this.indexCreatedVersion = indexCreatedVersion;
    }

    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    public boolean parsesArrayValue() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        Field field = this.fieldType().indexed ? this.parseKnnVector(context) : this.parseBinaryDocValuesVector(context);
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    private Field parseKnnVector(DocumentParserContext context) throws IOException {
        float[] vector = new float[this.dims];
        double squaredMagnitude = 0.0;
        int index = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            this.checkDimensionExceeded(index, context);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)context.parser());
            float value = context.parser().floatValue(true);
            vector[index++] = value;
            squaredMagnitude += (double)(value * value);
            token = context.parser().nextToken();
        }
        this.checkDimensionMatches(index, context);
        if (this.similarity == VectorSimilarity.dot_product) {
            this.fieldType().checkVectorMagnitude(vector, squaredMagnitude);
        }
        return new KnnVectorField(this.fieldType().name(), vector, this.similarity.function);
    }

    private Field parseBinaryDocValuesVector(DocumentParserContext context) throws IOException {
        byte[] bytes = this.indexCreatedVersion.onOrAfter(Version.V_7_5_0) ? new byte[this.dims * 4 + 4] : new byte[this.dims * 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        double dotProduct = 0.0;
        int index = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            this.checkDimensionExceeded(index, context);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)context.parser());
            float value = context.parser().floatValue(true);
            byteBuffer.putFloat(value);
            dotProduct += (double)(value * value);
            ++index;
            token = context.parser().nextToken();
        }
        this.checkDimensionMatches(index, context);
        if (this.indexCreatedVersion.onOrAfter(Version.V_7_5_0)) {
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        return new BinaryDocValuesField(this.fieldType().name(), new BytesRef(bytes));
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.name() + "] in doc [" + context.sourceToParse().id() + "] has more dimensions than defined in the mapping [" + this.dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.name() + "] in doc [" + context.sourceToParse().id() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.dims + "]");
        }
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion).init(this);
    }

    public void doValidate(MappingLookup mappers) {
        if (this.indexed && mappers.getNestedParent(this.name()) != null) {
            throw new IllegalArgumentException("[dense_vector] fields cannot be indexed if they're within [nested] mappings");
        }
    }

    private static IndexOptions parseIndexOptions(String fieldName, Object propNode) {
        Map indexOptionsMap = (Map)propNode;
        Object typeNode = indexOptionsMap.remove("type");
        if (typeNode == null) {
            throw new MapperParsingException("[index_options] requires field [type] to be configured");
        }
        String type = XContentMapValues.nodeStringValue(typeNode);
        if (type.equals("hnsw")) {
            return HnswIndexOptions.parseIndexOptions(fieldName, indexOptionsMap);
        }
        throw new MapperParsingException("Unknown vector index options type [" + type + "] for field [" + fieldName + "]");
    }

    public KnnVectorsFormat getKnnVectorsFormatForField() {
        if (this.indexOptions == null) {
            return null;
        }
        HnswIndexOptions hnswIndexOptions = (HnswIndexOptions)this.indexOptions;
        return new Lucene90HnswVectorsFormat(hnswIndexOptions.m, hnswIndexOptions.efConstruction);
    }

    static enum VectorSimilarity {
        l2_norm(VectorSimilarityFunction.EUCLIDEAN),
        cosine(VectorSimilarityFunction.COSINE),
        dot_product(VectorSimilarityFunction.DOT_PRODUCT);

        public final VectorSimilarityFunction function;

        private VectorSimilarity(VectorSimilarityFunction function) {
            this.function = function;
        }
    }

    private static abstract class IndexOptions
    implements ToXContent {
        final String type;

        IndexOptions(String type) {
            this.type = type;
        }
    }

    public static final class DenseVectorFieldType
    extends SimpleMappedFieldType {
        private final int dims;
        private final boolean indexed;
        private final VectorSimilarity similarity;
        private final Version indexVersionCreated;

        public DenseVectorFieldType(String name, Version indexVersionCreated, int dims, boolean indexed, VectorSimilarity similarity, Map<String, String> meta) {
            super(name, indexed, false, !indexed, TextSearchInfo.NONE, meta);
            this.dims = dims;
            this.indexed = indexed;
            this.similarity = similarity;
            this.indexVersionCreated = indexVersionCreated;
        }

        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), context){

                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public boolean isAggregatable() {
            return false;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new VectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, this.indexVersionCreated, this.dims, this.indexed);
        }

        public Query existsQuery(SearchExecutionContext context) {
            if (this.indexed) {
                return new KnnVectorFieldExistsQuery(this.name());
            }
            assert (this.hasDocValues());
            return new DocValuesFieldExistsQuery(this.name());
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        public KnnVectorQuery createKnnQuery(float[] queryVector, int numCands) {
            if (!this.isSearchable()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            if (queryVector.length != this.dims) {
                throw new IllegalArgumentException("the query vector has a different dimension [" + queryVector.length + "] than the index vectors [" + this.dims + "]");
            }
            if (this.similarity == VectorSimilarity.dot_product) {
                double squaredMagnitude = 0.0;
                for (float e : queryVector) {
                    squaredMagnitude += (double)(e * e);
                }
                this.checkVectorMagnitude(queryVector, squaredMagnitude);
            }
            return new KnnVectorQuery(this.name(), queryVector, numCands);
        }

        private void checkVectorMagnitude(float[] vector, double squaredMagnitude) {
            if (Math.abs(squaredMagnitude - 1.0) > 1.0E-4) {
                StringBuilder sb = new StringBuilder("The [" + VectorSimilarity.dot_product.name() + "] similarity can only be used with unit-length vectors. Preview of invalid vector: ");
                sb.append("[");
                for (int i = 0; i < Math.min(5, vector.length); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(vector[i]);
                }
                if (vector.length >= 5) {
                    sb.append(", ...");
                }
                sb.append("]");
                throw new IllegalArgumentException(sb.toString());
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter("dims", false, () -> null, (n, c, o) -> XContentMapValues.nodeIntegerValue((Object)o), m -> DenseVectorFieldMapper.toType((FieldMapper)m).dims).addValidator(dims -> {
            if (dims == null) {
                throw new MapperParsingException("Missing required parameter [dims] for field [" + this.name + "]");
            }
            if (dims > MAX_DIMS_COUNT || dims < 1) {
                throw new MapperParsingException("The number of dimensions for field [" + this.name + "] should be in the range [1, " + MAX_DIMS_COUNT + "] but was [" + dims + "]");
            }
        });
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexed, (boolean)false);
        private final FieldMapper.Parameter<VectorSimilarity> similarity = FieldMapper.Parameter.enumParam((String)"similarity", (boolean)false, m -> DenseVectorFieldMapper.toType((FieldMapper)m).similarity, null, VectorSimilarity.class);
        private final FieldMapper.Parameter<IndexOptions> indexOptions = new FieldMapper.Parameter("index_options", false, () -> null, (n, c, o) -> o == null ? null : DenseVectorFieldMapper.parseIndexOptions(n, o), m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexOptions);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final Version indexVersionCreated;

        public Builder(String name, Version indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            this.indexed.requiresParameters(new FieldMapper.Parameter[]{this.similarity});
            this.similarity.setSerializerCheck((id, ic, v) -> v != null);
            this.similarity.requiresParameters(new FieldMapper.Parameter[]{this.indexed});
            this.indexOptions.requiresParameters(new FieldMapper.Parameter[]{this.indexed});
            this.indexOptions.setSerializerCheck((id, ic, v) -> v != null);
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.dims, this.indexed, this.similarity, this.indexOptions, this.meta);
        }

        public DenseVectorFieldMapper build(MapperBuilderContext context) {
            return new DenseVectorFieldMapper(this.name, (MappedFieldType)new DenseVectorFieldType(context.buildFullName(this.name), this.indexVersionCreated, (Integer)this.dims.getValue(), (Boolean)this.indexed.getValue(), (VectorSimilarity)((Object)this.similarity.getValue()), (Map)this.meta.getValue()), (Integer)this.dims.getValue(), (Boolean)this.indexed.getValue(), (VectorSimilarity)((Object)this.similarity.getValue()), (IndexOptions)this.indexOptions.getValue(), this.indexVersionCreated, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build());
        }
    }

    private static class HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;

        static IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
            Object mNode = indexOptionsMap.remove("m");
            Object efConstructionNode = indexOptionsMap.remove("ef_construction");
            if (mNode == null) {
                throw new MapperParsingException("[index_options] of type [hnsw] requires field [m] to be configured");
            }
            if (efConstructionNode == null) {
                throw new MapperParsingException("[index_options] of type [hnsw] requires field [ef_construction] to be configured");
            }
            int m = XContentMapValues.nodeIntegerValue(mNode);
            int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
            MappingParser.checkNoRemainingFields((String)fieldName, indexOptionsMap);
            return new HnswIndexOptions(m, efConstruction);
        }

        private HnswIndexOptions(int m, int efConstruction) {
            super("hnsw");
            this.m = m;
            this.efConstruction = efConstruction;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HnswIndexOptions that = (HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.m, this.efConstruction);
        }

        public String toString() {
            return "{type=" + this.type + ", m=" + this.m + ", ef_construction=" + this.efConstruction + " }";
        }
    }
}

