/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;

public final class DomainSplitFunction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DomainSplitFunction.class);
    private static final int MAX_DOMAIN_PART_LENGTH = 63;
    private static final Map<String, String> exact;
    private static final Map<String, String> under;
    private static final Map<String, String> excluded;

    private DomainSplitFunction() {
    }

    private static String replaceDots(String input) {
        String output = input;
        if (output.indexOf(12290) >= 0) {
            output = output.replace('\u3002', '.');
        }
        if (output.indexOf(65294) >= 0) {
            output = output.replace('\uff0e', '.');
        }
        if (output.indexOf(65377) >= 0) {
            output = output.replace('\uff61', '.');
        }
        return output;
    }

    private static List<String> splitDomain(String domain) {
        String dotDomain = DomainSplitFunction.replaceDots(domain);
        return Arrays.asList(dotDomain.split("\\."));
    }

    private static int findPublicSuffix(List<String> parts) {
        int partsSize = parts.size();
        for (int i = 0; i < partsSize; ++i) {
            StringJoiner joiner = new StringJoiner(".");
            for (String s : parts.subList(i, partsSize)) {
                joiner.add(s);
            }
            String ancestorName = joiner.toString();
            if (exact.containsKey(ancestorName)) {
                return i;
            }
            if (excluded.containsKey(ancestorName)) {
                return i + 1;
            }
            String[] pieces = ancestorName.split("\\.");
            if (pieces.length < 2 || !under.containsKey(pieces[1])) continue;
            return i;
        }
        return -1;
    }

    private static String ancestor(List<String> parts, int levels) {
        StringJoiner joiner = new StringJoiner(".");
        for (String s : parts.subList(levels, parts.size())) {
            joiner.add(s);
        }
        String name = joiner.toString();
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private static String topPrivateDomain(String name, List<String> parts, int publicSuffixIndex) {
        if (publicSuffixIndex == 1) {
            return name;
        }
        if (publicSuffixIndex <= 0) {
            throw new IllegalArgumentException("Not under a public suffix: " + name);
        }
        return DomainSplitFunction.ancestor(parts, publicSuffixIndex - 1);
    }

    public static List<String> domainSplit(String host, Map<String, Object> params) {
        AccessController.doPrivileged(() -> {
            deprecationLogger.warn(DeprecationCategory.API, "domainSplit", "Method [domainSplit] taking params is deprecated. Remove the params argument.", new Object[0]);
            return null;
        });
        return DomainSplitFunction.domainSplit(host);
    }

    public static List<String> domainSplit(String host) {
        String subDomain;
        if ((host = host.trim()).contains(":")) {
            return Arrays.asList("", host);
        }
        boolean tentativeIP = true;
        for (int i = 0; i < host.length(); ++i) {
            if (Character.isDigit(host.charAt(i)) || host.charAt(i) == '.') continue;
            tentativeIP = false;
            break;
        }
        if (tentativeIP) {
            if (host.equals(".")) {
                return Arrays.asList("", "");
            }
            return Arrays.asList("", host);
        }
        String normalizedHost = host;
        List<String> parts = DomainSplitFunction.splitDomain(normalizedHost = normalizedHost.toLowerCase(Locale.ROOT));
        int publicSuffixIndex = DomainSplitFunction.findPublicSuffix(parts);
        if (publicSuffixIndex == 0) {
            return Arrays.asList("", host);
        }
        Object highestRegistered = "";
        if (publicSuffixIndex == -1) {
            if (!parts.isEmpty()) {
                if (parts.size() == 1) {
                    return Arrays.asList("", host);
                }
                if (parts.size() > 2) {
                    boolean allNumeric = true;
                    String value = parts.get(parts.size() - 1);
                    for (int i = 0; i < value.length(); ++i) {
                        if (Character.isDigit(value.charAt(i))) continue;
                        allNumeric = false;
                        break;
                    }
                    highestRegistered = allNumeric ? parts.get(parts.size() - 2) + "." + parts.get(parts.size() - 1) : parts.get(parts.size() - 1);
                } else {
                    highestRegistered = parts.get(parts.size() - 1);
                }
            }
        } else {
            highestRegistered = DomainSplitFunction.topPrivateDomain(normalizedHost, parts, publicSuffixIndex);
        }
        if ((subDomain = host.substring(0, host.length() - ((String)highestRegistered).length())).endsWith(".")) {
            subDomain = subDomain.substring(0, subDomain.length() - 1);
        }
        return Arrays.asList(subDomain, highestRegistered);
    }

    static {
        under = Map.ofEntries(Map.entry("bd", "i"), Map.entry("np", "i"), Map.entry("jm", "i"), Map.entry("fj", "i"), Map.entry("fk", "i"), Map.entry("ye", "i"), Map.entry("sch.uk", "i"), Map.entry("bn", "i"), Map.entry("kitakyushu.jp", "i"), Map.entry("kobe.jp", "i"), Map.entry("ke", "i"), Map.entry("sapporo.jp", "i"), Map.entry("kh", "i"), Map.entry("mm", "i"), Map.entry("il", "i"), Map.entry("yokohama.jp", "i"), Map.entry("ck", "i"), Map.entry("nagoya.jp", "i"), Map.entry("sendai.jp", "i"), Map.entry("kw", "i"), Map.entry("er", "i"), Map.entry("mz", "i"), Map.entry("platform.sh", "p"), Map.entry("gu", "i"), Map.entry("nom.br", "i"), Map.entry("zm", "i"), Map.entry("pg", "i"), Map.entry("ni", "i"), Map.entry("kawasaki.jp", "i"), Map.entry("zw", "i"));
        excluded = Map.of("city.yokohama.jp", "i", "teledata.mz", "i", "city.kobe.jp", "i", "city.sapporo.jp", "i", "city.kawasaki.jp", "i", "city.nagoya.jp", "i", "www.ck", "i", "city.sendai.jp", "i", "city.kitakyushu.jp", "i");
        try (InputStream stream = DomainSplitFunction.class.getClassLoader().getResourceAsStream("org/elasticsearch/xpack/ml/transforms/exact.properties");){
            exact = Streams.readAllLines((InputStream)stream).stream().map(line -> line.split("=")).collect(Collectors.toUnmodifiableMap(split -> split[0], split -> split[1]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

