/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestPutJobAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}")).replaces(RestRequest.Method.PUT, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_put_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        XContentParser parser = restRequest.contentParser();
        IndicesOptions indicesOptions = IndicesOptions.fromRequest((RestRequest)restRequest, (IndicesOptions)SearchRequest.DEFAULT_INDICES_OPTIONS);
        PutJobAction.Request putJobRequest = PutJobAction.Request.parseRequest((String)jobId, (XContentParser)parser, (IndicesOptions)indicesOptions);
        putJobRequest.timeout(restRequest.paramAsTime("timeout", putJobRequest.timeout()));
        putJobRequest.masterNodeTimeout(restRequest.paramAsTime("master_timeout", putJobRequest.masterNodeTimeout()));
        return channel -> client.execute((ActionType)PutJobAction.INSTANCE, (ActionRequest)putJobRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

