/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestDeleteJobAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}")).replaces(RestRequest.Method.DELETE, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_delete_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        DeleteJobAction.Request deleteJobRequest = new DeleteJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
        deleteJobRequest.setForce(restRequest.paramAsBoolean(CloseJobAction.Request.FORCE.getPreferredName(), deleteJobRequest.isForce()));
        deleteJobRequest.timeout(restRequest.paramAsTime("timeout", deleteJobRequest.timeout()));
        deleteJobRequest.masterNodeTimeout(restRequest.paramAsTime("master_timeout", deleteJobRequest.masterNodeTimeout()));
        if (restRequest.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.execute((ActionType)DeleteJobAction.INSTANCE, (ActionRequest)deleteJobRequest, (ActionListener)new RestToXContentListener(channel));
        }
        deleteJobRequest.setShouldStoreResult(true);
        Task task = client.executeLocally((ActionType)DeleteJobAction.INSTANCE, (ActionRequest)deleteJobRequest, RestDeleteJobAction.nullTaskListener());
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", client.getLocalNodeId() + ":" + task.getId());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }

    private static <T> TaskListener<T> nullTaskListener() {
        return new TaskListener<T>(){

            public void onResponse(Task task, T o) {
            }

            public void onFailure(Task task, Exception e) {
            }
        };
    }
}

