/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class RestGetTrainedModelsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetTrainedModelsAction.class);
    private static final String INCLUDE_MODEL_DEFINITION = "include_model_definition";
    private static final Map<String, String> DEFAULT_TO_XCONTENT_VALUES = Collections.singletonMap("decompress_definition", Boolean.toString(true));

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID + "}")).replaces(RestRequest.Method.GET, "/_ml/inference/{" + TrainedModelConfig.MODEL_ID + "}", RestApiVersion.V_8).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/trained_models").replaces(RestRequest.Method.GET, "/_ml/inference", RestApiVersion.V_8).build());
    }

    public String getName() {
        return "ml_get_trained_models_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetTrainedModelsAction.Request request;
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)modelId)) {
            modelId = "_all";
        }
        List<String> tags = Arrays.asList(restRequest.paramAsStringArray(TrainedModelConfig.TAGS.getPreferredName(), Strings.EMPTY_ARRAY));
        HashSet<String> includes = new HashSet<String>(Arrays.asList(restRequest.paramAsStringArray(GetTrainedModelsAction.Request.INCLUDE.getPreferredName(), Strings.EMPTY_ARRAY)));
        if (restRequest.hasParam(INCLUDE_MODEL_DEFINITION)) {
            deprecationLogger.warn(DeprecationCategory.API, INCLUDE_MODEL_DEFINITION, "[{}] parameter is deprecated! Use [include=definition] instead.", new Object[]{INCLUDE_MODEL_DEFINITION});
            request = new GetTrainedModelsAction.Request(modelId, restRequest.paramAsBoolean(INCLUDE_MODEL_DEFINITION, false), tags);
        } else {
            request = new GetTrainedModelsAction.Request(modelId, tags, includes);
        }
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        request.setAllowNoResources(restRequest.paramAsBoolean(GetTrainedModelsAction.Request.ALLOW_NO_MATCH.getPreferredName(), request.isAllowNoResources()));
        return channel -> client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)request, new RestToXContentListenerWithDefaultValues((RestChannel)channel, DEFAULT_TO_XCONTENT_VALUES));
    }

    protected Set<String> responseParams() {
        return Set.of("decompress_definition", "exclude_generated");
    }

    private static class RestToXContentListenerWithDefaultValues<T extends ToXContentObject>
    extends RestToXContentListener<T> {
        private final Map<String, String> defaultToXContentParamValues;

        private RestToXContentListenerWithDefaultValues(RestChannel channel, Map<String, String> defaultToXContentParamValues) {
            super(channel);
            this.defaultToXContentParamValues = defaultToXContentParamValues;
        }

        public RestResponse buildResponse(T response, XContentBuilder builder) throws Exception {
            assert (!response.isFragment());
            HashMap params = new HashMap(this.channel.request().params());
            this.defaultToXContentParamValues.forEach((k, v) -> params.computeIfAbsent(k, this.defaultToXContentParamValues::get));
            response.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(params));
            return new BytesRestResponse(this.getStatus((ToXContentObject)response), builder);
        }
    }
}

