/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

public class RestDeleteTrainedModelAliasAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID + "}/model_aliases/{model_alias}"));
    }

    public String getName() {
        return "ml_delete_trained_model_alias_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String modelId = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        String modelAlias = restRequest.param("model_alias");
        return channel -> client.execute((ActionType)DeleteTrainedModelAliasAction.INSTANCE, (ActionRequest)new DeleteTrainedModelAliasAction.Request(modelAlias, modelId), (ActionListener)new RestToXContentListener(channel));
    }
}

