/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.calendar;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class RestGetCalendarsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/calendars/{" + Calendar.ID + "}")).replaces(RestRequest.Method.GET, "/_xpack/ml/calendars/{" + Calendar.ID + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/calendars/").replaces(RestRequest.Method.GET, "/_xpack/ml/calendars/", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/calendars/{" + Calendar.ID + "}")).replaces(RestRequest.Method.POST, "/_xpack/ml/calendars/{" + Calendar.ID + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_ml/calendars/").replaces(RestRequest.Method.POST, "/_xpack/ml/calendars/", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_calendars_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetCalendarsAction.Request request;
        String calendarId = restRequest.param(Calendar.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            try (XContentParser parser = restRequest.contentOrSourceParamParser();){
                request = GetCalendarsAction.Request.parseRequest((String)calendarId, (XContentParser)parser);
            }
        } else {
            request = new GetCalendarsAction.Request();
            if (!Strings.isNullOrEmpty((String)calendarId)) {
                request.setCalendarId(calendarId);
            }
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
        }
        return channel -> client.execute((ActionType)GetCalendarsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

