/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.core.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.stats.CountAccumulator;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.stats.StatsAccumulator;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.job.categorization.GrokPatternCreator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedBucketsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedInfluencersIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedRecordsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.CalendarQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.InfluencersQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.RecordsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.RestartTimeInfo;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ScheduledEventsQueryBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;
import org.elasticsearch.xpack.ml.utils.persistence.MlParserUtils;

public class JobResultsProvider {
    private static final Logger LOGGER = LogManager.getLogger(JobResultsProvider.class);
    private static final int RECORDS_SIZE_PARAM = 10000;
    public static final int BUCKETS_FOR_ESTABLISHED_MEMORY_SIZE = 20;
    private static final double ESTABLISHED_MEMORY_CV_THRESHOLD = 0.1;
    private static final FetchSourceContext REMOVE_QUANTILES_FROM_SOURCE = new FetchSourceContext(true, null, new String[]{ModelSnapshot.QUANTILES.getPreferredName()});
    private final Client client;
    private final Settings settings;
    private final IndexNameExpressionResolver resolver;

    public JobResultsProvider(Client client, Settings settings, IndexNameExpressionResolver resolver) {
        this.client = Objects.requireNonNull(client);
        this.settings = settings;
        this.resolver = resolver;
    }

    public void checkForLeftOverDocuments(final Job job, ActionListener<Boolean> listener) {
        SearchRequestBuilder stateDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{CategorizerState.documentId((String)job.getId(), (int)1), CategorizerState.v54DocumentId((String)job.getId(), (int)1)})).setTrackTotalHits(false).setIndicesOptions(IndicesOptions.strictExpand());
        SearchRequestBuilder quantilesDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{Quantiles.documentId((String)job.getId()), Quantiles.v54DocumentId((String)job.getId())})).setTrackTotalHits(false).setIndicesOptions(IndicesOptions.strictExpand());
        SearchRequestBuilder resultDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobResultsIndexPrefix() + "*"}).setIndicesOptions(IndicesOptions.lenientExpandHidden()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).setTrackTotalHits(false).setSize(1);
        final MultiSearchRequestBuilder msearch = this.client.prepareMultiSearch().add(stateDocSearch).add(resultDocSearch).add(quantilesDocSearch);
        ActionListener.Delegating<MultiSearchResponse, Boolean> searchResponseActionListener = new ActionListener.Delegating<MultiSearchResponse, Boolean>(listener){

            public void onResponse(MultiSearchResponse response) {
                ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
                for (int i = 0; i < response.getResponses().length; ++i) {
                    MultiSearchResponse.Item itemResponse = response.getResponses()[i];
                    if (itemResponse.isFailure()) {
                        Exception e = itemResponse.getFailure();
                        if (e instanceof ClusterBlockException) {
                            for (ClusterBlock block : ((ClusterBlockException)e).blocks()) {
                                if (!"index closed".equals(block.description())) continue;
                                SearchRequest searchRequest = (SearchRequest)((MultiSearchRequest)msearch.request()).requests().get(i);
                                e = ExceptionsHelper.badRequestException((String)"Cannot create job [{}] as it requires closed index {}", (Object[])new Object[]{job.getId(), searchRequest.indices()});
                            }
                        }
                        this.delegate.onFailure(e);
                        return;
                    }
                    searchHits.addAll(Arrays.asList(itemResponse.getResponse().getHits().getHits()));
                }
                if (searchHits.isEmpty()) {
                    this.delegate.onResponse((Object)true);
                } else {
                    int quantileDocCount = 0;
                    int categorizerStateDocCount = 0;
                    int resultDocCount = 0;
                    for (SearchHit hit : searchHits) {
                        if (hit.getId().equals(Quantiles.documentId((String)job.getId())) || hit.getId().equals(Quantiles.v54DocumentId((String)job.getId()))) {
                            ++quantileDocCount;
                            continue;
                        }
                        if (hit.getId().startsWith(CategorizerState.documentPrefix((String)job.getId())) || hit.getId().startsWith(CategorizerState.v54DocumentPrefix((String)job.getId()))) {
                            ++categorizerStateDocCount;
                            continue;
                        }
                        ++resultDocCount;
                    }
                    LOGGER.warn("{} result, {} quantile state and {} categorizer state documents exist for a prior job with Id [{}]", (Object)resultDocCount, (Object)quantileDocCount, (Object)categorizerStateDocCount, (Object)job.getId());
                    this.delegate.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("[" + resultDocCount + "] result and [" + (quantileDocCount + categorizerStateDocCount) + "] state documents exist for a prior job with Id [" + job.getId() + "]. Please create the job with a different Id"), (Object[])new Object[0]));
                }
            }
        };
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((MultiSearchRequest)msearch.request()), (ActionListener)searchResponseActionListener, (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1));
    }

    public void createJobResultIndex(Job job, ClusterState state, ActionListener<Boolean> finalListener) {
        List<String> termFields = job.getAnalysisConfig() != null ? job.getAnalysisConfig().termFields() : Collections.emptyList();
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId());
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias((String)job.getId());
        String tempIndexName = job.getInitialResultsIndexName();
        if (state.getMetadata().hasAlias(tempIndexName)) {
            String[] concreteIndices = this.resolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), new String[]{tempIndexName});
            if (concreteIndices.length == 0) {
                finalListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Cannot create job [{}] as it requires closed index {}", (Object[])new Object[]{job.getId(), tempIndexName}));
                return;
            }
            tempIndexName = concreteIndices[0];
        }
        String indexName = tempIndexName;
        ActionListener indexAndMappingsListener = ActionListener.wrap(success -> {
            IndicesAliasesRequest request = (IndicesAliasesRequest)this.client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(indexName).alias(readAliasName).isHidden(Boolean.valueOf(true)).filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId()))).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(indexName).alias(writeAliasName).isHidden(Boolean.valueOf(true))).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)request, (ActionListener)ActionListener.wrap(r -> finalListener.onResponse((Object)true), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finalListener.onFailure(arg_0));
        if (!state.getMetadata().hasIndex(indexName)) {
            LOGGER.trace("ES API CALL: create index {}", (Object)indexName);
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)createIndexRequest, (ActionListener)ActionListener.wrap(r -> this.getLatestIndexMappingsAndAddTerms(indexName, termFields, (ActionListener<Boolean>)indexAndMappingsListener), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                    LOGGER.info("Index [{}] already exists", (Object)indexName);
                    this.getLatestIndexMappingsAndAddTerms(indexName, termFields, (ActionListener<Boolean>)indexAndMappingsListener);
                } else {
                    finalListener.onFailure(e);
                }
            }), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
        } else {
            MappingMetadata indexMappings = state.metadata().index(indexName).mapping();
            this.addTermsMapping(indexMappings, indexName, termFields, (ActionListener<Boolean>)indexAndMappingsListener);
        }
    }

    private void getLatestIndexMappingsAndAddTerms(String indexName, Collection<String> termFields, ActionListener<Boolean> listener) {
        ActionListener getMappingsListener = ActionListener.wrap(getMappingsResponse -> {
            MappingMetadata indexMappings = (MappingMetadata)((ObjectObjectCursor)getMappingsResponse.getMappings().iterator().next()).value;
            this.addTermsMapping(indexMappings, indexName, termFields, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)this.client.admin().indices().prepareGetMappings(new String[]{indexName}).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)getMappingsRequest, (ActionListener)getMappingsListener, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).getMappings(arg_0, arg_1));
    }

    private void addTermsMapping(MappingMetadata mapping, String indexName, Collection<String> termFields, ActionListener<Boolean> listener) {
        long fieldCountLimit = (Long)MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.get(this.settings);
        if (JobResultsProvider.violatedFieldCountLimit(termFields.size(), fieldCountLimit, mapping)) {
            String message = "Cannot create job in index '" + indexName + "' as the " + MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey() + " setting will be violated";
            listener.onFailure((Exception)new IllegalArgumentException(message));
        } else {
            this.updateIndexMappingWithTermFields(indexName, termFields, listener);
        }
    }

    public static boolean violatedFieldCountLimit(long additionalFieldCount, long fieldCountLimit, MappingMetadata mapping) {
        long numFields = JobResultsProvider.countFields(mapping.sourceAsMap());
        return numFields + additionalFieldCount > fieldCountLimit;
    }

    public static int countFields(Map<String, Object> mapping) {
        Object propertiesNode = mapping.get("properties");
        if (!(propertiesNode instanceof Map)) {
            return 0;
        }
        mapping = (Map)propertiesNode;
        int count = 0;
        for (Map.Entry entry : mapping.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map fieldMapping = (Map)entry.getValue();
                count += JobResultsProvider.countFields(fieldMapping);
            }
            ++count;
        }
        return count;
    }

    private void updateIndexMappingWithTermFields(String indexName, Collection<String> termFields, ActionListener<Boolean> listener) {
        try (XContentBuilder termFieldsMapping = JsonXContent.contentBuilder();){
            JobResultsProvider.createTermFieldsMapping(termFieldsMapping, termFields);
            PutMappingRequest request = (PutMappingRequest)this.client.admin().indices().preparePutMapping(new String[]{indexName}).setSource(termFieldsMapping).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)request, (ActionListener)listener.delegateFailure((l, putMappingResponse) -> l.onResponse((Object)putMappingResponse.isAcknowledged())), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    static void createTermFieldsMapping(XContentBuilder builder, Collection<String> termFields) throws IOException {
        builder.startObject();
        builder.startObject("properties");
        for (String fieldName : termFields) {
            if (!ReservedFieldNames.isValidFieldName((String)fieldName)) continue;
            builder.startObject(fieldName).field("type", "keyword").endObject();
        }
        builder.endObject();
        builder.endObject();
    }

    public void dataCounts(String jobId, Consumer<DataCounts> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        this.searchSingleResult(jobId, DataCounts.TYPE.getPreferredName(), this.createLatestDataCountsSearch(indexName, jobId), (BiFunction)DataCounts.PARSER, result -> handler.accept((DataCounts)result.result), errorHandler, () -> new DataCounts(jobId));
    }

    private SearchRequestBuilder createLatestDataCountsSearch(String indexName, String jobId) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{DataCounts.documentId((String)jobId), DataCounts.v54DocumentId((String)jobId)})).addSort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)DataCounts.LOG_TIME.getPreferredName()).order(SortOrder.DESC)).unmappedType(NumberFieldMapper.NumberType.LONG.typeName()).missing((Object)0L)).addSort(SortBuilders.fieldSort((String)DataCounts.LATEST_RECORD_TIME.getPreferredName()).order(SortOrder.DESC));
    }

    public void timingStats(String jobId, Consumer<TimingStats> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        this.searchSingleResult(jobId, TimingStats.TYPE.getPreferredName(), this.createLatestTimingStatsSearch(indexName, jobId), (BiFunction)TimingStats.PARSER, result -> handler.accept((TimingStats)result.result), errorHandler, () -> new TimingStats(jobId));
    }

    private SearchRequestBuilder createLatestTimingStatsSearch(String indexName, String jobId) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{TimingStats.documentId((String)jobId)})).addSort(SortBuilders.fieldSort((String)TimingStats.BUCKET_COUNT.getPreferredName()).order(SortOrder.DESC));
    }

    public void datafeedTimingStats(List<String> jobIds, ActionListener<Map<String, DatafeedTimingStats>> listener) {
        if (jobIds.isEmpty()) {
            listener.onResponse(Map.of());
            return;
        }
        MultiSearchRequestBuilder msearchRequestBuilder = this.client.prepareMultiSearch();
        for (String jobId : jobIds) {
            String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
            msearchRequestBuilder.add(this.createLatestDatafeedTimingStatsSearch(indexName, jobId));
        }
        MultiSearchRequest msearchRequest = (MultiSearchRequest)msearchRequestBuilder.request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)msearchRequest, (ActionListener)ActionListener.wrap(msearchResponse -> {
            HashMap<String, DatafeedTimingStats> timingStatsByJobId = new HashMap<String, DatafeedTimingStats>();
            for (int i = 0; i < msearchResponse.getResponses().length; ++i) {
                String jobId = (String)jobIds.get(i);
                MultiSearchResponse.Item itemResponse = msearchResponse.getResponses()[i];
                if (itemResponse.isFailure()) {
                    listener.onFailure(itemResponse.getFailure());
                    return;
                }
                SearchResponse searchResponse = itemResponse.getResponse();
                Object[] shardFailures = searchResponse.getShardFailures();
                int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
                if (!CollectionUtils.isEmpty((Object[])shardFailures)) {
                    LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
                    listener.onFailure((Exception)new ElasticsearchException(ExceptionsHelper.shardFailuresToErrorMsg((String)jobId, (ShardSearchFailure[])shardFailures), new Object[0]));
                    return;
                }
                if (unavailableShards > 0) {
                    listener.onFailure((Exception)new ElasticsearchException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards", new Object[0]));
                    return;
                }
                SearchHits hits = searchResponse.getHits();
                long hitsCount = hits.getHits().length;
                if (hitsCount == 0L || hitsCount > 1L) {
                    SearchRequest searchRequest = (SearchRequest)msearchRequest.requests().get(i);
                    LOGGER.debug("Found {} hits for [{}]", (Object)(hitsCount == 0L ? "0" : "multiple"), (Object)new Object[]{searchRequest.indices()});
                    continue;
                }
                SearchHit hit = hits.getHits()[0];
                try {
                    DatafeedTimingStats timingStats = (DatafeedTimingStats)MlParserUtils.parse(hit, DatafeedTimingStats.PARSER);
                    timingStatsByJobId.put(jobId, timingStats);
                    continue;
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    return;
                }
            }
            listener.onResponse(timingStatsByJobId);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1));
    }

    public void datafeedTimingStats(String jobId, Consumer<DatafeedTimingStats> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        this.searchSingleResult(jobId, DatafeedTimingStats.TYPE.getPreferredName(), this.createLatestDatafeedTimingStatsSearch(indexName, jobId), (BiFunction)DatafeedTimingStats.PARSER, result -> handler.accept((DatafeedTimingStats)result.result), errorHandler, () -> new DatafeedTimingStats(jobId));
    }

    private SearchRequestBuilder createLatestDatafeedTimingStatsSearch(String indexName, String jobId) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{DatafeedTimingStats.documentId((String)jobId)})).addSort(SortBuilders.fieldSort((String)DatafeedTimingStats.TOTAL_SEARCH_TIME_MS.getPreferredName()).unmappedType("double").order(SortOrder.DESC));
    }

    public void getAutodetectParams(Job job, String snapshotId, Consumer<AutodetectParams> consumer, Consumer<Exception> errorHandler) {
        String jobId = job.getId();
        ActionListener getScheduledEventsListener = ActionListener.wrap(paramsBuilder -> {
            ScheduledEventsQueryBuilder scheduledEventsQueryBuilder = new ScheduledEventsQueryBuilder();
            scheduledEventsQueryBuilder.start(job.earliestValidTimestamp(paramsBuilder.getDataCounts()));
            this.scheduledEventsForJob(jobId, job.getGroups(), scheduledEventsQueryBuilder, (ActionListener<QueryPage<ScheduledEvent>>)ActionListener.wrap(events -> {
                paramsBuilder.setScheduledEvents(events.results());
                consumer.accept(paramsBuilder.build());
            }, (Consumer)errorHandler));
        }, errorHandler);
        AutodetectParams.Builder paramsBuilder2 = new AutodetectParams.Builder(job.getId());
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        String stateIndex = AnomalyDetectorsIndex.jobStateIndexPattern();
        MultiSearchRequestBuilder msearch = this.client.prepareMultiSearch().add(this.createLatestDataCountsSearch(resultsIndex, jobId)).add(this.createLatestModelSizeStatsSearch(resultsIndex)).add(this.createLatestTimingStatsSearch(resultsIndex, jobId));
        if (snapshotId != null) {
            msearch.add(this.createDocIdSearch(resultsIndex, ModelSnapshot.documentId((String)jobId, (String)snapshotId)));
            msearch.add(this.createDocIdSearch(stateIndex, Quantiles.documentId((String)jobId)));
        }
        for (String filterId : job.getAnalysisConfig().extractReferencedFilters()) {
            msearch.add(this.createDocIdSearch(MlMetaIndex.indexName(), MlFilter.documentId((String)filterId)));
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((MultiSearchRequest)msearch.request()), (ActionListener)ActionListener.wrap(response -> {
            for (int i = 0; i < response.getResponses().length; ++i) {
                MultiSearchResponse.Item itemResponse = response.getResponses()[i];
                if (itemResponse.isFailure()) {
                    errorHandler.accept(itemResponse.getFailure());
                    return;
                }
                SearchResponse searchResponse = itemResponse.getResponse();
                Object[] shardFailures = searchResponse.getShardFailures();
                int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
                if (!CollectionUtils.isEmpty((Object[])shardFailures)) {
                    LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
                    errorHandler.accept((Exception)new ElasticsearchException(ExceptionsHelper.shardFailuresToErrorMsg((String)jobId, (ShardSearchFailure[])shardFailures), new Object[0]));
                    return;
                }
                if (unavailableShards > 0) {
                    errorHandler.accept((Exception)new ElasticsearchException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards", new Object[0]));
                    return;
                }
                SearchHits hits = searchResponse.getHits();
                long hitsCount = hits.getHits().length;
                if (hitsCount == 0L) {
                    SearchRequest searchRequest = (SearchRequest)((MultiSearchRequest)msearch.request()).requests().get(i);
                    LOGGER.debug("Found 0 hits for [{}]", new Object[]{searchRequest.indices()});
                }
                for (SearchHit hit : hits) {
                    try {
                        JobResultsProvider.parseAutodetectParamSearchHit(jobId, paramsBuilder2, hit);
                    }
                    catch (Exception e) {
                        errorHandler.accept(e);
                        return;
                    }
                }
            }
            getScheduledEventsListener.onResponse((Object)paramsBuilder2);
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1));
    }

    public void getAutodetectParams(Job job, Consumer<AutodetectParams> consumer, Consumer<Exception> errorHandler) {
        this.getAutodetectParams(job, job.getModelSnapshotId(), consumer, errorHandler);
    }

    private SearchRequestBuilder createDocIdSearch(String index, String id) {
        return this.client.prepareSearch(new String[]{index}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{id})).setRouting(id);
    }

    private static void parseAutodetectParamSearchHit(String jobId, AutodetectParams.Builder paramsBuilder, SearchHit hit) {
        String hitId = hit.getId();
        if (DataCounts.documentId((String)jobId).equals(hitId)) {
            paramsBuilder.setDataCounts((DataCounts)MlParserUtils.parse(hit, DataCounts.PARSER));
        } else if (TimingStats.documentId((String)jobId).equals(hitId)) {
            paramsBuilder.setTimingStats((TimingStats)MlParserUtils.parse(hit, TimingStats.PARSER));
        } else if (hitId.startsWith(ModelSizeStats.documentIdPrefix((String)jobId))) {
            ModelSizeStats.Builder modelSizeStats = (ModelSizeStats.Builder)MlParserUtils.parse(hit, ModelSizeStats.LENIENT_PARSER);
            paramsBuilder.setModelSizeStats(modelSizeStats == null ? null : modelSizeStats.build());
        } else if (hitId.startsWith(ModelSnapshot.documentIdPrefix((String)jobId))) {
            ModelSnapshot.Builder modelSnapshot = (ModelSnapshot.Builder)MlParserUtils.parse(hit, ModelSnapshot.LENIENT_PARSER);
            paramsBuilder.setModelSnapshot(modelSnapshot == null ? null : modelSnapshot.build());
        } else if (Quantiles.documentId((String)jobId).equals(hit.getId())) {
            paramsBuilder.setQuantiles((Quantiles)MlParserUtils.parse(hit, Quantiles.LENIENT_PARSER));
        } else if (hitId.startsWith("filter_")) {
            paramsBuilder.addFilter(((MlFilter.Builder)MlParserUtils.parse(hit, MlFilter.LENIENT_PARSER)).build());
        } else {
            throw new IllegalStateException("Unexpected Id [" + hitId + "]");
        }
    }

    public void bucketsViaInternalClient(String jobId, BucketsQueryBuilder query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler) {
        this.buckets(jobId, query, handler, errorHandler, this.client);
    }

    public void buckets(String jobId, BucketsQueryBuilder query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) throws ResourceNotFoundException {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(query.build().trackTotalHits(true));
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            SearchHits hits = searchResponse.getHits();
            ArrayList<Bucket> results = new ArrayList<Bucket>();
            for (SearchHit hit : hits.getHits()) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    Bucket bucket2 = (Bucket)Bucket.LENIENT_PARSER.apply(parser, null);
                    results.add(bucket2);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
                }
            }
            if (query.hasTimestamp() && results.isEmpty()) {
                throw QueryPage.emptyQueryPage((ParseField)Bucket.RESULTS_FIELD);
            }
            QueryPage buckets = new QueryPage(results, searchResponse.getHits().getTotalHits().value, Bucket.RESULTS_FIELD);
            if (query.isExpand()) {
                Iterator<Bucket> bucketsToExpand = buckets.results().stream().filter(bucket -> bucket.getBucketInfluencers().size() > 0).iterator();
                this.expandBuckets(jobId, query, (QueryPage<Bucket>)buckets, bucketsToExpand, handler, errorHandler, client);
            } else {
                handler.accept(buckets);
            }
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/buckets/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    private void expandBuckets(String jobId, BucketsQueryBuilder query, QueryPage<Bucket> buckets, Iterator<Bucket> bucketsToExpand, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) {
        if (bucketsToExpand.hasNext()) {
            Consumer<Integer> c = i -> this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
            this.expandBucket(jobId, query.isIncludeInterim(), bucketsToExpand.next(), c, errorHandler, client);
        } else {
            handler.accept(buckets);
        }
    }

    public BatchedResultsIterator<Bucket> newBatchedBucketsIterator(String jobId) {
        return new BatchedBucketsIterator(new OriginSettingClient(this.client, "ml"), jobId);
    }

    public BatchedResultsIterator<AnomalyRecord> newBatchedRecordsIterator(String jobId) {
        return new BatchedRecordsIterator(new OriginSettingClient(this.client, "ml"), jobId);
    }

    public void expandBucket(String jobId, boolean includeInterim, Bucket bucket, Consumer<Integer> consumer, Consumer<Exception> errorHandler, Client client) {
        Consumer<QueryPage<AnomalyRecord>> h = page -> {
            bucket.getRecords().addAll(page.results());
            consumer.accept(bucket.getRecords().size());
        };
        this.bucketRecords(jobId, bucket, 0, 10000, includeInterim, AnomalyRecord.PROBABILITY.getPreferredName(), false, h, errorHandler, client);
    }

    public void bucketRecords(String jobId, Bucket bucket, int from, int size, boolean includeInterim, String sortField, boolean descending, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        RecordsQueryBuilder recordsQueryBuilder = new RecordsQueryBuilder().timestamp(bucket.getTimestamp()).from(from).size(size).includeInterim(includeInterim).sortField(sortField).sortDescending(descending);
        this.records(jobId, recordsQueryBuilder, handler, errorHandler, client);
    }

    public void categoryDefinitions(String jobId, Long categoryId, String partitionFieldValue, boolean augment, Integer from, Integer size, Consumer<QueryPage<CategoryDefinition>> handler, Consumer<Exception> errorHandler, Client client) {
        TermQueryBuilder categoryIdQuery;
        if (categoryId != null && (from != null || size != null)) {
            throw new IllegalStateException("Both categoryId and pageParams are specified");
        }
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search all of category definitions from index {} sort ascending {} from {} size {}", (Object)indexName, (Object)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (categoryId != null) {
            categoryIdQuery = QueryBuilders.termQuery((String)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)categoryId);
        } else if (from != null && size != null) {
            categoryIdQuery = QueryBuilders.existsQuery((String)CategoryDefinition.CATEGORY_ID.getPreferredName());
            sourceBuilder.from(from.intValue()).size(size.intValue()).sort(new FieldSortBuilder(CategoryDefinition.CATEGORY_ID.getPreferredName()).order(SortOrder.ASC));
        } else {
            throw new IllegalStateException("Both categoryId and pageParams are not specified");
        }
        if (partitionFieldValue != null) {
            TermQueryBuilder partitionQuery = QueryBuilders.termQuery((String)CategoryDefinition.PARTITION_FIELD_VALUE.getPreferredName(), (String)partitionFieldValue);
            BoolQueryBuilder combinedQuery = QueryBuilders.boolQuery().must((QueryBuilder)categoryIdQuery).must((QueryBuilder)partitionQuery);
            sourceBuilder.query((QueryBuilder)combinedQuery);
        } else {
            sourceBuilder.query((QueryBuilder)categoryIdQuery);
        }
        sourceBuilder.trackTotalHits(true);
        searchRequest.source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            SearchHit[] hits = searchResponse.getHits().getHits();
            ArrayList<CategoryDefinition> results = new ArrayList<CategoryDefinition>(hits.length);
            for (SearchHit hit : hits) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    CategoryDefinition categoryDefinition = (CategoryDefinition)CategoryDefinition.LENIENT_PARSER.apply(parser, null);
                    if (augment) {
                        this.augmentWithGrokPattern(categoryDefinition);
                    }
                    results.add(categoryDefinition);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse category definition", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits().value, CategoryDefinition.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/categories/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    void augmentWithGrokPattern(CategoryDefinition categoryDefinition) {
        List examples = categoryDefinition.getExamples();
        String regex = categoryDefinition.getRegex();
        if (examples.isEmpty() || regex.isEmpty()) {
            categoryDefinition.setGrokPattern("");
        } else {
            categoryDefinition.setGrokPattern(GrokPatternCreator.findBestGrokMatchFromExamples(categoryDefinition.getJobId(), regex, examples));
        }
    }

    public void records(String jobId, RecordsQueryBuilder recordsQueryBuilder, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchSourceBuilder searchSourceBuilder = recordsQueryBuilder.build();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        searchRequest.source(recordsQueryBuilder.build().trackTotalHits(true));
        LOGGER.trace("ES API CALL: search all of records from index {} with query {}", (Object)indexName, (Object)searchSourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            ArrayList<AnomalyRecord> results = new ArrayList<AnomalyRecord>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    results.add((AnomalyRecord)AnomalyRecord.LENIENT_PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse records", (Throwable)e, new Object[0]);
                }
            }
            QueryPage queryPage = new QueryPage(results, searchResponse.getHits().getTotalHits().value, AnomalyRecord.RESULTS_FIELD);
            handler.accept(queryPage);
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/records/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    public void influencers(String jobId, InfluencersQueryBuilder.InfluencersQuery query, Consumer<QueryPage<Influencer>> handler, Consumer<Exception> errorHandler, Client client) {
        QueryBuilder fb = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(Influencer.INFLUENCER_SCORE.getPreferredName(), query.getInfluencerScoreFilter()).interim(query.isIncludeInterim()).build();
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[4];
        supplierArray[0] = () -> indexName;
        supplierArray[1] = () -> query.getSortField() != null ? " with sort " + (query.isSortDescending() ? "descending" : "ascending") + " on field " + query.getSortField() : "";
        supplierArray[2] = query::getFrom;
        supplierArray[3] = query::getSize;
        LOGGER.trace("ES API CALL: search all of influencers from index {}{}  with filter from {} size {}", supplierArray);
        BoolQueryBuilder qb = new BoolQueryBuilder().filter(fb).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"influencer"}));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        FieldSortBuilder sb = query.getSortField() == null ? SortBuilders.fieldSort((String)"_doc") : (FieldSortBuilder)new FieldSortBuilder(query.getSortField()).order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)qb).from(query.getFrom()).size(query.getSize()).sort((SortBuilder)sb).trackTotalHits(true));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            ArrayList<Influencer> influencers = new ArrayList<Influencer>();
            for (SearchHit hit : response.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    influencers.add((Influencer)Influencer.LENIENT_PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse influencer", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(influencers, response.getHits().getTotalHits().value, Influencer.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/influencers/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    public BatchedResultsIterator<Influencer> newBatchedInfluencersIterator(String jobId) {
        return new BatchedInfluencersIterator(new OriginSettingClient(this.client, "ml"), jobId);
    }

    public void getModelSnapshot(String jobId, @Nullable String modelSnapshotId, Consumer<Result<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (modelSnapshotId == null) {
            handler.accept(null);
            return;
        }
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequestBuilder search = this.createDocIdSearch(resultsIndex, ModelSnapshot.documentId((String)jobId, (String)modelSnapshotId));
        this.searchSingleResult(jobId, ModelSnapshot.TYPE.getPreferredName(), search, (BiFunction)ModelSnapshot.LENIENT_PARSER, result -> handler.accept(result.result == null ? null : new Result(result.index, (Object)((ModelSnapshot.Builder)result.result).build())), errorHandler, () -> null);
    }

    public void modelSnapshots(String jobId, int from, int size, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        this.modelSnapshots(jobId, from, size, null, true, (QueryBuilder)QueryBuilders.matchAllQuery(), handler, errorHandler);
    }

    public void modelSnapshots(String jobId, int from, int size, String startEpochMs, String endEpochMs, String sortField, boolean sortDescending, String snapshotId, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        String[] snapshotIds = Strings.splitStringByCommaToArray((String)snapshotId);
        QueryBuilder qb = new ResultsFilterBuilder().resourceTokenFilters(ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), snapshotIds).timeRange(Result.TIMESTAMP.getPreferredName(), startEpochMs, endEpochMs).build();
        this.modelSnapshots(jobId, from, size, sortField, sortDescending, qb, handler, errorHandler);
    }

    private void modelSnapshots(String jobId, int from, int size, String sortField, boolean sortDescending, QueryBuilder qb, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (Strings.isEmpty((CharSequence)sortField)) {
            sortField = ModelSnapshot.TIMESTAMP.getPreferredName();
        }
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).must(qb);
        FieldSortBuilder sb = (FieldSortBuilder)new FieldSortBuilder(sortField).order(sortDescending ? SortOrder.DESC : SortOrder.ASC);
        if (sortField.equals(ModelSnapshot.MIN_VERSION.getPreferredName())) {
            sb.missing((Object)"6.3.0").unmappedType("keyword");
        }
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search all model snapshots from index {} sort ascending {} with filter after sort from {} size {}", (Object)indexName, (Object)sortField, (Object)from, (Object)size);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().sort((SortBuilder)sb).query((QueryBuilder)finalQuery).from(from).size(size).trackTotalHits(true).fetchSource(REMOVE_QUANTILES_FROM_SOURCE);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions())).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            ArrayList<ModelSnapshot> results = new ArrayList<ModelSnapshot>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                results.add(ModelSnapshot.fromJson((BytesReference)hit.getSourceRef()));
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits().value, ModelSnapshot.RESULTS_FIELD);
            handler.accept(result);
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public QueryPage<ModelPlot> modelPlot(String jobId, int from, int size) {
        SearchResponse searchResponse;
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search model plots from index {} from {} size {}", (Object)indexName, (Object)from, (Object)size);
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).setQuery((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"model_plot"})).setFrom(from).setSize(size).setTrackTotalHits(true).get();
        }
        ArrayList<ModelPlot> results = new ArrayList<ModelPlot>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            BytesReference source = hit.getSourceRef();
            try (StreamInput stream = source.streamInput();
                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                ModelPlot modelPlot = (ModelPlot)ModelPlot.LENIENT_PARSER.apply(parser, null);
                results.add(modelPlot);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse modelPlot", (Throwable)e, new Object[0]);
            }
        }
        return new QueryPage(results, searchResponse.getHits().getTotalHits().value, ModelPlot.RESULTS_FIELD);
    }

    public QueryPage<CategorizerStats> categorizerStats(String jobId, int from, int size) {
        SearchResponse searchResponse;
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search categorizer stats from index {} from {} size {}", (Object)indexName, (Object)from, (Object)size);
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).setQuery((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"categorizer_stats"})).setFrom(from).setSize(size).setTrackTotalHits(true).get();
        }
        ArrayList<CategorizerStats> results = new ArrayList<CategorizerStats>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            BytesReference source = hit.getSourceRef();
            try (StreamInput stream = source.streamInput();
                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                CategorizerStats categorizerStats = ((CategorizerStats.Builder)CategorizerStats.LENIENT_PARSER.apply(parser, null)).build();
                results.add(categorizerStats);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse categorizerStats", (Throwable)e, new Object[0]);
            }
        }
        return new QueryPage(results, searchResponse.getHits().getTotalHits().value, ModelPlot.RESULTS_FIELD);
    }

    public void modelSizeStats(String jobId, Consumer<ModelSizeStats> handler, Consumer<Exception> errorHandler) {
        LOGGER.trace("ES API CALL: search latest {} for job {}", (Object)"model_size_stats", (Object)jobId);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        this.searchSingleResult(jobId, "model_size_stats", this.createLatestModelSizeStatsSearch(indexName), (BiFunction)ModelSizeStats.LENIENT_PARSER, result -> handler.accept(((ModelSizeStats.Builder)result.result).build()), errorHandler, () -> new ModelSizeStats.Builder(jobId));
    }

    private <U, T> void searchSingleResult(String jobId, String resultDescription, SearchRequestBuilder search, BiFunction<XContentParser, U, T> objectParser, Consumer<Result<T>> handler, Consumer<Exception> errorHandler, Supplier<T> notFoundSupplier) {
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)search.request()), (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                LOGGER.trace("No {} for job with id {}", (Object)resultDescription, (Object)jobId);
                handler.accept(new Result(null, notFoundSupplier.get()));
            } else if (hits.length == 1) {
                try {
                    Object result = MlParserUtils.parse(hits[0], objectParser);
                    handler.accept(new Result(hits[0].getIndex(), result));
                }
                catch (Exception e) {
                    errorHandler.accept(e);
                }
            } else {
                errorHandler.accept(new IllegalStateException("Search for unique [" + resultDescription + "] returned [" + hits.length + "] hits even though size was 1"));
            }
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private SearchRequestBuilder createLatestModelSizeStatsSearch(String indexName) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_size_stats")).addSort(SortBuilders.fieldSort((String)ModelSizeStats.LOG_TIME_FIELD.getPreferredName()).order(SortOrder.DESC));
    }

    public void getEstablishedMemoryUsage(String jobId, Date latestBucketTimestamp, ModelSizeStats latestModelSizeStats, Consumer<Long> handler, Consumer<Exception> errorHandler) {
        if (latestModelSizeStats != null) {
            this.calculateEstablishedMemoryUsage(jobId, latestBucketTimestamp, latestModelSizeStats, handler, errorHandler);
        } else {
            this.modelSizeStats(jobId, modelSizeStats -> this.calculateEstablishedMemoryUsage(jobId, latestBucketTimestamp, (ModelSizeStats)modelSizeStats, handler, errorHandler), errorHandler);
        }
    }

    void calculateEstablishedMemoryUsage(String jobId, Date latestBucketTimestamp, ModelSizeStats latestModelSizeStats, Consumer<Long> handler, Consumer<Exception> errorHandler) {
        assert (latestModelSizeStats != null);
        if (latestModelSizeStats.getAssignmentMemoryBasis() != null) {
            switch (latestModelSizeStats.getAssignmentMemoryBasis()) {
                case MODEL_MEMORY_LIMIT: {
                    handler.accept(0L);
                    return;
                }
                case CURRENT_MODEL_BYTES: {
                    handler.accept(latestModelSizeStats.getModelBytes());
                    return;
                }
                case PEAK_MODEL_BYTES: {
                    Long storedPeak = latestModelSizeStats.getPeakModelBytes();
                    handler.accept(storedPeak != null ? storedPeak.longValue() : latestModelSizeStats.getModelBytes());
                    return;
                }
            }
        }
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        Consumer<QueryPage<Bucket>> bucketHandler = buckets -> {
            if (buckets.results().size() == 1) {
                String searchFromTimeMs = Long.toString(((Bucket)buckets.results().get(0)).getTimestamp().getTime());
                SearchRequestBuilder search = this.client.prepareSearch(new String[]{indexName}).setSize(0).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)searchFromTimeMs)).filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_size_stats"))).addAggregation((AggregationBuilder)AggregationBuilders.extendedStats((String)"es").field(ModelSizeStats.MODEL_BYTES_FIELD.getPreferredName()));
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)search.request()), (ActionListener)ActionListener.wrap(response -> {
                    List aggregations = response.getAggregations().asList();
                    if (aggregations.size() == 1) {
                        ExtendedStats extendedStats = (ExtendedStats)aggregations.get(0);
                        long count = extendedStats.getCount();
                        if (count <= 1L) {
                            handler.accept(latestModelSizeStats.getModelBytes());
                        } else {
                            double coefficientOfVaration = extendedStats.getStdDeviation() / extendedStats.getAvg();
                            LOGGER.trace("[{}] Coefficient of variation [{}] when calculating established memory use", (Object)jobId, (Object)coefficientOfVaration);
                            if (coefficientOfVaration <= 0.1) {
                                handler.accept(latestModelSizeStats.getModelBytes());
                            } else {
                                handler.accept(0L);
                            }
                        }
                    } else {
                        handler.accept(0L);
                    }
                }, (Consumer)errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
            } else {
                LOGGER.trace("[{}] Insufficient history to calculate established memory use", (Object)jobId);
                handler.accept(0L);
            }
        };
        BucketsQueryBuilder bucketQuery = new BucketsQueryBuilder().end(latestBucketTimestamp != null ? Long.toString(latestBucketTimestamp.getTime() + 1L) : null).sortField(Result.TIMESTAMP.getPreferredName()).sortDescending(true).from(19).size(1).includeInterim(false);
        this.bucketsViaInternalClient(jobId, bucketQuery, bucketHandler, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                handler.accept(0L);
            } else {
                errorHandler.accept((Exception)e);
            }
        });
    }

    public void scheduledEventsForJob(String jobId, List<String> jobGroups, ScheduledEventsQueryBuilder queryBuilder, ActionListener<QueryPage<ScheduledEvent>> handler) {
        ActionListener calendarsListener = ActionListener.wrap(calendars -> {
            if (calendars.results().isEmpty()) {
                handler.onResponse((Object)new QueryPage(Collections.emptyList(), 0L, ScheduledEvent.RESULTS_FIELD));
                return;
            }
            String[] calendarIds = (String[])calendars.results().stream().map(Calendar::getId).toArray(String[]::new);
            queryBuilder.calendarIds(calendarIds);
            this.scheduledEvents(queryBuilder, handler);
        }, arg_0 -> handler.onFailure(arg_0));
        CalendarQueryBuilder query = new CalendarQueryBuilder().jobId(jobId).jobGroups(jobGroups);
        this.calendars(query, (ActionListener<QueryPage<Calendar>>)calendarsListener);
    }

    public void scheduledEvents(ScheduledEventsQueryBuilder query, ActionListener<QueryPage<ScheduledEvent>> handler) {
        SearchRequestBuilder request = this.client.prepareSearch(new String[]{MlMetaIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(query.build()).setTrackTotalHits(true);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)request.request()), (ActionListener)ActionListener.wrap(response -> {
            ArrayList<ScheduledEvent> events = new ArrayList<ScheduledEvent>();
            SearchHit[] hits = response.getHits().getHits();
            try {
                for (SearchHit hit : hits) {
                    ScheduledEvent.Builder event = (ScheduledEvent.Builder)MlParserUtils.parse(hit, ScheduledEvent.LENIENT_PARSER);
                    event.eventId(hit.getId());
                    events.add(event.build());
                }
                handler.onResponse((Object)new QueryPage(events, response.getHits().getTotalHits().value, ScheduledEvent.RESULTS_FIELD));
            }
            catch (Exception e) {
                handler.onFailure(e);
            }
        }, arg_0 -> handler.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void setRunningForecastsToFailed(String jobId, ActionListener<Boolean> listener) {
        BoolQueryBuilder forecastQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_forecast_request_stats")).filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId)).filter((QueryBuilder)QueryBuilders.termsQuery((String)ForecastRequestStats.STATUS.getPreferredName(), (String[])new String[]{ForecastRequestStats.ForecastRequestStatus.SCHEDULED.toString(), ForecastRequestStats.ForecastRequestStatus.STARTED.toString()}));
        UpdateByQueryRequest request = (UpdateByQueryRequest)((UpdateByQueryRequest)((UpdateByQueryRequest)((UpdateByQueryRequest)new UpdateByQueryRequest(new String[]{AnomalyDetectorsIndex.resultsWriteAlias((String)jobId)}).setQuery((QueryBuilder)forecastQuery).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setAbortOnVersionConflict(false)).setMaxRetries(3)).setRefresh(true)).setScript(new Script("ctx._source.forecast_status='failed';ctx._source.forecast_messages=['forecast unable to complete as native process was killed.']"));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            if (response.getUpdated() > 0L) {
                LOGGER.warn("[{}] set [{}] forecasts to failed", (Object)jobId, (Object)response.getUpdated());
            }
            if (response.getBulkFailures().size() > 0) {
                LOGGER.warn("[{}] failed to set [{}] forecasts to failed. Bulk failures experienced {}", (Object)jobId, (Object)(response.getTotal() - response.getUpdated()), response.getBulkFailures().stream().map(BulkItemResponse.Failure::getMessage).collect(Collectors.toList()));
            }
            listener.onResponse((Object)true);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getForecastRequestStats(String jobId, String forecastId, Consumer<ForecastRequestStats> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequestBuilder forecastSearch = this.client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{ForecastRequestStats.documentId((String)jobId, (String)forecastId)}));
        this.searchSingleResult(jobId, ForecastRequestStats.RESULTS_FIELD.getPreferredName(), forecastSearch, (BiFunction)ForecastRequestStats.LENIENT_PARSER, result -> handler.accept((ForecastRequestStats)result.result), errorHandler, () -> null);
    }

    public void getForecastStats(String jobId, Consumer<ForecastStats> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        TermsQueryBuilder termQuery = new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"model_forecast_request_stats"});
        TermsQueryBuilder jobQuery = new TermsQueryBuilder(Job.ID.getPreferredName(), new String[]{jobId});
        BoolQueryBuilder finalQuery = new BoolQueryBuilder().filter((QueryBuilder)termQuery).filter((QueryBuilder)jobQuery);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)finalQuery);
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.stats((String)"memory_bytes").field(ForecastRequestStats.MEMORY_USAGE.getPreferredName()));
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.stats((String)"records").field(ForecastRequestStats.PROCESSED_RECORD_COUNT.getPreferredName()));
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.stats((String)"processing_time_ms").field(ForecastRequestStats.PROCESSING_TIME_MS.getPreferredName()));
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"status").field(ForecastRequestStats.STATUS.getPreferredName()));
        sourceBuilder.size(0);
        sourceBuilder.trackTotalHits(true);
        searchRequest.source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            long totalHits = searchResponse.getHits().getTotalHits().value;
            Aggregations aggregations = searchResponse.getAggregations();
            if (totalHits == 0L || aggregations == null) {
                handler.accept(new ForecastStats());
                return;
            }
            Map aggregationsAsMap = aggregations.asMap();
            StatsAccumulator memoryStats = StatsAccumulator.fromStatsAggregation((Stats)((Stats)aggregationsAsMap.get("memory_bytes")));
            StatsAccumulator recordStats = StatsAccumulator.fromStatsAggregation((Stats)((Stats)aggregationsAsMap.get("records")));
            StatsAccumulator runtimeStats = StatsAccumulator.fromStatsAggregation((Stats)((Stats)aggregationsAsMap.get("processing_time_ms")));
            CountAccumulator statusCount = CountAccumulator.fromTermsAggregation((StringTerms)((StringTerms)aggregationsAsMap.get("status")));
            ForecastStats forecastStats = new ForecastStats(totalHits, memoryStats, recordStats, runtimeStats, statusCount);
            handler.accept(forecastStats);
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void updateCalendar(String calendarId, Set<String> jobIdsToAdd, Set<String> jobIdsToRemove, Consumer<Calendar> handler, Consumer<Exception> errorHandler) {
        ActionListener getCalendarListener = ActionListener.wrap(calendar -> {
            HashSet currentJobs = new HashSet(calendar.getJobIds());
            for (String jobToRemove : jobIdsToRemove) {
                if (currentJobs.contains(jobToRemove)) continue;
                errorHandler.accept((Exception)ExceptionsHelper.badRequestException((String)("Cannot remove [" + jobToRemove + "] as it is not present in calendar [" + calendarId + "]"), (Object[])new Object[0]));
                return;
            }
            currentJobs.addAll(jobIdsToAdd);
            currentJobs.removeAll(jobIdsToRemove);
            Calendar updatedCalendar = new Calendar(calendar.getId(), new ArrayList(currentJobs), calendar.getDescription());
            UpdateRequest updateRequest = new UpdateRequest(MlMetaIndex.indexName(), updatedCalendar.documentId());
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                updateRequest.doc(updatedCalendar.toXContent(builder, ToXContent.EMPTY_PARAMS));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialise calendar with id [" + updatedCalendar.getId() + "]", e);
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(response -> handler.accept(updatedCalendar), (Consumer)errorHandler), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
        }, errorHandler);
        this.calendar(calendarId, (ActionListener<Calendar>)getCalendarListener);
    }

    public void calendars(CalendarQueryBuilder queryBuilder, ActionListener<QueryPage<Calendar>> listener) {
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{MlMetaIndex.indexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTrackTotalHits(true).setSource(queryBuilder.build()).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            SearchHit[] hits = response.getHits().getHits();
            try {
                if (!queryBuilder.isForAllCalendars() && hits.length == 0) {
                    listener.onFailure(queryBuilder.buildNotFoundException());
                    return;
                }
                for (SearchHit hit : hits) {
                    calendars.add(((Calendar.Builder)MlParserUtils.parse(hit, Calendar.LENIENT_PARSER)).build());
                }
                listener.onResponse((Object)new QueryPage(calendars, response.getHits().getTotalHits().value, Calendar.RESULTS_FIELD));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void removeJobFromCalendars(String jobId, ActionListener<Boolean> listener) {
        ActionListener updateCalendarsListener = ActionListener.wrap(r -> listener.onResponse((Object)(!r.hasFailures() ? 1 : 0)), arg_0 -> listener.onFailure(arg_0));
        ActionListener getCalendarsListener = ActionListener.wrap(r -> {
            BulkRequestBuilder bulkUpdate = this.client.prepareBulk();
            bulkUpdate.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            for (Calendar calendar : r.results()) {
                List ids = calendar.getJobIds().stream().filter(jId -> !jobId.equals(jId)).collect(Collectors.toList());
                Calendar newCalendar = new Calendar(calendar.getId(), ids, calendar.getDescription());
                UpdateRequest updateRequest = new UpdateRequest(MlMetaIndex.indexName(), newCalendar.documentId());
                try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                    updateRequest.doc(newCalendar.toXContent(builder, ToXContent.EMPTY_PARAMS));
                }
                catch (IOException e) {
                    listener.onFailure((Exception)new IllegalStateException("Failed to serialise calendar with id [" + newCalendar.getId() + "]", e));
                    return;
                }
                bulkUpdate.add(updateRequest);
            }
            if (bulkUpdate.numberOfActions() > 0) {
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkUpdate.request()), (ActionListener)updateCalendarsListener);
            } else {
                listener.onResponse((Object)true);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        CalendarQueryBuilder query = new CalendarQueryBuilder().jobId(jobId);
        this.calendars(query, (ActionListener<QueryPage<Calendar>>)getCalendarsListener);
    }

    public void calendar(final String calendarId, final ActionListener<Calendar> listener) {
        GetRequest getRequest = new GetRequest(MlMetaIndex.indexName(), Calendar.documentId((String)calendarId));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getDocResponse) {
                block15: {
                    try {
                        if (getDocResponse.isExists()) {
                            BytesReference docSource = getDocResponse.getSourceAsBytesRef();
                            try (StreamInput stream = docSource.streamInput();
                                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                                Calendar calendar = ((Calendar.Builder)Calendar.LENIENT_PARSER.apply(parser, null)).build();
                                listener.onResponse((Object)calendar);
                                break block15;
                            }
                        }
                        this.onFailure((Exception)new ResourceNotFoundException("No calendar with id [" + calendarId + "]", new Object[0]));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("No calendar with id [" + calendarId + "]", new Object[0]));
                } else {
                    listener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }

    public void getRestartTimeInfo(String jobId, ActionListener<RestartTimeInfo> listener) {
        AtomicReference latestFinalBucketHolder = new AtomicReference();
        Consumer<DataCounts> dataCountsHandler = dataCounts -> listener.onResponse((Object)new RestartTimeInfo(latestFinalBucketHolder.get() == null ? null : Long.valueOf(((Bucket)latestFinalBucketHolder.get()).getTimestamp().getTime()), dataCounts.getLatestRecordTimeStamp() == null ? null : Long.valueOf(dataCounts.getLatestRecordTimeStamp().getTime()), dataCounts.getInputRecordCount() > 0L));
        ActionListener latestFinalBucketListener = ActionListener.wrap(latestFinalBucket -> {
            latestFinalBucketHolder.set(latestFinalBucket);
            this.dataCounts(jobId, dataCountsHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0));
        this.getLatestFinalBucket(jobId, (ActionListener<Bucket>)latestFinalBucketListener);
    }

    private void getLatestFinalBucket(String jobId, ActionListener<Bucket> listener) {
        BucketsQueryBuilder latestBucketQuery = new BucketsQueryBuilder().sortField(Result.TIMESTAMP.getPreferredName()).sortDescending(true).size(1).includeInterim(false);
        this.bucketsViaInternalClient(jobId, latestBucketQuery, queryPage -> {
            if (queryPage.results().isEmpty()) {
                listener.onResponse(null);
            } else {
                listener.onResponse((Object)((Bucket)queryPage.results().get(0)));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    static Exception mapAuthFailure(Exception e, String jobId, String mappedActionName) {
        if (e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).status() == RestStatus.FORBIDDEN) {
            e = Exceptions.authorizationError((String)(e.getMessage().replaceFirst("action \\[.*?\\]", "action [" + mappedActionName + "]") + " for job [{}]"), (Object[])new Object[]{jobId});
        }
        return e;
    }
}

