/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.process;

import java.time.Instant;
import java.util.Iterator;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ml.inference.deployment.PyTorchResult;
import org.elasticsearch.xpack.ml.inference.pytorch.process.NativePyTorchProcess;

public class PyTorchResultProcessor {
    private static final Logger logger = LogManager.getLogger(PyTorchResultProcessor.class);
    private final ConcurrentMap<String, PendingResult> pendingResults = new ConcurrentHashMap<String, PendingResult>();
    private final String deploymentId;
    private volatile boolean isStopping;
    private final LongSummaryStatistics timingStats;
    private Instant lastUsed;

    public PyTorchResultProcessor(String deploymentId) {
        this.deploymentId = Objects.requireNonNull(deploymentId);
        this.timingStats = new LongSummaryStatistics();
    }

    public void registerRequest(String requestId, ActionListener<PyTorchResult> listener) {
        this.pendingResults.computeIfAbsent(requestId, k -> new PendingResult(listener));
    }

    public void ignoreResposeWithoutNotifying(String requestId) {
        this.pendingResults.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(NativePyTorchProcess process) {
        try {
            Iterator<PyTorchResult> iterator = process.readResults();
            while (iterator.hasNext()) {
                PyTorchResult result = iterator.next();
                logger.trace(() -> new ParameterizedMessage("[{}] Parsed result with id [{}]", (Object)this.deploymentId, (Object)result.getRequestId()));
                this.processResult(result);
                PendingResult pendingResult2 = (PendingResult)this.pendingResults.remove(result.getRequestId());
                if (pendingResult2 == null) {
                    logger.debug(() -> new ParameterizedMessage("[{}] no pending result for [{}]", (Object)this.deploymentId, (Object)result.getRequestId()));
                    continue;
                }
                pendingResult2.listener.onResponse((Object)result);
            }
        }
        catch (Exception e) {
            if (!this.isStopping) {
                logger.error((Message)new ParameterizedMessage("[{}] Error processing results", (Object)this.deploymentId), (Throwable)e);
            }
            this.pendingResults.forEach((id, pendingResult) -> pendingResult.listener.onResponse((Object)new PyTorchResult((String)id, null, null, (String)(this.isStopping ? "inference canceled as process is stopping" : "inference native process died unexpectedly with failure [" + e.getMessage() + "]"))));
            this.pendingResults.clear();
        }
        finally {
            this.pendingResults.forEach((id, pendingResult) -> pendingResult.listener.onResponse((Object)new PyTorchResult((String)id, null, null, "inference canceled as process is stopping")));
            this.pendingResults.clear();
        }
        logger.debug(() -> new ParameterizedMessage("[{}] Results processing finished", (Object)this.deploymentId));
    }

    public synchronized LongSummaryStatistics getTimingStats() {
        return new LongSummaryStatistics(this.timingStats.getCount(), this.timingStats.getMin(), this.timingStats.getMax(), this.timingStats.getSum());
    }

    private synchronized void processResult(PyTorchResult result) {
        if (!result.isError()) {
            this.timingStats.accept(result.getTimeMs());
            this.lastUsed = Instant.now();
        }
    }

    public synchronized Instant getLastUsed() {
        return this.lastUsed;
    }

    public int numberOfPendingResults() {
        return this.pendingResults.size();
    }

    public void stop() {
        this.isStopping = true;
    }

    public static class PendingResult {
        public final ActionListener<PyTorchResult> listener;

        public PendingResult(ActionListener<PyTorchResult> listener) {
            this.listener = Objects.requireNonNull(listener);
        }
    }
}

