/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;

public class ChunkedTrainedModelRestorer {
    private static final Logger logger = LogManager.getLogger(ChunkedTrainedModelRestorer.class);
    private static final int MAX_NUM_DEFINITION_DOCS = 20;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ExecutorService executorService;
    private final String modelId;
    private String index = ".ml-inference-*";
    private int searchSize = 10;
    private int numDocsWritten = 0;

    public ChunkedTrainedModelRestorer(String modelId, Client client, ExecutorService executorService, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.executorService = executorService;
        this.xContentRegistry = xContentRegistry;
        this.modelId = modelId;
    }

    public void setSearchSize(int searchSize) {
        if (searchSize > 20) {
            throw new IllegalArgumentException("search size [" + searchSize + "] cannot be bigger than [20]");
        }
        if (searchSize <= 0) {
            throw new IllegalArgumentException("search size [" + searchSize + "] must be greater than 0");
        }
        this.searchSize = searchSize;
    }

    public void setSearchIndex(String indexNameOrPattern) {
        this.index = indexNameOrPattern;
    }

    public int getNumDocsWritten() {
        return this.numDocsWritten;
    }

    public void restoreModelDefinition(CheckedFunction<TrainedModelDefinitionDoc, Boolean, IOException> modelConsumer, Consumer<Boolean> successConsumer, Consumer<Exception> errorConsumer) {
        logger.debug("[{}] restoring model", (Object)this.modelId);
        SearchRequest searchRequest = ChunkedTrainedModelRestorer.buildSearch(this.client, this.modelId, this.index, this.searchSize);
        this.executorService.execute(() -> this.doSearch(searchRequest, modelConsumer, successConsumer, errorConsumer));
    }

    private void doSearch(SearchRequest searchRequest, CheckedFunction<TrainedModelDefinitionDoc, Boolean, IOException> modelConsumer, Consumer<Boolean> successConsumer, Consumer<Exception> errorConsumer) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            boolean endOfSearch;
            if (searchResponse.getHits().getHits().length == 0) {
                errorConsumer.accept((Exception)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model definition [{0}]", (Object[])new Object[]{this.modelId}), new Object[0]));
                return;
            }
            int lastNum = this.numDocsWritten - 1;
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                try {
                    TrainedModelDefinitionDoc doc = ChunkedTrainedModelRestorer.parseModelDefinitionDocLenientlyFromSource(hit.getSourceRef(), this.modelId, this.xContentRegistry);
                    lastNum = doc.getDocNum();
                    boolean continueSearching = (Boolean)modelConsumer.apply((Object)doc);
                    if (continueSearching) continue;
                    successConsumer.accept(Boolean.FALSE);
                    return;
                }
                catch (IOException e) {
                    logger.error((Message)new ParameterizedMessage("[{}] error writing model definition", (Object)this.modelId), (Throwable)e);
                    errorConsumer.accept(e);
                    return;
                }
            }
            this.numDocsWritten += searchResponse.getHits().getHits().length;
            boolean bl = endOfSearch = searchResponse.getHits().getHits().length < this.searchSize || searchResponse.getHits().getTotalHits().value == (long)this.numDocsWritten;
            if (endOfSearch) {
                successConsumer.accept(Boolean.TRUE);
            } else {
                SearchHit lastHit = searchResponse.getHits().getAt(searchResponse.getHits().getHits().length - 1);
                SearchRequestBuilder searchRequestBuilder = ChunkedTrainedModelRestorer.buildSearchBuilder(this.client, this.modelId, this.index, this.searchSize);
                searchRequestBuilder.searchAfter(new Object[]{lastHit.getIndex(), lastNum});
                this.executorService.execute(() -> this.doSearch((SearchRequest)searchRequestBuilder.request(), modelConsumer, successConsumer, errorConsumer));
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                errorConsumer.accept((Exception)new ResourceNotFoundException(Messages.getMessage((String)"Could not find trained model definition [{0}]", (Object[])new Object[]{this.modelId}), new Object[0]));
            } else {
                errorConsumer.accept((Exception)e);
            }
        }));
    }

    private static SearchRequestBuilder buildSearchBuilder(Client client, String modelId, String index, int searchSize) {
        return client.prepareSearch(new String[]{index}).setQuery((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), (String)modelId)).filter((QueryBuilder)QueryBuilders.termQuery((String)InferenceIndexConstants.DOC_TYPE.getPreferredName(), (String)"trained_model_definition_doc")))).setSize(searchSize).setTrackTotalHits(true).addSort("_index", SortOrder.DESC).addSort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)TrainedModelDefinitionDoc.DOC_NUM.getPreferredName()).order(SortOrder.ASC)).unmappedType("long"));
    }

    public static SearchRequest buildSearch(Client client, String modelId, String index, int searchSize) {
        return (SearchRequest)ChunkedTrainedModelRestorer.buildSearchBuilder(client, modelId, index, searchSize).request();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static TrainedModelDefinitionDoc parseModelDefinitionDocLenientlyFromSource(BytesReference source, String modelId, NamedXContentRegistry xContentRegistry) throws IOException {
        try (StreamInput stream = source.streamInput();){
            TrainedModelDefinitionDoc trainedModelDefinitionDoc;
            block14: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    trainedModelDefinitionDoc = TrainedModelDefinitionDoc.fromXContent(parser, true).build();
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return trainedModelDefinitionDoc;
        }
        catch (IOException e) {
            logger.error((Message)new ParameterizedMessage("[{}] failed to parse model definition", (Object)modelId), (Throwable)e);
            throw e;
        }
    }
}

