/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.ArrayList;
import java.util.List;

public class TokenizationResult {
    private final List<String> vocab;
    private final List<Tokenization> tokenizations = new ArrayList<Tokenization>();
    private int maxLength;

    public TokenizationResult(List<String> vocab) {
        this.vocab = vocab;
        this.maxLength = -1;
    }

    public boolean anyTruncated() {
        return this.tokenizations.stream().anyMatch(Tokenization::isTruncated);
    }

    public String getFromVocab(int tokenId) {
        return this.vocab.get(tokenId);
    }

    public List<Tokenization> getTokenizations() {
        return this.tokenizations;
    }

    public void addTokenization(String input, boolean isTruncated, String[] tokens, int[] tokenIds, int[] tokenMap) {
        this.maxLength = Math.max(this.maxLength, tokenIds.length);
        this.tokenizations.add(new Tokenization(input, isTruncated, tokens, tokenIds, tokenMap));
    }

    public void addTokenization(Tokenization tokenization) {
        this.maxLength = Math.max(this.maxLength, tokenization.tokenIds.length);
        this.tokenizations.add(tokenization);
    }

    public int getLongestSequenceLength() {
        return this.maxLength;
    }

    public static class Tokenization {
        private final String inputSeqs;
        private final String[] tokens;
        private final int[] tokenIds;
        private final int[] tokenMap;
        private final boolean truncated;

        public Tokenization(String input, boolean truncated, String[] tokens, int[] tokenIds, int[] tokenMap) {
            assert (tokens.length == tokenIds.length);
            assert (tokenIds.length == tokenMap.length);
            this.inputSeqs = input;
            this.tokens = tokens;
            this.tokenIds = tokenIds;
            this.tokenMap = tokenMap;
            this.truncated = truncated;
        }

        public String[] getTokens() {
            return this.tokens;
        }

        public int[] getTokenIds() {
            return this.tokenIds;
        }

        public int[] getTokenMap() {
            return this.tokenMap;
        }

        public String getInput() {
            return this.inputSeqs;
        }

        public boolean isTruncated() {
            return this.truncated;
        }
    }
}

