/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.util.List;
import java.util.OptionalInt;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.inference.nlp.BertRequestBuilder;
import org.elasticsearch.xpack.ml.inference.nlp.NlpTask;
import org.elasticsearch.xpack.ml.inference.nlp.Vocabulary;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.BertTokenizer;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.TokenizationResult;

public interface NlpTokenizer {
    public TokenizationResult buildTokenizationResult(List<TokenizationResult.Tokenization> var1);

    public TokenizationResult.Tokenization tokenize(String var1);

    public TokenizationResult.Tokenization tokenize(String var1, String var2);

    public NlpTask.RequestBuilder requestBuilder();

    public OptionalInt getPadToken();

    public static NlpTokenizer build(Vocabulary vocabulary, Tokenization params) {
        ExceptionsHelper.requireNonNull((Object)params, (ParseField)NlpConfig.TOKENIZATION);
        ExceptionsHelper.requireNonNull((Object)vocabulary, (ParseField)NlpConfig.VOCABULARY);
        if (params instanceof BertTokenization) {
            return BertTokenizer.builder(vocabulary.get(), params).setRequestBuilderFactory(BertRequestBuilder::new).build();
        }
        throw new IllegalArgumentException("unknown tokenization type [" + params.getName() + "]");
    }
}

