/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Vocabulary
implements Writeable,
ToXContentObject {
    private static final String NAME = "vocabulary";
    public static final ParseField VOCABULARY = new ParseField("vocabulary", new String[0]);
    private final List<String> vocab;
    private final String modelId;

    public static ConstructingObjectParser<Vocabulary, Void> createParser(boolean ignoreUnkownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnkownFields, a -> new Vocabulary((List)a[0], (String)a[1]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), VOCABULARY);
        parser.declareString(ConstructingObjectParser.constructorArg(), TrainedModelConfig.MODEL_ID);
        return parser;
    }

    public Vocabulary(List<String> vocab, String modelId) {
        this.vocab = (List)ExceptionsHelper.requireNonNull(vocab, (ParseField)VOCABULARY);
        this.modelId = (String)ExceptionsHelper.requireNonNull((Object)modelId, (ParseField)TrainedModelConfig.MODEL_ID);
    }

    public Vocabulary(StreamInput in) throws IOException {
        this.vocab = in.readStringList();
        this.modelId = in.readString();
    }

    public List<String> get() {
        return this.vocab;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.vocab);
        out.writeString(this.modelId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vocabulary that = (Vocabulary)o;
        return Objects.equals(this.vocab, that.vocab) && Objects.equals(this.modelId, that.modelId);
    }

    public int hashCode() {
        return Objects.hash(this.vocab, this.modelId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), this.vocab);
        builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.modelId);
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(InferenceIndexConstants.DOC_TYPE.getPreferredName(), NAME);
        }
        builder.endObject();
        return builder;
    }
}

