/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.allocation;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.allocation.TrainedModelAllocation;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TrainedModelAllocationMetadata
implements Metadata.Custom {
    private static final TrainedModelAllocationMetadata EMPTY = new TrainedModelAllocationMetadata(Collections.emptyMap());
    public static final String NAME = "trained_model_allocation";
    private final Map<String, TrainedModelAllocation> modelRoutingEntries;

    public static TrainedModelAllocationMetadata fromXContent(XContentParser parser) throws IOException {
        return new TrainedModelAllocationMetadata(parser.map(LinkedHashMap::new, TrainedModelAllocation::fromXContent));
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new TrainedModeAllocationDiff(in);
    }

    public static Builder builder(ClusterState clusterState) {
        return Builder.fromMetadata(TrainedModelAllocationMetadata.fromState(clusterState));
    }

    public static TrainedModelAllocationMetadata fromState(ClusterState clusterState) {
        TrainedModelAllocationMetadata trainedModelAllocationMetadata = (TrainedModelAllocationMetadata)clusterState.getMetadata().custom(NAME);
        return trainedModelAllocationMetadata == null ? EMPTY : trainedModelAllocationMetadata;
    }

    public static Optional<TrainedModelAllocation> allocationForModelId(ClusterState clusterState, String modelId) {
        return Optional.ofNullable(TrainedModelAllocationMetadata.fromState(clusterState)).map(metadata -> metadata.getModelAllocation(modelId));
    }

    public TrainedModelAllocationMetadata(Map<String, TrainedModelAllocation> modelRoutingEntries) {
        this.modelRoutingEntries = (Map)ExceptionsHelper.requireNonNull(modelRoutingEntries, (String)NAME);
    }

    public TrainedModelAllocationMetadata(StreamInput in) throws IOException {
        this.modelRoutingEntries = in.readOrderedMap(StreamInput::readString, TrainedModelAllocation::new);
    }

    public TrainedModelAllocation getModelAllocation(String modelId) {
        return this.modelRoutingEntries.get(modelId);
    }

    public boolean isAllocated(String modelId) {
        return this.modelRoutingEntries.containsKey(modelId);
    }

    public Map<String, TrainedModelAllocation> modelAllocations() {
        return Collections.unmodifiableMap(this.modelRoutingEntries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.mapContents(this.modelRoutingEntries);
        return builder;
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new TrainedModeAllocationDiff((TrainedModelAllocationMetadata)previousState, this);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return NAME;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_8_0_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.modelRoutingEntries, StreamOutput::writeString, (o, w) -> w.writeTo(o));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelAllocationMetadata that = (TrainedModelAllocationMetadata)o;
        return Objects.equals(this.modelRoutingEntries, that.modelRoutingEntries);
    }

    public int hashCode() {
        return Objects.hash(this.modelRoutingEntries);
    }

    public static class TrainedModeAllocationDiff
    implements NamedDiff<Metadata.Custom> {
        private final Diff<Map<String, TrainedModelAllocation>> modelRoutingEntries;

        static Diff<TrainedModelAllocation> readFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(TrainedModelAllocation::new, (StreamInput)in);
        }

        public TrainedModeAllocationDiff(TrainedModelAllocationMetadata before, TrainedModelAllocationMetadata after) {
            this.modelRoutingEntries = DiffableUtils.diff(before.modelRoutingEntries, after.modelRoutingEntries, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
        }

        public TrainedModeAllocationDiff(StreamInput in) throws IOException {
            this.modelRoutingEntries = DiffableUtils.readJdkMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), TrainedModelAllocation::new, TrainedModeAllocationDiff::readFrom);
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            return new TrainedModelAllocationMetadata(new TreeMap<String, TrainedModelAllocation>((Map)this.modelRoutingEntries.apply(((TrainedModelAllocationMetadata)part).modelRoutingEntries)));
        }

        public String getWriteableName() {
            return TrainedModelAllocationMetadata.NAME;
        }

        public Version getMinimalSupportedVersion() {
            return Version.V_8_0_0;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.modelRoutingEntries.writeTo(out);
        }
    }

    public static class Builder {
        private final Map<String, TrainedModelAllocation.Builder> modelRoutingEntries = new LinkedHashMap<String, TrainedModelAllocation.Builder>();
        private boolean isChanged;

        public static Builder empty() {
            return new Builder();
        }

        public static Builder fromMetadata(TrainedModelAllocationMetadata modelAllocationMetadata) {
            return new Builder(modelAllocationMetadata);
        }

        private Builder() {
        }

        private Builder(TrainedModelAllocationMetadata modelAllocationMetadata) {
            modelAllocationMetadata.modelRoutingEntries.forEach((modelId, allocation) -> this.modelRoutingEntries.put((String)modelId, TrainedModelAllocation.Builder.fromAllocation((TrainedModelAllocation)allocation)));
        }

        public boolean hasModel(String modelId) {
            return this.modelRoutingEntries.containsKey(modelId);
        }

        public Builder addNewAllocation(String modelId, TrainedModelAllocation.Builder allocation) {
            if (this.modelRoutingEntries.containsKey(modelId)) {
                throw new ResourceAlreadyExistsException("[{}] allocation already exists", new Object[]{modelId});
            }
            this.modelRoutingEntries.put(modelId, allocation);
            this.isChanged = true;
            return this;
        }

        public TrainedModelAllocation.Builder getAllocation(String modelId) {
            return this.modelRoutingEntries.get(modelId);
        }

        public Builder removeAllocation(String modelId) {
            this.isChanged |= this.modelRoutingEntries.remove(modelId) != null;
            return this;
        }

        public boolean isChanged() {
            return this.isChanged || this.modelRoutingEntries.values().stream().anyMatch(TrainedModelAllocation.Builder::isChanged);
        }

        public TrainedModelAllocationMetadata build() {
            LinkedHashMap<String, TrainedModelAllocation> allocations = new LinkedHashMap<String, TrainedModelAllocation>();
            this.modelRoutingEntries.forEach((modelId, allocation) -> allocations.put((String)modelId, allocation.build()));
            return new TrainedModelAllocationMetadata(allocations);
        }
    }
}

