/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsSource;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class MappingsMerger {
    private MappingsMerger() {
    }

    public static void mergeMappings(Client client, Map<String, String> headers, DataFrameAnalyticsSource source, ActionListener<MappingMetadata> listener) {
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> listener.onResponse((Object)MappingsMerger.mergeMappings(source, getMappingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(source.getIndex());
        ClientHelper.executeWithHeadersAsync(headers, (String)"ml", (Client)client, (ActionType)GetMappingsAction.INSTANCE, (ActionRequest)getMappingsRequest, (ActionListener)mappingsListener);
    }

    static MappingMetadata mergeMappings(DataFrameAnalyticsSource source, GetMappingsResponse getMappingsResponse) {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        mappings.put("dynamic", false);
        ImmutableOpenMap indexToMappings = getMappingsResponse.getMappings();
        for (MappingsType mappingsType : MappingsType.values()) {
            Map<String, IndexAndMapping> mergedMappingsForType = MappingsMerger.mergeAcrossIndices(source, (ImmutableOpenMap<String, MappingMetadata>)indexToMappings, mappingsType);
            if (mergedMappingsForType.isEmpty()) continue;
            mappings.put(mappingsType.type, mergedMappingsForType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexAndMapping)e.getValue()).mapping)));
        }
        return new MappingMetadata("_doc", mappings);
    }

    private static Map<String, IndexAndMapping> mergeAcrossIndices(DataFrameAnalyticsSource source, ImmutableOpenMap<String, MappingMetadata> indexToMappings, MappingsType mappingsType) {
        HashMap<String, IndexAndMapping> mergedMappings = new HashMap<String, IndexAndMapping>();
        for (ObjectObjectCursor indexMappings : indexToMappings) {
            Map currentMappings;
            MappingMetadata mapping = (MappingMetadata)indexMappings.value;
            if (mapping == null || !(currentMappings = mapping.getSourceAsMap()).containsKey(mappingsType.type)) continue;
            Map fieldMappings = (Map)currentMappings.get(mappingsType.type);
            for (Map.Entry fieldMapping : fieldMappings.entrySet()) {
                String field = (String)fieldMapping.getKey();
                if (source.isFieldExcluded(field)) continue;
                if (mergedMappings.containsKey(field)) {
                    IndexAndMapping existingIndexAndMapping = (IndexAndMapping)mergedMappings.get(field);
                    if (existingIndexAndMapping.mapping.equals(fieldMapping.getValue())) continue;
                    throw ExceptionsHelper.badRequestException((String)"cannot merge [{}] mappings because of differences for field [{}]; mapped as [{}] in index [{}]; mapped as [{}] in index [{}]", (Object[])new Object[]{mappingsType.type, field, fieldMapping.getValue(), indexMappings.key, existingIndexAndMapping.mapping, existingIndexAndMapping.index});
                }
                mergedMappings.put(field, new IndexAndMapping((String)indexMappings.key, fieldMapping.getValue()));
            }
        }
        return mergedMappings;
    }

    private static enum MappingsType {
        PROPERTIES("properties"),
        RUNTIME("runtime");

        private String type;

        private MappingsType(String type) {
            this.type = type;
        }
    }

    private static class IndexAndMapping {
        private final String index;
        private final Object mapping;

        private IndexAndMapping(String index, Object mapping) {
            this.index = Objects.requireNonNull(index);
            this.mapping = Objects.requireNonNull(mapping);
        }
    }
}

