/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizationBytesRefHash;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizationTokenTree;
import org.elasticsearch.xpack.ml.aggs.categorization.TextCategorization;

public class InternalCategorizationAggregation
extends InternalMultiBucketAggregation<InternalCategorizationAggregation, Bucket> {
    private final List<Bucket> buckets;
    private final int maxUniqueTokens;
    private final int similarityThreshold;
    private final int maxMatchTokens;
    private final int requiredSize;
    private final long minDocCount;

    protected InternalCategorizationAggregation(String name, int requiredSize, long minDocCount, int maxUniqueTokens, int maxMatchTokens, int similarityThreshold, Map<String, Object> metadata) {
        this(name, requiredSize, minDocCount, maxUniqueTokens, maxMatchTokens, similarityThreshold, metadata, new ArrayList<Bucket>());
    }

    protected InternalCategorizationAggregation(String name, int requiredSize, long minDocCount, int maxUniqueTokens, int maxMatchTokens, int similarityThreshold, Map<String, Object> metadata, List<Bucket> buckets) {
        super(name, metadata);
        this.buckets = buckets;
        this.maxUniqueTokens = maxUniqueTokens;
        this.maxMatchTokens = maxMatchTokens;
        this.similarityThreshold = similarityThreshold;
        this.minDocCount = minDocCount;
        this.requiredSize = requiredSize;
    }

    public InternalCategorizationAggregation(StreamInput in) throws IOException {
        super(in);
        this.maxUniqueTokens = in.readVInt();
        this.maxMatchTokens = in.readVInt();
        this.similarityThreshold = in.readVInt();
        this.buckets = in.readList(Bucket::new);
        this.requiredSize = InternalCategorizationAggregation.readSize((StreamInput)in);
        this.minDocCount = in.readVLong();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.maxUniqueTokens);
        out.writeVInt(this.maxMatchTokens);
        out.writeVInt(this.similarityThreshold);
        out.writeList(this.buckets);
        InternalCategorizationAggregation.writeSize((int)this.requiredSize, (StreamOutput)out);
        out.writeVLong(this.minDocCount);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public InternalCategorizationAggregation create(List<Bucket> bucketList) {
        return new InternalCategorizationAggregation(this.name, this.requiredSize, this.minDocCount, this.maxUniqueTokens, this.maxMatchTokens, this.similarityThreshold, this.metadata, bucketList);
    }

    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, aggregations);
    }

    protected Bucket reduceBucket(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
        throw new IllegalArgumentException("For optimization purposes, typical bucket path is not supported");
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public String getWriteableName() {
        return "categorize_text";
    }

    /*
     * WARNING - void declaration
     */
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        try (CategorizationBytesRefHash hash = new CategorizationBytesRefHash(new BytesRefHash(1L, reduceContext.bigArrays()));){
            void var10_20;
            CategorizationTokenTree categorizationTokenTree = new CategorizationTokenTree(this.maxUniqueTokens, this.maxMatchTokens, this.similarityThreshold);
            HashMap<BucketKey, DelayedCategorizationBucket> reduced = new HashMap<BucketKey, DelayedCategorizationBucket>();
            for (InternalAggregation internalAggregation : aggregations) {
                InternalCategorizationAggregation categorizationAggregation = (InternalCategorizationAggregation)internalAggregation;
                for (Bucket bucket2 : categorizationAggregation.buckets) {
                    reduced.computeIfAbsent(bucket2.key, key -> new DelayedCategorizationBucket((BucketKey)key, (List<Bucket>)new ArrayList<Bucket>(1), 0L)).add(bucket2);
                }
            }
            reduced.values().stream().sorted(Comparator.comparing(DelayedCategorizationBucket::getDocCount).reversed()).forEach(bucket -> categorizationTokenTree.parseTokens(hash.getIds(bucket.key.keyAsTokens()), bucket.docCount));
            categorizationTokenTree.mergeSmallestChildren();
            HashMap<BucketKey, DelayedCategorizationBucket> mergedBuckets = new HashMap<BucketKey, DelayedCategorizationBucket>();
            for (DelayedCategorizationBucket delayedBucket : reduced.values()) {
                TextCategorization group = categorizationTokenTree.parseTokensConst(hash.getIds(delayedBucket.key.keyAsTokens())).orElseThrow(() -> new AggregationExecutionException("Unexpected null categorization group for bucket [" + delayedBucket.key.asString() + "]"));
                BytesRef[] bytesRefArray = hash.getDeeps(group.getCategorization());
                BucketKey key2 = reduceContext.isFinalReduce() ? BucketKey.withCollapsedWildcards(bytesRefArray) : new BucketKey(bytesRefArray);
                mergedBuckets.computeIfAbsent(key2, k -> new DelayedCategorizationBucket((BucketKey)k, (List<Bucket>)new ArrayList<Bucket>(delayedBucket.toReduce.size()), 0L)).add(delayedBucket);
            }
            int n = !reduceContext.isFinalReduce() ? mergedBuckets.size() : Math.min(this.requiredSize, mergedBuckets.size());
            BucketCountPriorityQueue pq = new BucketCountPriorityQueue(n);
            for (Map.Entry entry : mergedBuckets.entrySet()) {
                BucketKey key2 = (BucketKey)entry.getKey();
                DelayedCategorizationBucket bucket3 = (DelayedCategorizationBucket)entry.getValue();
                Bucket newBucket = bucket3.reduce(key2, reduceContext);
                if (newBucket.docCount >= this.minDocCount || !reduceContext.isFinalReduce()) {
                    Bucket removed = (Bucket)pq.insertWithOverflow(newBucket);
                    if (removed == null) {
                        reduceContext.consumeBucketsAndMaybeBreak(1);
                        continue;
                    }
                    reduceContext.consumeBucketsAndMaybeBreak(-InternalCategorizationAggregation.countInnerBucket((InternalMultiBucketAggregation.InternalBucket)removed));
                    continue;
                }
                reduceContext.consumeBucketsAndMaybeBreak(-InternalCategorizationAggregation.countInnerBucket((InternalMultiBucketAggregation.InternalBucket)newBucket));
            }
            Bucket[] bucketList = new Bucket[pq.size()];
            int n2 = pq.size() - 1;
            while (var10_20 >= 0) {
                bucketList[var10_20] = (Bucket)pq.pop();
                --var10_20;
            }
            if (reduceContext.isFinalReduce()) {
                Arrays.sort(bucketList, Comparator.comparing(Bucket::getDocCount).reversed().thenComparing(Bucket::getRawKey));
            }
            InternalCategorizationAggregation internalCategorizationAggregation = new InternalCategorizationAggregation(this.name, this.requiredSize, this.minDocCount, this.maxUniqueTokens, this.maxMatchTokens, this.similarityThreshold, this.metadata, Arrays.asList(bucketList));
            return internalCategorizationAggregation;
        }
    }

    public int getMaxUniqueTokens() {
        return this.maxUniqueTokens;
    }

    public int getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public int getMaxMatchTokens() {
        return this.maxMatchTokens;
    }

    public int getRequiredSize() {
        return this.requiredSize;
    }

    public long getMinDocCount() {
        return this.minDocCount;
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements MultiBucketsAggregation.Bucket,
    Comparable<Bucket> {
        long bucketOrd;
        final BucketKey key;
        final long docCount;
        InternalAggregations aggregations;

        public Bucket(BucketKey key, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public Bucket(StreamInput in) throws IOException {
            this.key = new BucketKey(in);
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.key.writeTo(out);
            out.writeVLong(this.getDocCount());
            this.aggregations.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            builder.field(Aggregation.CommonFields.KEY.getPreferredName());
            this.key.toXContent(builder, params);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        BucketKey getRawKey() {
            return this.key;
        }

        public Object getKey() {
            return this.key;
        }

        public String getKeyAsString() {
            return this.key.asString();
        }

        public long getDocCount() {
            return this.docCount;
        }

        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public String toString() {
            return "Bucket{key=" + this.getKeyAsString() + ", docCount=" + this.docCount + ", aggregations=" + this.aggregations.asMap() + "}\n";
        }

        @Override
        public int compareTo(Bucket o) {
            return this.key.compareTo(o.key);
        }
    }

    static class BucketKey
    implements ToXContentFragment,
    Writeable,
    Comparable<BucketKey> {
        private final BytesRef[] key;

        static BucketKey withCollapsedWildcards(BytesRef[] key) {
            if (key.length <= 1) {
                return new BucketKey(key);
            }
            ArrayList<BytesRef> collapsedWildCards = new ArrayList<BytesRef>();
            boolean previousTokenWildCard = false;
            for (BytesRef token : key) {
                if (token.equals((Object)CategorizationBytesRefHash.WILD_CARD_REF)) {
                    if (previousTokenWildCard) continue;
                    previousTokenWildCard = true;
                    collapsedWildCards.add(CategorizationBytesRefHash.WILD_CARD_REF);
                    continue;
                }
                previousTokenWildCard = false;
                collapsedWildCards.add(token);
            }
            if (collapsedWildCards.size() == key.length) {
                return new BucketKey(key);
            }
            return new BucketKey((BytesRef[])collapsedWildCards.toArray(BytesRef[]::new));
        }

        BucketKey(BytesRef[] key) {
            this.key = key;
        }

        BucketKey(StreamInput in) throws IOException {
            this.key = (BytesRef[])in.readArray(StreamInput::readBytesRef, BytesRef[]::new);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.value(this.asString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeArray(StreamOutput::writeBytesRef, (Object[])this.key);
        }

        public String asString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.key.length - 1; ++i) {
                builder.append(this.key[i].utf8ToString()).append(" ");
            }
            builder.append(this.key[this.key.length - 1].utf8ToString());
            return builder.toString();
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketKey bucketKey = (BucketKey)o;
            return Arrays.equals(this.key, bucketKey.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public BytesRef[] keyAsTokens() {
            return this.key;
        }

        @Override
        public int compareTo(BucketKey o) {
            return Arrays.compare((Comparable[])this.key, (Comparable[])o.key);
        }
    }

    private static class DelayedCategorizationBucket {
        private final BucketKey key;
        private long docCount;
        private final List<Bucket> toReduce;

        DelayedCategorizationBucket(BucketKey key, List<Bucket> toReduce, long docCount) {
            this.key = key;
            this.toReduce = new ArrayList<Bucket>(toReduce);
            this.docCount = docCount;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public Bucket reduce(BucketKey bucketKey, InternalAggregation.ReduceContext reduceContext) {
            ArrayList<InternalAggregations> innerAggs = new ArrayList<InternalAggregations>(this.toReduce.size());
            long totalDocCount = 0L;
            for (Bucket bucket : this.toReduce) {
                innerAggs.add(bucket.aggregations);
                totalDocCount += bucket.docCount;
            }
            return new Bucket(bucketKey, totalDocCount, InternalAggregations.reduce(innerAggs, (InternalAggregation.ReduceContext)reduceContext));
        }

        public DelayedCategorizationBucket add(Bucket bucket) {
            this.docCount += bucket.docCount;
            this.toReduce.add(bucket);
            return this;
        }

        public DelayedCategorizationBucket add(DelayedCategorizationBucket bucket) {
            this.docCount += bucket.docCount;
            this.toReduce.addAll(bucket.toReduce);
            return this;
        }
    }

    static class BucketCountPriorityQueue
    extends PriorityQueue<Bucket> {
        BucketCountPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(Bucket a, Bucket b) {
            return a.docCount < b.docCount;
        }
    }
}

