/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregator;
import org.elasticsearch.xpack.ml.aggs.categorization.UnmappedCategorizationAggregation;

public class CategorizeTextAggregatorFactory
extends AggregatorFactory {
    private final MappedFieldType fieldType;
    private final String indexedFieldName;
    private final int maxUniqueTokens;
    private final int maxMatchTokens;
    private final int similarityThreshold;
    private final CategorizationAnalyzerConfig categorizationAnalyzerConfig;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;

    public CategorizeTextAggregatorFactory(String name, String fieldName, int maxUniqueTokens, int maxMatchTokens, int similarityThreshold, TermsAggregator.BucketCountThresholds bucketCountThresholds, CategorizationAnalyzerConfig categorizationAnalyzerConfig, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.fieldType = context.getFieldType(fieldName);
        this.indexedFieldName = this.fieldType != null ? this.fieldType.name() : null;
        this.maxUniqueTokens = maxUniqueTokens;
        this.maxMatchTokens = maxMatchTokens;
        this.similarityThreshold = similarityThreshold;
        this.categorizationAnalyzerConfig = categorizationAnalyzerConfig;
        this.bucketCountThresholds = bucketCountThresholds;
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        UnmappedCategorizationAggregation aggregation = new UnmappedCategorizationAggregation(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.maxUniqueTokens, this.maxMatchTokens, this.similarityThreshold, metadata);
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, metadata, (InternalAggregation)aggregation){
            final /* synthetic */ InternalAggregation val$aggregation;
            {
                this.val$aggregation = internalAggregation;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public InternalAggregation buildEmptyAggregation() {
                return this.val$aggregation;
            }
        };
    }

    protected Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (this.fieldType == null) {
            return this.createUnmapped(parent, metadata);
        }
        if (this.fieldType.getTextSearchInfo() == TextSearchInfo.NONE || this.fieldType.getTextSearchInfo() == TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS) {
            throw new IllegalArgumentException("categorize_text agg [" + this.name + "] only works on analyzable text fields. Cannot aggregate field type [" + this.fieldType.name() + "] via [" + this.fieldType.getClass().getSimpleName() + "]");
        }
        TermsAggregator.BucketCountThresholds thresholds = new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
        if (thresholds.getShardSize() == CategorizeTextAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS.getShardSize()) {
            thresholds.setShardSize(BucketUtils.suggestShardSideQueueSize((int)thresholds.getRequiredSize()));
        }
        thresholds.ensureValidity();
        return new CategorizeTextAggregator(this.name, this.factories, this.context, parent, this.indexedFieldName, this.fieldType, thresholds, this.maxUniqueTokens, this.maxMatchTokens, this.similarityThreshold, this.categorizationAnalyzerConfig, metadata);
    }
}

