/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.allocation.TrainedModelAllocation;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationClusterService;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationMetadata;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationService;
import org.elasticsearch.xpack.ml.inference.deployment.TrainedModelDeploymentTask;

public class TransportStopTrainedModelDeploymentAction
extends TransportTasksAction<TrainedModelDeploymentTask, StopTrainedModelDeploymentAction.Request, StopTrainedModelDeploymentAction.Response, StopTrainedModelDeploymentAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopTrainedModelDeploymentAction.class);
    private final Client client;
    private final IngestService ingestService;
    private final TrainedModelAllocationService trainedModelAllocationService;
    private final TrainedModelAllocationClusterService trainedModelAllocationClusterService;

    @Inject
    public TransportStopTrainedModelDeploymentAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client, IngestService ingestService, TrainedModelAllocationService trainedModelAllocationService, TrainedModelAllocationClusterService trainedModelAllocationClusterService) {
        super("cluster:admin/xpack/ml/trained_models/deployment/stop", clusterService, transportService, actionFilters, StopTrainedModelDeploymentAction.Request::new, StopTrainedModelDeploymentAction.Response::new, StopTrainedModelDeploymentAction.Response::new, "same");
        this.client = new OriginSettingClient(client, "ml");
        this.ingestService = ingestService;
        this.trainedModelAllocationService = trainedModelAllocationService;
        this.trainedModelAllocationClusterService = trainedModelAllocationClusterService;
    }

    protected void doExecute(Task task, StopTrainedModelDeploymentAction.Request request, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            this.redirectToMasterNode(nodes.getMasterNode(), request, listener);
            return;
        }
        logger.debug(() -> new ParameterizedMessage("[{}] Received request to undeploy{}", (Object)request.getId(), (Object)(request.isForce() ? " (force)" : "")));
        ActionListener getModelListener = ActionListener.wrap(getModelsResponse -> {
            List models = getModelsResponse.getResources().results();
            if (models.isEmpty()) {
                listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true));
                return;
            }
            if (models.size() > 1) {
                listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.badRequestException((String)"cannot undeploy multiple models at the same time", (Object[])new Object[0]));
                return;
            }
            Optional<TrainedModelAllocation> maybeAllocation = TrainedModelAllocationMetadata.allocationForModelId(this.clusterService.state(), ((TrainedModelConfig)models.get(0)).getModelId());
            if (maybeAllocation.isEmpty()) {
                listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true));
                return;
            }
            String modelId = ((TrainedModelConfig)models.get(0)).getModelId();
            IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom("ingest");
            Set<String> referencedModels = TransportDeleteTrainedModelAction.getReferencedModelKeys(currentIngestMetadata, this.ingestService);
            if (!request.isForce() && referencedModels.contains(modelId)) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Cannot stop deployment for model [{}] as it is referenced by ingest processors; use force to stop the deployment", RestStatus.CONFLICT, new Object[]{modelId}));
                return;
            }
            this.trainedModelAllocationClusterService.setModelAllocationToStopping(modelId, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(setToStopping -> this.normalUndeploy(task, ((TrainedModelConfig)models.get(0)).getModelId(), (TrainedModelAllocation)maybeAllocation.get(), request, listener), failure -> {
                if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)failure) instanceof ResourceNotFoundException) {
                    listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true));
                    return;
                }
                listener.onFailure(failure);
            }));
        }, arg_0 -> listener.onFailure(arg_0));
        GetTrainedModelsAction.Request getModelRequest = new GetTrainedModelsAction.Request(request.getId(), null, Collections.emptySet());
        getModelRequest.setAllowNoResources(request.isAllowNoMatch());
        this.client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)getModelRequest, getModelListener);
    }

    private void redirectToMasterNode(DiscoveryNode masterNode, StopTrainedModelDeploymentAction.Request request, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        if (masterNode == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException());
        } else {
            this.transportService.sendRequest(masterNode, this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopTrainedModelDeploymentAction.Response::new));
        }
    }

    private void normalUndeploy(Task task, String modelId, TrainedModelAllocation modelAllocation, StopTrainedModelDeploymentAction.Request request, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        request.setNodes((String[])modelAllocation.getNodeRoutingTable().keySet().toArray(String[]::new));
        ActionListener finalListener = ActionListener.wrap(r -> this.waitForTaskRemoved(modelId, modelAllocation, request, (StopTrainedModelDeploymentAction.Response)r, (ActionListener<StopTrainedModelDeploymentAction.Response>)ActionListener.wrap(waited -> this.trainedModelAllocationService.deleteModelAllocation(modelId, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(deleted -> listener.onResponse(r), deletionFailed -> {
            logger.error(() -> new ParameterizedMessage("[{}] failed to delete model allocation after nodes unallocated the deployment", (Object)modelId), (Throwable)deletionFailed);
            listener.onFailure((Exception)((Object)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.serverError((String)"failed to delete model allocation after nodes unallocated the deployment. Attempt to stop again", (Throwable)deletionFailed)));
        })), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), e -> {
            if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)e) instanceof FailedNodeException) {
                this.doExecute(task, request, listener);
            } else {
                listener.onFailure(e);
            }
        });
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    void waitForTaskRemoved(String modelId, TrainedModelAllocation trainedModelAllocation, StopTrainedModelDeploymentAction.Request request, StopTrainedModelDeploymentAction.Response response, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        Set nodesOfConcern = trainedModelAllocation.getNodeRoutingTable().keySet();
        ((ListTasksRequestBuilder)((ListTasksRequestBuilder)this.client.admin().cluster().prepareListTasks((String[])nodesOfConcern.toArray(String[]::new)).setDetailed(true).setWaitForCompletion(true).setActions(new String[]{modelId})).setTimeout(request.getTimeout())).execute(ActionListener.wrap(complete -> listener.onResponse((Object)response), arg_0 -> listener.onFailure(arg_0)));
    }

    protected StopTrainedModelDeploymentAction.Response newResponse(StopTrainedModelDeploymentAction.Request request, List<StopTrainedModelDeploymentAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
        }
        return new StopTrainedModelDeploymentAction.Response(true);
    }

    protected void taskOperation(StopTrainedModelDeploymentAction.Request request, TrainedModelDeploymentTask task, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        task.stop("undeploy_trained_model (api)");
        listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true));
    }
}

