/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.dataframe.SourceDestValidations;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPutDataFrameAnalyticsAction
extends TransportMasterNodeAction<PutDataFrameAnalyticsAction.Request, PutDataFrameAnalyticsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutDataFrameAnalyticsAction.class);
    private final XPackLicenseState licenseState;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final SecurityContext securityContext;
    private final Client client;
    private final DataFrameAnalyticsAuditor auditor;
    private final SourceDestValidator sourceDestValidator;
    private final Supplier<ByteSizeValue> maxModelMemoryLimitSupplier;

    @Inject
    public TransportPutDataFrameAnalyticsAction(Settings settings, TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, Client client, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, DataFrameAnalyticsConfigProvider configProvider, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/put", transportService, clusterService, threadPool, actionFilters, PutDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver, PutDataFrameAnalyticsAction.Response::new, "same");
        this.licenseState = licenseState;
        this.configProvider = configProvider;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.client = client;
        this.auditor = Objects.requireNonNull(auditor);
        this.maxModelMemoryLimitSupplier = () -> NativeMemoryCalculator.getMaxModelMemoryLimit(clusterService);
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), null, null, clusterService.getNodeName(), License.OperationMode.PLATINUM.description());
    }

    protected ClusterBlockException checkBlock(PutDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, PutDataFrameAnalyticsAction.Request request, ClusterState state, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        DataFrameAnalyticsConfig config = request.getConfig();
        ActionListener sourceDestValidationListener = ActionListener.wrap(aBoolean -> this.putValidatedConfig(config, request.masterNodeTimeout(), listener), arg_0 -> listener.onFailure(arg_0));
        this.sourceDestValidator.validate(this.clusterService.state(), config.getSource().getIndex(), config.getDest().getIndex(), null, SourceDestValidations.ALL_VALIDATIONS, sourceDestValidationListener);
    }

    private void putValidatedConfig(DataFrameAnalyticsConfig config, TimeValue masterNodeTimeout, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        DataFrameAnalyticsConfig preparedForPutConfig = new DataFrameAnalyticsConfig.Builder(config, this.maxModelMemoryLimitSupplier.get()).setCreateTime(Instant.now()).setVersion(Version.CURRENT).build();
        if (this.securityContext != null) {
            SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
                String username = this.securityContext.getUser().principal();
                RoleDescriptor.IndicesPrivileges sourceIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(preparedForPutConfig.getSource().getIndex()).privileges(new String[]{"read"}).build();
                RoleDescriptor.IndicesPrivileges destIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{preparedForPutConfig.getDest().getIndex()}).privileges(new String[]{"read", "index", "create_index"}).build();
                HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
                privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
                privRequest.username(username);
                privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
                privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{sourceIndexPrivileges, destIndexPrivileges});
                ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, preparedForPutConfig, (HasPrivilegesResponse)r, masterNodeTimeout, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
            });
        } else {
            this.updateDocMappingAndPutConfig(preparedForPutConfig, this.threadPool.getThreadContext().getHeaders(), masterNodeTimeout, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(unused -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(preparedForPutConfig)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void handlePrivsResponse(String username, DataFrameAnalyticsConfig memoryCappedConfig, HasPrivilegesResponse response, TimeValue masterNodeTimeout, ActionListener<PutDataFrameAnalyticsAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.updateDocMappingAndPutConfig(memoryCappedConfig, this.threadPool.getThreadContext().getHeaders(), masterNodeTimeout, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(unused -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(memoryCappedConfig)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create data frame analytics [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{memoryCappedConfig.getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void updateDocMappingAndPutConfig(DataFrameAnalyticsConfig config, Map<String, String> headers, TimeValue masterNodeTimeout, ActionListener<DataFrameAnalyticsConfig> listener) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState == null) {
            logger.warn("Cannot update doc mapping because clusterState == null");
            this.configProvider.put(config, headers, masterNodeTimeout, listener);
            return;
        }
        ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)ActionListener.wrap(unused -> this.configProvider.put(config, headers, masterNodeTimeout, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(indexResponse -> {
            this.auditor.info(config.getId(), Messages.getMessage((String)"Created analytics with type [{0}]", (Object[])new Object[]{config.getAnalysis().getWriteableName()}));
            listener.onResponse((Object)config);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    protected void doExecute(Task task, PutDataFrameAnalyticsAction.Request request, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

