/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.PreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPreviewDataFrameAnalyticsAction
extends HandledTransportAction<PreviewDataFrameAnalyticsAction.Request, PreviewDataFrameAnalyticsAction.Response> {
    private final XPackLicenseState licenseState;
    private final NodeClient client;
    private final SecurityContext securityContext;
    private final ThreadPool threadPool;
    private final Settings settings;

    @Inject
    public TransportPreviewDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, NodeClient client, XPackLicenseState licenseState, Settings settings, ThreadPool threadPool) {
        super("cluster:admin/xpack/ml/data_frame/analytics/preview", transportService, actionFilters, PreviewDataFrameAnalyticsAction.Request::new);
        this.client = Objects.requireNonNull(client);
        this.licenseState = licenseState;
        this.threadPool = threadPool;
        this.settings = settings;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    private static Map<String, Object> mergeRow(DataFrameDataExtractor.Row row, List<String> fieldNames) {
        return row.getValues() == null ? Collections.emptyMap() : IntStream.range(0, row.getValues().length).boxed().collect(Collectors.toMap(fieldNames::get, i -> row.getValues()[i]));
    }

    protected void doExecute(Task task, PreviewDataFrameAnalyticsAction.Request request, ActionListener<PreviewDataFrameAnalyticsAction.Response> listener) {
        if (!MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
                DataFrameAnalyticsConfig config = new DataFrameAnalyticsConfig.Builder(request.getConfig()).setHeaders(ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders())).build();
                this.preview(task, config, listener);
            });
        } else {
            this.preview(task, request.getConfig(), listener);
        }
    }

    void preview(Task task, DataFrameAnalyticsConfig config, ActionListener<PreviewDataFrameAnalyticsAction.Response> listener) {
        ExtractedFieldsDetectorFactory extractedFieldsDetectorFactory = new ExtractedFieldsDetectorFactory((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()));
        extractedFieldsDetectorFactory.createFromSource(config, (ActionListener<ExtractedFieldsDetector>)ActionListener.wrap(extractedFieldsDetector -> {
            DataFrameDataExtractor extractor = DataFrameDataExtractorFactory.createForSourceIndices((Client)this.client, task.getParentTaskId().toString(), config, (ExtractedFields)extractedFieldsDetector.detect().v1()).newExtractor(false);
            extractor.preview((ActionListener<List<DataFrameDataExtractor.Row>>)ActionListener.wrap(rows -> {
                List<String> fieldNames = extractor.getFieldNames();
                listener.onResponse((Object)new PreviewDataFrameAnalyticsAction.Response(rows.stream().map(r -> TransportPreviewDataFrameAnalyticsAction.mergeRow(r, fieldNames)).collect(Collectors.toList())));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

