/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.job.JobManager;

public class TransportGetJobsAction
extends TransportMasterNodeReadAction<GetJobsAction.Request, GetJobsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetJobsAction.class);
    private final JobManager jobManager;
    private final DatafeedManager datafeedManager;

    @Inject
    public TransportGetJobsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobManager jobManager, DatafeedManager datafeedManager) {
        super("cluster:monitor/xpack/ml/job/get", transportService, clusterService, threadPool, actionFilters, GetJobsAction.Request::new, indexNameExpressionResolver, GetJobsAction.Response::new, "same");
        this.jobManager = jobManager;
        this.datafeedManager = datafeedManager;
    }

    protected void masterOperation(Task task, GetJobsAction.Request request, ClusterState state, ActionListener<GetJobsAction.Response> listener) {
        logger.debug("Get job '{}'", (Object)request.getJobId());
        this.jobManager.expandJobBuilders(request.getJobId(), request.allowNoMatch(), (ActionListener<List<Job.Builder>>)ActionListener.wrap(jobs -> this.datafeedManager.getDatafeedsByJobIds(jobs.stream().map(Job.Builder::getId).collect(Collectors.toSet()), (ActionListener<Map<String, DatafeedConfig.Builder>>)ActionListener.wrap(dfsByJobId -> listener.onResponse((Object)new GetJobsAction.Response(new QueryPage(jobs.stream().map(jb -> {
            Optional.ofNullable((DatafeedConfig.Builder)dfsByJobId.get(jb.getId())).ifPresent(arg_0 -> ((Job.Builder)jb).setDatafeed(arg_0));
            return jb.build();
        }).collect(Collectors.toList()), (long)jobs.size(), Job.RESULTS_FIELD))), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(GetJobsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

