/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetDatafeedsStatsAction
extends TransportMasterNodeReadAction<GetDatafeedsStatsAction.Request, GetDatafeedsStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedsStatsAction.class);
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final OriginSettingClient client;

    @Inject
    public TransportGetDatafeedsStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider, Client client) {
        super("cluster:monitor/xpack/ml/datafeeds/stats/get", transportService, clusterService, threadPool, actionFilters, GetDatafeedsStatsAction.Request::new, indexNameExpressionResolver, GetDatafeedsStatsAction.Response::new, "same");
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
        this.client = new OriginSettingClient(client, "ml");
    }

    protected void masterOperation(Task task, GetDatafeedsStatsAction.Request request, ClusterState state, ActionListener<GetDatafeedsStatsAction.Response> listener) {
        logger.debug(() -> new ParameterizedMessage("[{}] get stats for datafeed", (Object)request.getDatafeedId()));
        PersistentTasksCustomMetadata tasksInProgress = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        GetDatafeedsStatsAction.Response.Builder responseBuilder = new GetDatafeedsStatsAction.Response.Builder();
        ActionListener runtimeStateListener = ActionListener.wrap(runtimeStateResponse -> {
            responseBuilder.setDatafeedRuntimeState(runtimeStateResponse);
            listener.onResponse((Object)responseBuilder.build(tasksInProgress, state));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener datafeedTimingStatsListener = ActionListener.wrap(timingStatsByJobId -> {
            responseBuilder.setTimingStatsMap(timingStatsByJobId);
            this.client.execute((ActionType)GetDatafeedRunningStateAction.INSTANCE, (ActionRequest)new GetDatafeedRunningStateAction.Request(responseBuilder.getDatafeedIds()), runtimeStateListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener expandedConfigsListener = ActionListener.wrap(datafeedBuilders -> {
            Map<String, String> datafeedIdsToJobIds = datafeedBuilders.stream().collect(Collectors.toMap(DatafeedConfig.Builder::getId, DatafeedConfig.Builder::getJobId));
            responseBuilder.setDatafeedToJobId(datafeedIdsToJobIds);
            this.jobResultsProvider.datafeedTimingStats(new ArrayList<String>(datafeedIdsToJobIds.values()), (ActionListener<Map<String, DatafeedTimingStats>>)datafeedTimingStatsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener expandIdsListener = ActionListener.wrap(expandedIds -> {
            responseBuilder.setDatafeedIds((Collection)expandedIds);
            this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), true, (ActionListener<List<DatafeedConfig.Builder>>)expandedConfigsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.datafeedConfigProvider.expandDatafeedIds(request.getDatafeedId(), request.allowNoMatch(), tasksInProgress, true, (ActionListener<SortedSet<String>>)expandIdsListener);
    }

    protected ClusterBlockException checkBlock(GetDatafeedsStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

