/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rollup.RollupV2;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.cluster.action.MigrateToDataTiersAction;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.DeleteAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.FreezeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.MigrateAction;
import org.elasticsearch.xpack.core.ilm.ReadOnlyAction;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.RollupILMAction;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.WaitForSnapshotAction;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.ExplainLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetStatusAction;
import org.elasticsearch.xpack.core.ilm.action.MoveToStepAction;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.core.ilm.action.RetryAction;
import org.elasticsearch.xpack.core.ilm.action.StartILMAction;
import org.elasticsearch.xpack.core.ilm.action.StopILMAction;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.core.slm.action.GetSLMStatusAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.StartSLMAction;
import org.elasticsearch.xpack.core.slm.action.StopSLMAction;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryStore;
import org.elasticsearch.xpack.core.slm.history.SnapshotLifecycleTemplateRegistry;
import org.elasticsearch.xpack.ilm.IndexLifecycleInfoTransportAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;
import org.elasticsearch.xpack.ilm.IndexLifecycleUsageTransportAction;
import org.elasticsearch.xpack.ilm.action.RestDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestExplainLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestGetLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestGetStatusAction;
import org.elasticsearch.xpack.ilm.action.RestMigrateToDataTiersAction;
import org.elasticsearch.xpack.ilm.action.RestMoveToStepAction;
import org.elasticsearch.xpack.ilm.action.RestPutLifecycleAction;
import org.elasticsearch.xpack.ilm.action.RestRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.action.RestRetryAction;
import org.elasticsearch.xpack.ilm.action.RestStartILMAction;
import org.elasticsearch.xpack.ilm.action.RestStopAction;
import org.elasticsearch.xpack.ilm.action.TransportDeleteLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportExplainLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportGetLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportGetStatusAction;
import org.elasticsearch.xpack.ilm.action.TransportMigrateToDataTiersAction;
import org.elasticsearch.xpack.ilm.action.TransportMoveToStepAction;
import org.elasticsearch.xpack.ilm.action.TransportPutLifecycleAction;
import org.elasticsearch.xpack.ilm.action.TransportRemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.ilm.action.TransportRetryAction;
import org.elasticsearch.xpack.ilm.action.TransportStartILMAction;
import org.elasticsearch.xpack.ilm.action.TransportStopILMAction;
import org.elasticsearch.xpack.ilm.history.ILMHistoryStore;
import org.elasticsearch.xpack.ilm.history.ILMHistoryTemplateRegistry;
import org.elasticsearch.xpack.slm.SLMInfoTransportAction;
import org.elasticsearch.xpack.slm.SLMUsageTransportAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;
import org.elasticsearch.xpack.slm.SnapshotRetentionService;
import org.elasticsearch.xpack.slm.SnapshotRetentionTask;
import org.elasticsearch.xpack.slm.action.RestDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.action.RestGetSLMStatusAction;
import org.elasticsearch.xpack.slm.action.RestGetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestGetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.action.RestPutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.RestStartSLMAction;
import org.elasticsearch.xpack.slm.action.RestStopSLMAction;
import org.elasticsearch.xpack.slm.action.TransportDeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.action.TransportGetSLMStatusAction;
import org.elasticsearch.xpack.slm.action.TransportGetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportGetSnapshotLifecycleStatsAction;
import org.elasticsearch.xpack.slm.action.TransportPutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportStartSLMAction;
import org.elasticsearch.xpack.slm.action.TransportStopSLMAction;

public class IndexLifecycle
extends Plugin
implements ActionPlugin {
    private final SetOnce<IndexLifecycleService> indexLifecycleInitialisationService = new SetOnce();
    private final SetOnce<ILMHistoryStore> ilmHistoryStore = new SetOnce();
    private final SetOnce<SnapshotLifecycleService> snapshotLifecycleService = new SetOnce();
    private final SetOnce<SnapshotRetentionService> snapshotRetentionService = new SetOnce();
    private final SetOnce<SnapshotHistoryStore> snapshotHistoryStore = new SetOnce();
    private final Settings settings;

    public IndexLifecycle(Settings settings) {
        this.settings = settings;
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(LifecycleSettings.LIFECYCLE_POLL_INTERVAL_SETTING, LifecycleSettings.LIFECYCLE_NAME_SETTING, LifecycleSettings.LIFECYCLE_ORIGINATION_DATE_SETTING, LifecycleSettings.LIFECYCLE_PARSE_ORIGINATION_DATE_SETTING, LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING, LifecycleSettings.LIFECYCLE_HISTORY_INDEX_ENABLED_SETTING, LifecycleSettings.LIFECYCLE_STEP_MASTER_TIMEOUT_SETTING, LifecycleSettings.LIFECYCLE_STEP_WAIT_TIME_THRESHOLD_SETTING, RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING, LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING, LifecycleSettings.SLM_RETENTION_SCHEDULE_SETTING, LifecycleSettings.SLM_RETENTION_DURATION_SETTING, LifecycleSettings.SLM_MINIMUM_INTERVAL_SETTING);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        ArrayList<Object> components = new ArrayList<Object>();
        ILMHistoryTemplateRegistry ilmTemplateRegistry = new ILMHistoryTemplateRegistry(this.settings, clusterService, threadPool, client, xContentRegistry);
        ilmTemplateRegistry.initialize();
        this.ilmHistoryStore.set((Object)new ILMHistoryStore(this.settings, (Client)new OriginSettingClient(client, "index_lifecycle"), clusterService, threadPool));
        LongSupplier nowSupplier = () -> ((ThreadPool)threadPool).absoluteTimeInMillis();
        this.indexLifecycleInitialisationService.set((Object)new IndexLifecycleService(this.settings, client, clusterService, threadPool, this.getClock(), nowSupplier, xContentRegistry, (ILMHistoryStore)this.ilmHistoryStore.get(), this.getLicenseState()));
        components.add(this.indexLifecycleInitialisationService.get());
        SnapshotLifecycleTemplateRegistry templateRegistry = new SnapshotLifecycleTemplateRegistry(this.settings, clusterService, threadPool, client, xContentRegistry);
        templateRegistry.initialize();
        this.snapshotHistoryStore.set((Object)new SnapshotHistoryStore(this.settings, (Client)new OriginSettingClient(client, "index_lifecycle"), clusterService));
        this.snapshotLifecycleService.set((Object)new SnapshotLifecycleService(this.settings, () -> new SnapshotLifecycleTask(client, clusterService, (SnapshotHistoryStore)this.snapshotHistoryStore.get()), clusterService, this.getClock()));
        ((SnapshotLifecycleService)this.snapshotLifecycleService.get()).init();
        this.snapshotRetentionService.set((Object)new SnapshotRetentionService(this.settings, () -> new SnapshotRetentionTask(client, clusterService, System::nanoTime, (SnapshotHistoryStore)this.snapshotHistoryStore.get()), this.getClock()));
        ((SnapshotRetentionService)this.snapshotRetentionService.get()).init(clusterService);
        components.addAll(Arrays.asList(this.snapshotLifecycleService.get(), this.snapshotHistoryStore.get(), this.snapshotRetentionService.get()));
        return components;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.emptyList();
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>(Arrays.asList(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("index_lifecycle", new String[0]), parser -> (Metadata.Custom)IndexLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("snapshot_lifecycle", new String[0]), parser -> (Metadata.Custom)SnapshotLifecycleMetadata.PARSER.parse(parser, null)), new NamedXContentRegistry.Entry(LifecycleType.class, new ParseField("timeseries", new String[0]), (p, c) -> TimeseriesLifecycleType.INSTANCE), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("allocate", new String[0]), AllocateAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("forcemerge", new String[0]), ForceMergeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("readonly", new String[0]), ReadOnlyAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("rollover", new String[0]), RolloverAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("shrink", new String[0]), ShrinkAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("delete", new String[0]), DeleteAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("freeze", new String[0]), FreezeAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("set_priority", new String[0]), SetPriorityAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("unfollow", new String[0]), UnfollowAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("wait_for_snapshot", new String[0]), WaitForSnapshotAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("searchable_snapshot", new String[0]), SearchableSnapshotAction::parse), new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("migrate", new String[0]), MigrateAction::parse)));
        if (RollupV2.isEnabled()) {
            entries.add(new NamedXContentRegistry.Entry(LifecycleAction.class, new ParseField("rollup", new String[0]), RollupILMAction::parse));
        }
        return entries;
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.addAll(Arrays.asList(new BaseRestHandler[]{new RestPutLifecycleAction(), new RestGetLifecycleAction(), new RestDeleteLifecycleAction(), new RestExplainLifecycleAction(), new RestRemoveIndexLifecyclePolicyAction(), new RestMoveToStepAction(), new RestRetryAction(), new RestStopAction(), new RestStartILMAction(), new RestGetStatusAction(), new RestMigrateToDataTiersAction(), new RestPutSnapshotLifecycleAction(), new RestDeleteSnapshotLifecycleAction(), new RestGetSnapshotLifecycleAction(), new RestExecuteSnapshotLifecycleAction(), new RestGetSnapshotLifecycleStatsAction(), new RestExecuteSnapshotRetentionAction(), new RestStopSLMAction(), new RestStartSLMAction(), new RestGetSLMStatusAction()}));
        return handlers;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler ilmUsageAction = new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.INDEX_LIFECYCLE, IndexLifecycleUsageTransportAction.class);
        ActionPlugin.ActionHandler ilmInfoAction = new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.INDEX_LIFECYCLE, IndexLifecycleInfoTransportAction.class);
        ActionPlugin.ActionHandler slmUsageAction = new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.SNAPSHOT_LIFECYCLE, SLMUsageTransportAction.class);
        ActionPlugin.ActionHandler slmInfoAction = new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.SNAPSHOT_LIFECYCLE, SLMInfoTransportAction.class);
        ActionPlugin.ActionHandler migrateToDataTiersAction = new ActionPlugin.ActionHandler((ActionType)MigrateToDataTiersAction.INSTANCE, TransportMigrateToDataTiersAction.class);
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(ilmUsageAction);
        actions.add(ilmInfoAction);
        actions.add(slmUsageAction);
        actions.add(slmInfoAction);
        actions.add(migrateToDataTiersAction);
        actions.addAll(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutLifecycleAction.INSTANCE, TransportPutLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)GetLifecycleAction.INSTANCE, TransportGetLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteLifecycleAction.INSTANCE, TransportDeleteLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)ExplainLifecycleAction.INSTANCE, TransportExplainLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)RemoveIndexLifecyclePolicyAction.INSTANCE, TransportRemoveIndexLifecyclePolicyAction.class), new ActionPlugin.ActionHandler((ActionType)MoveToStepAction.INSTANCE, TransportMoveToStepAction.class), new ActionPlugin.ActionHandler((ActionType)RetryAction.INSTANCE, TransportRetryAction.class), new ActionPlugin.ActionHandler((ActionType)StartILMAction.INSTANCE, TransportStartILMAction.class), new ActionPlugin.ActionHandler((ActionType)StopILMAction.INSTANCE, TransportStopILMAction.class), new ActionPlugin.ActionHandler((ActionType)GetStatusAction.INSTANCE, TransportGetStatusAction.class), new ActionPlugin.ActionHandler((ActionType)PutSnapshotLifecycleAction.INSTANCE, TransportPutSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteSnapshotLifecycleAction.INSTANCE, TransportDeleteSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)GetSnapshotLifecycleAction.INSTANCE, TransportGetSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)ExecuteSnapshotLifecycleAction.INSTANCE, TransportExecuteSnapshotLifecycleAction.class), new ActionPlugin.ActionHandler((ActionType)GetSnapshotLifecycleStatsAction.INSTANCE, TransportGetSnapshotLifecycleStatsAction.class), new ActionPlugin.ActionHandler((ActionType)ExecuteSnapshotRetentionAction.INSTANCE, TransportExecuteSnapshotRetentionAction.class), new ActionPlugin.ActionHandler((ActionType)StartSLMAction.INSTANCE, TransportStartSLMAction.class), new ActionPlugin.ActionHandler((ActionType)StopSLMAction.INSTANCE, TransportStopSLMAction.class), new ActionPlugin.ActionHandler((ActionType)GetSLMStatusAction.INSTANCE, TransportGetSLMStatusAction.class)));
        return actions;
    }

    public void onIndexModule(IndexModule indexModule) {
        assert (this.indexLifecycleInitialisationService.get() != null);
        indexModule.addIndexEventListener((IndexEventListener)this.indexLifecycleInitialisationService.get());
    }

    public void close() {
        try {
            IOUtils.close((Closeable[])new Closeable[]{(Closeable)this.indexLifecycleInitialisationService.get(), (Closeable)this.ilmHistoryStore.get(), (Closeable)this.snapshotLifecycleService.get(), (Closeable)this.snapshotRetentionService.get()});
        }
        catch (IOException e) {
            throw new ElasticsearchException("unable to close index lifecycle services", (Throwable)e, new Object[0]);
        }
    }
}

