/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.scalar.string;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class CaseInsensitiveScalarFunction
extends ScalarFunction {
    private final boolean caseInsensitive;

    protected CaseInsensitiveScalarFunction(Source source, List<Expression> fields, boolean caseInsensitive) {
        super(source, fields);
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isCaseInsensitive());
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && Objects.equals(((CaseInsensitiveScalarFunction)other).caseInsensitive, this.caseInsensitive);
    }
}

