/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.xcontent;

import com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.xpack.sql.proto.xcontent.XContent;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentParseException;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentType;
import org.elasticsearch.xpack.sql.proto.xcontent.cbor.CborXContent;
import org.elasticsearch.xpack.sql.proto.xcontent.json.JsonXContent;

public class XContentFactory {
    public static final int GUESS_HEADER_LENGTH = 20;

    public static XContentBuilder jsonBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.JSON);
    }

    public static XContentBuilder jsonBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(JsonXContent.jsonXContent, os);
    }

    public static XContentBuilder cborBuilder() throws IOException {
        return XContentFactory.contentBuilder(XContentType.CBOR);
    }

    public static XContentBuilder cborBuilder(OutputStream os) throws IOException {
        return new XContentBuilder(CborXContent.cborXContent, os);
    }

    public static XContentBuilder contentBuilder(XContentType type, OutputStream outputStream) throws IOException {
        XContentType canonical = type.canonical();
        if (canonical == XContentType.JSON) {
            return XContentFactory.jsonBuilder(outputStream);
        }
        if (canonical == XContentType.CBOR) {
            return XContentFactory.cborBuilder(outputStream);
        }
        throw new IllegalArgumentException("No matching content type for " + type);
    }

    public static XContentBuilder contentBuilder(XContentType type) throws IOException {
        XContentType canonical = type.canonical();
        if (canonical == XContentType.JSON) {
            return JsonXContent.contentBuilder();
        }
        if (canonical == XContentType.CBOR) {
            return CborXContent.contentBuilder();
        }
        throw new IllegalArgumentException("No matching content type for " + type);
    }

    public static XContent xContent(XContentType type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get xcontent for unknown type");
        }
        return type.xContent();
    }

    @Deprecated
    public static XContentType xContentType(CharSequence content) {
        int length;
        int n = length = content.length() < 20 ? content.length() : 20;
        if (length == 0) {
            return null;
        }
        char first = content.charAt(0);
        if (first == '{') {
            return XContentType.JSON;
        }
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                return XContentType.JSON;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return null;
    }

    @Deprecated
    public static XContent xContent(CharSequence content) {
        XContentType type = XContentFactory.xContentType(content);
        if (type == null) {
            throw new XContentParseException("Failed to derive xcontent");
        }
        return XContentFactory.xContent(type);
    }

    @Deprecated
    public static XContent xContent(byte[] data) {
        return XContentFactory.xContent(data, 0, data.length);
    }

    @Deprecated
    public static XContent xContent(byte[] data, int offset, int length) {
        XContentType type = XContentFactory.xContentType(data, offset, length);
        if (type == null) {
            throw new XContentParseException("Failed to derive xcontent");
        }
        return XContentFactory.xContent(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static XContentType xContentType(InputStream si) throws IOException {
        if (!si.markSupported()) {
            throw new IllegalArgumentException("Cannot guess the xcontent type without mark/reset support on " + si.getClass());
        }
        si.mark(Integer.MAX_VALUE);
        try {
            int read;
            int r;
            int current;
            do {
                if ((current = si.read()) != -1) continue;
                XContentType xContentType = null;
                return xContentType;
            } while (Character.isWhitespace((char)current));
            byte[] firstBytes = new byte[20];
            firstBytes[0] = (byte)current;
            for (read = 1; read < 20 && (r = si.read(firstBytes, read, 20 - read)) != -1; read += r) {
            }
            XContentType xContentType = XContentFactory.xContentType(firstBytes, 0, read);
            return xContentType;
        }
        finally {
            si.reset();
        }
    }

    @Deprecated
    public static XContentType xContentType(byte[] bytes) {
        return XContentFactory.xContentType(bytes, 0, bytes.length);
    }

    @Deprecated
    public static XContentType xContentType(byte[] bytes, int offset, int length) {
        int totalLength = bytes.length;
        if (totalLength == 0 || length == 0) {
            return null;
        }
        if (offset + length > totalLength) {
            return null;
        }
        byte first = bytes[offset];
        if (first == 123) {
            return XContentType.JSON;
        }
        if (first == -65 && length > 1) {
            return XContentType.CBOR;
        }
        if (CBORConstants.hasMajorType((int)6, (byte)first) && length > 2 && first == -39 && bytes[offset + 1] == -39 && bytes[offset + 2] == -9) {
            return XContentType.CBOR;
        }
        if (CBORConstants.hasMajorType((int)5, (byte)first)) {
            return XContentType.CBOR;
        }
        int jsonStart = 0;
        if (length > 3 && first == -17 && bytes[offset + 1] == -69 && bytes[offset + 2] == -65) {
            jsonStart = 3;
        }
        for (int i = jsonStart; i < length; ++i) {
            byte b = bytes[offset + i];
            if (b == 123) {
                return XContentType.JSON;
            }
            if (!Character.isWhitespace(b)) break;
        }
        return null;
    }
}

