/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Predicates;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.common.messaging.context.navigate.SAMLEntityIDFunction;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageInfoContextIDFunction;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.profile.impl.ValidateAssertions;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.ServletRequestX509CredentialAdapter;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAssertionValidationContextBuilder
implements Function<ValidateAssertions.AssertionValidationInput, ValidationContext> {
    @Nullable
    private Logger log = LoggerFactory.getLogger(DefaultAssertionValidationContextBuilder.class);
    private Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> signatureCriteriaSetFunction;
    private Predicate<ProfileRequestContext> signatureRequired = Predicates.alwaysTrue();
    private Predicate<ProfileRequestContext> checkAddress;
    private Function<ProfileRequestContext, Duration> maximumTimeSinceAuthn;
    private Predicate<ProfileRequestContext> includeSelfEntityIDAsRecipient = Predicates.alwaysFalse();
    private Function<ProfileRequestContext, Set<String>> additionalAudiences;
    private Function<ProfileRequestContext, Set<String>> validIssuers;
    private Function<ProfileRequestContext, String> inResponseTo;
    private Predicate<ProfileRequestContext> inResponseToRequired;
    private Predicate<ProfileRequestContext> recipientRequired;
    private Predicate<ProfileRequestContext> notBeforeRequired;
    private Predicate<ProfileRequestContext> notOnOrAfterRequired;
    private Predicate<ProfileRequestContext> addressRequired;
    private Set<QName> requiredConditions;
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy;

    public DefaultAssertionValidationContextBuilder() {
        this.checkAddress = Predicates.alwaysTrue();
        this.inResponseTo = new DefaultValidInResponseToLookupFunction();
        this.inResponseToRequired = Predicates.alwaysFalse();
        this.recipientRequired = Predicates.alwaysFalse();
        this.notOnOrAfterRequired = Predicates.alwaysFalse();
        this.notBeforeRequired = Predicates.alwaysFalse();
        this.addressRequired = Predicates.alwaysFalse();
        this.requiredConditions = Collections.emptySet();
        this.validIssuers = new DefaultValidIssuersLookupFunction();
        this.securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class).compose((Function)new InboundMessageContextLookup());
    }

    @Nonnull
    public Function<ProfileRequestContext, SecurityParametersContext> getSecurityParametersLookupStrategy() {
        return this.securityParametersLookupStrategy;
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy was null");
    }

    @Nonnull
    public Set<QName> getRequiredConditions() {
        return this.requiredConditions;
    }

    public void setRequiredConditions(@Nullable Set<QName> conditions) {
        this.requiredConditions = conditions != null ? conditions.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet()) : Collections.emptySet();
    }

    public Predicate<ProfileRequestContext> getIncludeSelfEntityIDAsRecipient() {
        return this.includeSelfEntityIDAsRecipient;
    }

    public void setIncludeSelfEntityIDAsRecipient(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.includeSelfEntityIDAsRecipient = (Predicate)Constraint.isNotNull(predicate, (String)"Signature required predicate was null");
    }

    public Predicate<ProfileRequestContext> getSignatureRequired() {
        return this.signatureRequired;
    }

    public void setSignatureRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signatureRequired = (Predicate)Constraint.isNotNull(predicate, (String)"Signature required predicate was null");
    }

    public void setInResponseTo(@Nonnull Function<ProfileRequestContext, String> function) {
        this.inResponseTo = function;
    }

    public Function<ProfileRequestContext, String> getInResponseTo() {
        return this.inResponseTo;
    }

    public Predicate<ProfileRequestContext> getInResponseToRequired() {
        return this.inResponseToRequired;
    }

    public void setInResponseToRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.inResponseToRequired = (Predicate)Constraint.isNotNull(predicate, (String)"InResponseTo required predicate was null");
    }

    public Predicate<ProfileRequestContext> getRecipientRequired() {
        return this.recipientRequired;
    }

    public void setRecipientRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.recipientRequired = (Predicate)Constraint.isNotNull(predicate, (String)"Recipient required predicate was null");
    }

    public Predicate<ProfileRequestContext> getNotBeforeRequired() {
        return this.notBeforeRequired;
    }

    public void setNotBeforeRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.notBeforeRequired = (Predicate)Constraint.isNotNull(predicate, (String)"NotBefore required predicate was null");
    }

    public Predicate<ProfileRequestContext> getNotOnOrAfterRequired() {
        return this.notOnOrAfterRequired;
    }

    public void setNotOnOrAfterRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.notOnOrAfterRequired = (Predicate)Constraint.isNotNull(predicate, (String)"NotOnOrAfter required predicate was null");
    }

    public Predicate<ProfileRequestContext> getAddressRequired() {
        return this.addressRequired;
    }

    public void setAddressRequired(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.addressRequired = (Predicate)Constraint.isNotNull(predicate, (String)"Address required predicate was null");
    }

    public Predicate<ProfileRequestContext> getCheckAddress() {
        return this.checkAddress;
    }

    public void setCheckAddress(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkAddress = (Predicate)Constraint.isNotNull(predicate, (String)"Check address predicate was null");
    }

    public Function<ProfileRequestContext, Set<String>> getAdditionalAudiences() {
        return this.additionalAudiences;
    }

    public void setAdditionalAudiences(@Nonnull Function<ProfileRequestContext, Set<String>> function) {
        this.additionalAudiences = function;
    }

    public Function<ProfileRequestContext, Set<String>> getValidIssuers() {
        return this.validIssuers;
    }

    public void setValidIssuers(@Nonnull Function<ProfileRequestContext, Set<String>> function) {
        this.validIssuers = (Function)Constraint.isNotNull(function, (String)"Valied Issuers function was null");
    }

    public Function<ProfileRequestContext, Duration> getMaximumTimeSinceAuthn() {
        return this.maximumTimeSinceAuthn;
    }

    public void setMaximumTimeSinceAuthn(@Nonnull Function<ProfileRequestContext, Duration> function) {
        this.maximumTimeSinceAuthn = function;
    }

    @Nullable
    public Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> getSignatureCriteriaSetFunction() {
        return this.signatureCriteriaSetFunction;
    }

    public void setSignatureCriteriaSetFunction(@Nullable Function<Pair<ProfileRequestContext, Assertion>, CriteriaSet> function) {
        this.signatureCriteriaSetFunction = function;
    }

    @Override
    @Nullable
    public ValidationContext apply(@Nullable ValidateAssertions.AssertionValidationInput input) {
        if (input == null) {
            return null;
        }
        return new ValidationContext(this.buildStaticParameters(input));
    }

    @Nonnull
    protected Map<String, Object> buildStaticParameters(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        TreeMap<String, Object> staticParams = new TreeMap<String, Object>();
        staticParams.put("saml2.ValidIssuers", this.getValidIssuers().apply(input.getProfileRequestContext()));
        this.populateSignatureParameters(staticParams, input);
        this.populateConditionsParameters(staticParams, input);
        Set<InetAddress> validAddresses = this.getValidAddresses(input);
        Boolean checkAddressEnabled = this.getCheckAddress().test(input.getProfileRequestContext());
        this.populateSubjectConfirmationParameters(staticParams, input, validAddresses, checkAddressEnabled);
        this.populateStatementParams(staticParams, input, validAddresses, checkAddressEnabled);
        this.log.trace("Built static parameters map: {}", staticParams);
        return staticParams;
    }

    private void populateSignatureParameters(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input) {
        staticParams.put("saml2.SignatureRequired", this.getSignatureRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SignatureValidationCriteriaSet", this.getSignatureCriteriaSet(input));
        SecurityParametersContext securityParameters = this.getSecurityParametersLookupStrategy().apply(input.getProfileRequestContext());
        if (securityParameters != null && securityParameters.getSignatureValidationParameters() != null) {
            staticParams.put("saml2.SignatureValidationTrustEngine", securityParameters.getSignatureValidationParameters().getSignatureTrustEngine());
        }
    }

    private void populateConditionsParameters(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input) {
        staticParams.put("saml2.Conditions.RequiredConditions", this.getRequiredConditions(input));
        staticParams.put("saml2.Conditions.ValidAudiences", this.getValidAudiences(input));
    }

    private void populateSubjectConfirmationParameters(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input, @Nonnull Set<InetAddress> validAddresses, @Nonnull Boolean checkAddressEnabled) {
        PublicKey attesterPublicKey;
        X509Certificate attesterCertificate = this.getAttesterCertificate(input);
        if (attesterCertificate != null) {
            staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", attesterCertificate);
        }
        if ((attesterPublicKey = this.getAttesterPublicKey(input)) != null) {
            staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", attesterPublicKey);
        }
        staticParams.put("saml2.SubjectConfirmation.RecipientRequired", this.getRecipientRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SubjectConfirmation.ValidRecipients", this.getValidRecipients(input));
        staticParams.put("saml2.SubjectConfirmation.AddressRequired", this.getAddressRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SubjectConfirmation.ValidAddresses", validAddresses);
        staticParams.put("saml2.SubjectConfirmation.CheckAddress", checkAddressEnabled);
        staticParams.put("saml2.SubjectConfirmation.InResponseToRequired", this.getInResponseToRequired().test(input.getProfileRequestContext()));
        if (this.getInResponseTo() != null) {
            staticParams.put("saml2.SubjectConfirmation.ValidInResponseTo", this.getInResponseTo().apply(input.getProfileRequestContext()));
        }
        staticParams.put("saml2.SubjectConfirmation.NotBeforeRequired", this.getNotBeforeRequired().test(input.getProfileRequestContext()));
        staticParams.put("saml2.SubjectConfirmation.NoOnOrAfterRequired", this.getNotOnOrAfterRequired().test(input.getProfileRequestContext()));
    }

    private void populateStatementParams(@Nonnull Map<String, Object> staticParams, @Nonnull ValidateAssertions.AssertionValidationInput input, @Nonnull Set<InetAddress> validAddresses, @Nonnull Boolean checkAddressEnabled) {
        staticParams.put("saml2.Statement.Authn.SubjectLocality.ValidAddresses", validAddresses);
        staticParams.put("saml2.Statement.Authn.SubjectLocality.CheckAddress", checkAddressEnabled);
        if (this.getMaximumTimeSinceAuthn() != null) {
            staticParams.put("saml2.Statement.Authn.MaxTimeSinceAuthn", this.getMaximumTimeSinceAuthn().apply(input.getProfileRequestContext()));
        }
    }

    @Nonnull
    protected Set<QName> getRequiredConditions(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        return this.getRequiredConditions();
    }

    @Nonnull
    protected CriteriaSet getSignatureCriteriaSet(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        MessageContext inboundContext;
        CriteriaSet dynamicCriteria;
        CriteriaSet criteriaSet = new CriteriaSet();
        if (this.getSignatureCriteriaSetFunction() != null && (dynamicCriteria = this.getSignatureCriteriaSetFunction().apply((Pair<ProfileRequestContext, Assertion>)new Pair((Object)input.getProfileRequestContext(), (Object)input.getAssertion()))) != null) {
            criteriaSet.addAll((Collection)dynamicCriteria);
        }
        if (!criteriaSet.contains(EntityIdCriterion.class)) {
            String issuer = null;
            if (input.getAssertion().getIssuer() != null) {
                issuer = StringSupport.trimOrNull((String)input.getAssertion().getIssuer().getValue());
            }
            if (issuer != null) {
                this.log.debug("Adding internally-generated EntityIdCriterion with value of: {}", (Object)issuer);
                criteriaSet.add((Object)new EntityIdCriterion(issuer));
            }
        }
        if (!criteriaSet.contains(UsageCriterion.class)) {
            this.log.debug("Adding internally-generated UsageCriterion with value of: {}", (Object)UsageType.SIGNING);
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        if ((inboundContext = input.getProfileRequestContext().getInboundMessageContext()) != null) {
            this.populateSignatureCriteriaFromInboundContext(criteriaSet, inboundContext);
        }
        this.log.debug("Resolved Signature validation CriteriaSet: {}", (Object)criteriaSet);
        return criteriaSet;
    }

    protected void populateSignatureCriteriaFromInboundContext(@Nonnull CriteriaSet criteriaSet, @Nonnull MessageContext inboundContext) {
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)inboundContext.getSubcontext(SAMLPeerEntityContext.class);
        if (peerContext != null) {
            QName role;
            SAMLMetadataContext metadataContext;
            if (!criteriaSet.contains(RoleDescriptorCriterion.class) && (metadataContext = (SAMLMetadataContext)peerContext.getSubcontext(SAMLMetadataContext.class)) != null && metadataContext.getRoleDescriptor() != null) {
                criteriaSet.add((Object)new RoleDescriptorCriterion(metadataContext.getRoleDescriptor()));
            }
            if (!criteriaSet.contains(EntityRoleCriterion.class) && (role = peerContext.getRole()) != null) {
                criteriaSet.add((Object)new EntityRoleCriterion(role));
            }
        }
        SAMLProtocolContext protocolContext = (SAMLProtocolContext)inboundContext.getSubcontext(SAMLProtocolContext.class);
        if (!criteriaSet.contains(ProtocolCriterion.class) && protocolContext != null && protocolContext.getProtocol() != null) {
            criteriaSet.add((Object)new ProtocolCriterion(protocolContext.getProtocol()));
        }
    }

    @Nullable
    protected X509Certificate getAttesterCertificate(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        try {
            ServletRequestX509CredentialAdapter credential = new ServletRequestX509CredentialAdapter((ServletRequest)input.getHttpServletRequest());
            return credential.getEntityCertificate();
        }
        catch (SecurityException e) {
            this.log.debug("Peer TLS X.509 certificate was not present. Holder-of-key proof-of-possession via client TLS cert will not be possible");
            return null;
        }
    }

    @Nullable
    protected PublicKey getAttesterPublicKey(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        return null;
    }

    @Nonnull
    protected Set<String> getValidRecipients(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        String selfEntityID;
        LazySet validRecipients = new LazySet();
        try {
            String endpoint = SAMLBindingSupport.getActualReceiverEndpointURI((MessageContext)input.getProfileRequestContext().getInboundMessageContext(), (HttpServletRequest)input.getHttpServletRequest());
            if (endpoint != null) {
                validRecipients.add((Object)endpoint);
            }
        }
        catch (MessageException e) {
            this.log.warn("Attempt to resolve recipient endpoint failed", (Throwable)e);
        }
        if (this.getIncludeSelfEntityIDAsRecipient().test(input.getProfileRequestContext()) && (selfEntityID = this.getSelfEntityID(input)) != null) {
            validRecipients.add((Object)selfEntityID);
        }
        this.log.debug("Resolved valid subject confirmation recipients set: {}", (Object)validRecipients);
        return validRecipients;
    }

    @Nonnull
    protected Set<InetAddress> getValidAddresses(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        try {
            LazySet validAddresses = new LazySet();
            InetAddress[] addresses = null;
            String attesterIPAddress = this.getAttesterIPAddress(input);
            this.log.debug("Saw attester IP address: {}", (Object)attesterIPAddress);
            if (attesterIPAddress != null) {
                addresses = InetAddress.getAllByName(attesterIPAddress);
                validAddresses.addAll(Arrays.asList(addresses));
                this.log.debug("Resolved valid subject confirmation InetAddress set: {}", (Object)validAddresses);
                return validAddresses;
            }
            this.log.warn("Could not determine attester IP address. Validation of Assertion may or may not succeed");
            return Collections.emptySet();
        }
        catch (UnknownHostException e) {
            this.log.warn("Processing of attester IP address failed. Validation of Assertion may or may not succeed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Nonnull
    protected String getAttesterIPAddress(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        return input.getHttpServletRequest().getRemoteAddr();
    }

    @Nonnull
    protected Set<String> getValidAudiences(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        Set<String> additional;
        LazySet validAudiences = new LazySet();
        String selfEntityID = this.getSelfEntityID(input);
        if (selfEntityID != null) {
            validAudiences.add((Object)selfEntityID);
        }
        if (this.getAdditionalAudiences() != null && (additional = this.getAdditionalAudiences().apply(input.getProfileRequestContext())) != null) {
            validAudiences.addAll(additional);
        }
        this.log.debug("Resolved valid audiences set: {}", (Object)validAudiences);
        return validAudiences;
    }

    @Nullable
    protected String getSelfEntityID(@Nonnull ValidateAssertions.AssertionValidationInput input) {
        SAMLSelfEntityContext selfContext = (SAMLSelfEntityContext)input.getProfileRequestContext().getInboundMessageContext().getSubcontext(SAMLSelfEntityContext.class);
        if (selfContext != null) {
            return selfContext.getEntityId();
        }
        return null;
    }

    public static class DefaultValidIssuersLookupFunction
    implements Function<ProfileRequestContext, Set<String>> {
        private Function<MessageContext, String> delegate = new SAMLEntityIDFunction().compose(new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND)));

        @Override
        public Set<String> apply(@Nullable ProfileRequestContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            String entityID = this.delegate.apply(prc.getInboundMessageContext());
            if (entityID != null) {
                return Collections.singleton(entityID);
            }
            return Collections.emptySet();
        }
    }

    public static class DefaultValidInResponseToLookupFunction
    implements Function<ProfileRequestContext, String> {
        private Function<MessageContext, String> delegate = new SAMLMessageInfoContextIDFunction().compose(new ChildContextLookup(SAMLMessageInfoContext.class, true).compose((Function)new MessageContextLookup(MessageContextLookup.Direction.OUTBOUND)));

        @Override
        public String apply(@Nullable ProfileRequestContext prc) {
            if (prc == null || prc.getInboundMessageContext() == null) {
                return null;
            }
            return this.delegate.apply(prc.getInboundMessageContext());
        }
    }
}

