/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.DateHistogramGroupSource;
import org.elasticsearch.xpack.transform.checkpoint.DefaultCheckpointProvider;
import org.elasticsearch.xpack.transform.checkpoint.RemoteClusterResolver;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

class TimeBasedCheckpointProvider
extends DefaultCheckpointProvider {
    private static final Logger logger = LogManager.getLogger(TimeBasedCheckpointProvider.class);
    private final TimeSyncConfig timeSyncConfig;
    private final Function<Long, Long> alignTimestamp;

    TimeBasedCheckpointProvider(Clock clock, Client client, RemoteClusterResolver remoteClusterResolver, TransformConfigManager transformConfigManager, TransformAuditor transformAuditor, TransformConfig transformConfig) {
        super(clock, client, remoteClusterResolver, transformConfigManager, transformAuditor, transformConfig);
        this.timeSyncConfig = (TimeSyncConfig)transformConfig.getSyncConfig();
        this.alignTimestamp = TimeBasedCheckpointProvider.createAlignTimestampFunction(transformConfig);
    }

    @Override
    public void sourceHasChanged(TransformCheckpoint lastCheckpoint, ActionListener<Boolean> listener) {
        long timestamp = this.clock.millis();
        long timeUpperBound = this.alignTimestamp.apply(timestamp - this.timeSyncConfig.getDelay().millis());
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().filter(this.transformConfig.getSource().getQueryConfig().getQuery()).filter((QueryBuilder)new RangeQueryBuilder(this.timeSyncConfig.getField()).gte((Object)lastCheckpoint.getTimeUpperBound()).lt((Object)timeUpperBound).format("epoch_millis"));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(0).trackTotalHitsUpTo(1).query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(this.transformConfig.getSource().getIndex()).allowPartialSearchResults(false).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN).source(sourceBuilder);
        logger.trace("query for changes based on time: {}", (Object)sourceBuilder);
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)(r.getHits().getTotalHits().value > 0L ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void createNextCheckpoint(TransformCheckpoint lastCheckpoint, ActionListener<TransformCheckpoint> listener) {
        long timestamp = this.clock.millis();
        long checkpoint = TransformCheckpoint.isNullOrEmpty((TransformCheckpoint)lastCheckpoint) ? 1L : lastCheckpoint.getCheckpoint() + 1L;
        long timeUpperBound = this.alignTimestamp.apply(timestamp - this.timeSyncConfig.getDelay().millis());
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> listener.onResponse((Object)new TransformCheckpoint(this.transformConfig.getId(), timestamp, checkpoint, checkpointsByIndex, Long.valueOf(timeUpperBound))), arg_0 -> listener.onFailure(arg_0)));
    }

    private static Function<Long, Long> createAlignTimestampFunction(TransformConfig transformConfig) {
        if (Boolean.FALSE.equals(transformConfig.getSettings().getAlignCheckpoints())) {
            return Function.identity();
        }
        if (transformConfig.getVersion() == null || transformConfig.getVersion().before(Version.V_7_15_0)) {
            return Function.identity();
        }
        if (transformConfig.getPivotConfig() == null) {
            return Function.identity();
        }
        if (transformConfig.getPivotConfig().getGroupConfig() == null) {
            return Function.identity();
        }
        Map groups = transformConfig.getPivotConfig().getGroupConfig().getGroups();
        if (groups == null || groups.isEmpty()) {
            return Function.identity();
        }
        Optional<DateHistogramGroupSource> dateHistogramGroupSource = groups.values().stream().filter(DateHistogramGroupSource.class::isInstance).map(DateHistogramGroupSource.class::cast).filter(group -> Objects.equals(group.getField(), transformConfig.getSyncConfig().getField())).findFirst();
        if (dateHistogramGroupSource.isEmpty()) {
            return Function.identity();
        }
        return arg_0 -> ((Rounding.Prepared)dateHistogramGroupSource.get().getRounding()).round(arg_0);
    }
}

