/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractTransportSetResetModeAction;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.transform.TransformMetadata;

public class TransportSetTransformResetModeAction
extends AbstractTransportSetResetModeAction {
    @Inject
    public TransportSetTransformResetModeAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:internal/xpack/transform/reset_mode", transportService, threadPool, clusterService, actionFilters, indexNameExpressionResolver);
    }

    protected boolean isResetMode(ClusterState clusterState) {
        return TransformMetadata.getTransformMetadata((ClusterState)clusterState).isResetMode();
    }

    protected String featureName() {
        return "transform";
    }

    protected ClusterState setState(ClusterState oldState, SetResetModeActionRequest request) {
        ClusterState.Builder newState = ClusterState.builder((ClusterState)oldState);
        if (request.shouldDeleteMetadata()) {
            assert (!request.isEnabled());
            newState.metadata(Metadata.builder((Metadata)oldState.getMetadata()).removeCustom("transform").build());
        } else {
            TransformMetadata.Builder builder = TransformMetadata.Builder.from((TransformMetadata)((TransformMetadata)oldState.metadata().custom("transform"))).isResetMode(request.isEnabled());
            newState.metadata(Metadata.builder((Metadata)oldState.getMetadata()).putCustom("transform", (Metadata.Custom)builder.build()).build());
        }
        return newState.build();
    }
}

