/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.elasticsearch.action.ingest.SimulatePipelineAction;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformPrivilegeChecker;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.utils.SourceDestValidations;

public class TransportPreviewTransformAction
extends HandledTransportAction<PreviewTransformAction.Request, PreviewTransformAction.Response> {
    private static final int NUMBER_OF_PREVIEW_BUCKETS = 100;
    private final XPackLicenseState licenseState;
    private final SecurityContext securityContext;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Client client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Settings nodeSettings;
    private final SourceDestValidator sourceDestValidator;

    @Inject
    public TransportPreviewTransformAction(XPackLicenseState licenseState, TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, IngestService ingestService) {
        this("cluster:admin/transform/preview", licenseState, transportService, actionFilters, client, threadPool, indexNameExpressionResolver, clusterService, settings, ingestService);
    }

    protected TransportPreviewTransformAction(String name, XPackLicenseState licenseState, TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Settings settings, IngestService ingestService) {
        super(name, transportService, actionFilters, PreviewTransformAction.Request::new);
        this.licenseState = licenseState;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.nodeSettings = settings;
        this.sourceDestValidator = new SourceDestValidator(indexNameExpressionResolver, transportService.getRemoteClusterService(), DiscoveryNode.isRemoteClusterClient((Settings)settings) ? new RemoteClusterLicenseChecker(client, null) : null, ingestService, clusterService.getNodeName(), License.OperationMode.BASIC.description());
    }

    protected void doExecute(Task task, PreviewTransformAction.Request request, ActionListener<PreviewTransformAction.Response> listener) {
        boolean requiresRemote;
        ClusterState clusterState = this.clusterService.state();
        TransformNodes.throwIfNoTransformNodes(clusterState);
        if (clusterState.nodes().getMinNodeVersion().onOrAfter(Version.V_7_13_0) && TransformNodes.redirectToAnotherNodeIfNeeded(clusterState, this.nodeSettings, requiresRemote = request.getConfig().getSource().requiresRemoteCluster(), this.transportService, this.actionName, request, PreviewTransformAction.Response::new, listener)) {
            return;
        }
        TransformConfig config = request.getConfig();
        Function function = FunctionFactory.create(config);
        ActionListener validateConfigListener = ActionListener.wrap(validateConfigResponse -> this.getPreview(config.getId(), function, config.getSource(), config.getDestination().getPipeline(), config.getDestination().getIndex(), config.getSyncConfig(), listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener validateSourceDestListener = ActionListener.wrap(validateSourceDestResponse -> function.validateConfig((ActionListener<Boolean>)validateConfigListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener checkPrivilegesListener = ActionListener.wrap(aVoid -> this.sourceDestValidator.validate(clusterState, config.getSource().getIndex(), config.getDestination().getIndex(), config.getDestination().getPipeline(), SourceDestValidations.getValidationsForPreview(config.getAdditionalSourceDestValidations()), validateSourceDestListener), arg_0 -> listener.onFailure(arg_0));
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.nodeSettings)).booleanValue()) {
            TransformPrivilegeChecker.checkPrivileges("preview", this.securityContext, this.indexNameExpressionResolver, clusterState, this.client, config, !"unused-transform-preview-index".equals(config.getDestination().getIndex()), (ActionListener<Void>)checkPrivilegesListener);
        } else {
            checkPrivilegesListener.onResponse(null);
        }
    }

    private void getPreview(String transformId, Function function, SourceConfig source, String pipeline, String dest, SyncConfig syncConfig, ActionListener<PreviewTransformAction.Response> listener) {
        SetOnce mappings = new SetOnce();
        ActionListener pipelineResponseActionListener = ActionListener.wrap(simulatePipelineResponse -> {
            ArrayList<Map> docs = new ArrayList<Map>(simulatePipelineResponse.getResults().size());
            ArrayList<Map> errors = new ArrayList<Map>();
            for (SimulateDocumentResult simulateDocumentResult : simulatePipelineResponse.getResults()) {
                XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                try {
                    Map error;
                    XContentBuilder content = simulateDocumentResult.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                    Map tempMap = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)content), (boolean)true, (XContentType)XContentType.JSON).v2();
                    Map doc = (Map)XContentMapValues.extractValue((String)"doc._source", (Map)tempMap);
                    if (doc != null) {
                        docs.add(doc);
                    }
                    if ((error = (Map)XContentMapValues.extractValue((String)"error", (Map)tempMap)) == null) continue;
                    errors.add(error);
                }
                finally {
                    if (xContentBuilder == null) continue;
                    xContentBuilder.close();
                }
            }
            if (!errors.isEmpty()) {
                HeaderWarning.addWarning((String)("Pipeline returned " + errors.size() + " errors, first error: " + errors.get(0)), (Object[])new Object[0]);
            }
            TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings((Map)mappings.get(), transformId, Clock.systemUTC());
            List<String> warnings = TransformConfigLinter.getWarnings(function, source, syncConfig);
            warnings.forEach(warning -> HeaderWarning.addWarning((String)warning, (Object[])new Object[0]));
            listener.onResponse((Object)new PreviewTransformAction.Response(docs, generatedDestIndexSettings));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener previewListener = ActionListener.wrap(docs -> {
            if (pipeline == null) {
                TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings((Map)mappings.get(), transformId, Clock.systemUTC());
                List<String> warnings = TransformConfigLinter.getWarnings(function, source, syncConfig);
                warnings.forEach(warning -> HeaderWarning.addWarning((String)warning, (Object[])new Object[0]));
                listener.onResponse((Object)new PreviewTransformAction.Response(docs, generatedDestIndexSettings));
            } else {
                List results = docs.stream().map(doc -> {
                    HashMap<String, Object> src = new HashMap<String, Object>();
                    String id = (String)doc.get(TransformField.DOCUMENT_ID_FIELD);
                    src.put("_source", doc);
                    src.put("_id", id);
                    src.put("_index", dest);
                    return src;
                }).collect(Collectors.toList());
                try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                    builder.startObject();
                    builder.field("docs", results);
                    builder.endObject();
                    SimulatePipelineRequest pipelineRequest = new SimulatePipelineRequest(BytesReference.bytes((XContentBuilder)builder), XContentType.JSON);
                    pipelineRequest.setId(pipeline);
                    this.client.execute((ActionType)SimulatePipelineAction.INSTANCE, (ActionRequest)pipelineRequest, pipelineResponseActionListener);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener deduceMappingsListener = ActionListener.wrap(deducedMappings -> {
            mappings.set(deducedMappings);
            function.preview(this.client, ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders()), source, (Map<String, String>)deducedMappings, 100, (ActionListener<List<Map<String, Object>>>)previewListener);
        }, arg_0 -> listener.onFailure(arg_0));
        function.deduceMappings(this.client, source, (ActionListener<Map<String, String>>)deduceMappingsListener);
    }
}

