/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.xpack.core.ClientHelper;

class TransformClusterStateListener
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TransformClusterStateListener.class);
    private final Client client;
    private final AtomicBoolean isIndexCreationInProgress = new AtomicBoolean(false);

    TransformClusterStateListener(ClusterService clusterService, Client client) {
        this.client = client;
        clusterService.addListener((ClusterStateListener)this);
        logger.debug("Created TransformClusterStateListener");
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (event.localNodeMaster() && this.isIndexCreationInProgress.compareAndSet(false, true)) {
            TransformClusterStateListener.createAuditAliasForDataFrameBWC(event.state(), this.client, (ActionListener<Boolean>)ActionListener.wrap(r -> {
                this.isIndexCreationInProgress.set(false);
                if (r.booleanValue()) {
                    logger.info("Created alias for deprecated data frame notifications index");
                } else {
                    logger.debug("Skipped creating alias for deprecated data frame notifications index");
                }
            }, e -> {
                this.isIndexCreationInProgress.set(false);
                logger.error("Error creating alias for deprecated data frame notifications index", (Throwable)e);
            }));
        }
    }

    private static void createAuditAliasForDataFrameBWC(ClusterState state, Client client, ActionListener<Boolean> finalListener) {
        if (!state.getMetadata().hasIndexAbstraction(".data-frame-notifications-1")) {
            finalListener.onResponse((Object)false);
            return;
        }
        Metadata metadata = state.metadata();
        if (((IndexAbstraction)state.getMetadata().getIndicesLookup().get(".data-frame-notifications-1")).getIndices().stream().anyMatch(name -> metadata.index(name).getAliases().containsKey((Object)".transform-notifications-read"))) {
            finalListener.onResponse((Object)false);
            return;
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(".data-frame-notifications-1").alias(".transform-notifications-read").isHidden(Boolean.valueOf(true))).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"transform", (ActionRequest)request, (ActionListener)ActionListener.wrap(r -> finalListener.onResponse((Object)r.isAcknowledged()), arg_0 -> finalListener.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
    }
}

