/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.elasticsearch.cli.SuppressForbidden;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;

class ProxyUtils {
    ProxyUtils() {
    }

    @SuppressForbidden(reason="Proxy constructor requires a SocketAddress")
    static Proxy buildProxy(String proxy) throws UserException {
        if (proxy == null) {
            return null;
        }
        String[] parts = proxy.split(":");
        if (parts.length != 2) {
            throw new UserException(78, "Malformed [proxy], expected [host:port]");
        }
        if (!ProxyUtils.validateProxy(parts[0], parts[1])) {
            throw new UserException(78, "Malformed [proxy], expected [host:port]");
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(parts[0], Integer.parseUnsignedInt(parts[1])));
    }

    static boolean validateProxy(String hostname, String port) {
        return !Strings.isNullOrEmpty((String)hostname) && port != null && port.matches("^\\d+$");
    }
}

