/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.Protocol;
import org.elasticsearch.xpack.sql.action.SqlQueryAction;
import org.elasticsearch.xpack.sql.action.SqlQueryRequest;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlQueryRequestBuilder
extends ActionRequestBuilder<SqlQueryRequest, SqlQueryResponse> {
    public SqlQueryRequestBuilder(ElasticsearchClient client, SqlQueryAction action) {
        this(client, action, "", Collections.emptyList(), null, Collections.emptyMap(), Protocol.TIME_ZONE, null, 1000, Protocol.REQUEST_TIMEOUT, Protocol.PAGE_TIMEOUT, false, "", new RequestInfo(Mode.PLAIN), false, false, Protocol.DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT, Protocol.DEFAULT_KEEP_ON_COMPLETION, Protocol.DEFAULT_KEEP_ALIVE);
    }

    public SqlQueryRequestBuilder(ElasticsearchClient client, SqlQueryAction action, String query, List<SqlTypedParamValue> params, QueryBuilder filter, Map<String, Object> runtimeMappings, ZoneId zoneId, String catalog, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, boolean columnar, String nextPageInfo, RequestInfo requestInfo, boolean multiValueFieldLeniency, boolean indexIncludeFrozen, TimeValue waitForCompletionTimeout, boolean keepOnCompletion, TimeValue keepAlive) {
        super(client, (ActionType)action, (ActionRequest)new SqlQueryRequest(query, params, filter, runtimeMappings, zoneId, catalog, fetchSize, requestTimeout, pageTimeout, columnar, nextPageInfo, requestInfo, multiValueFieldLeniency, indexIncludeFrozen, waitForCompletionTimeout, keepOnCompletion, keepAlive));
    }

    public SqlQueryRequestBuilder query(String query) {
        ((SqlQueryRequest)this.request).query(query);
        return this;
    }

    public SqlQueryRequestBuilder mode(String mode) {
        ((SqlQueryRequest)this.request).mode(mode);
        return this;
    }

    public SqlQueryRequestBuilder mode(Mode mode) {
        ((SqlQueryRequest)this.request).mode(mode);
        return this;
    }

    public SqlQueryRequestBuilder version(String version) {
        ((SqlQueryRequest)this.request).version(version);
        return this;
    }

    public SqlQueryRequestBuilder cursor(String cursor) {
        ((SqlQueryRequest)this.request).cursor(cursor);
        return this;
    }

    public SqlQueryRequestBuilder filter(QueryBuilder filter) {
        ((SqlQueryRequest)this.request).filter(filter);
        return this;
    }

    public SqlQueryRequestBuilder runtimeMappings(Map<String, Object> runtimeMappings) {
        ((SqlQueryRequest)this.request).runtimeMappings(runtimeMappings);
        return this;
    }

    public SqlQueryRequestBuilder zoneId(ZoneId zoneId) {
        ((SqlQueryRequest)this.request).zoneId(zoneId);
        return this;
    }

    public SqlQueryRequestBuilder catalog(String catalog) {
        ((SqlQueryRequest)this.request).catalog(catalog);
        return this;
    }

    public SqlQueryRequestBuilder requestTimeout(TimeValue timeout) {
        ((SqlQueryRequest)this.request).requestTimeout(timeout);
        return this;
    }

    public SqlQueryRequestBuilder pageTimeout(TimeValue timeout) {
        ((SqlQueryRequest)this.request).pageTimeout(timeout);
        return this;
    }

    public SqlQueryRequestBuilder columnar(boolean columnar) {
        ((SqlQueryRequest)this.request).columnar(columnar);
        return this;
    }

    public SqlQueryRequestBuilder fetchSize(int fetchSize) {
        ((SqlQueryRequest)this.request).fetchSize(fetchSize);
        return this;
    }

    public SqlQueryRequestBuilder multiValueFieldLeniency(boolean lenient) {
        ((SqlQueryRequest)this.request).fieldMultiValueLeniency(lenient);
        return this;
    }

    public SqlQueryRequestBuilder waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        ((SqlQueryRequest)this.request).waitForCompletionTimeout(waitForCompletionTimeout);
        return this;
    }

    public SqlQueryRequestBuilder keepOnCompletion(boolean keepOnCompletion) {
        ((SqlQueryRequest)this.request).keepOnCompletion(keepOnCompletion);
        return this;
    }

    public SqlQueryRequestBuilder keepAlive(TimeValue keepAlive) {
        ((SqlQueryRequest)this.request).keepAlive(keepAlive);
        return this;
    }
}

