/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentGenerator;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContentParser;
import org.elasticsearch.xpack.sql.proto.core.CheckedConsumer;
import org.elasticsearch.xpack.sql.proto.core.CheckedFunction;
import org.elasticsearch.xpack.sql.proto.xcontent.DeprecationHandler;
import org.elasticsearch.xpack.sql.proto.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.sql.proto.xcontent.ToXContent;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentBuilder;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentLocation;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.proto.xcontent.XContentType;

final class ProtoShim {
    private ProtoShim() {
    }

    static TimeValue fromProto(org.elasticsearch.xpack.sql.proto.core.TimeValue fromProto) {
        if (fromProto == null) {
            return null;
        }
        return new TimeValue(fromProto.duration(), fromProto.timeUnit());
    }

    static org.elasticsearch.xpack.sql.proto.core.TimeValue toProto(TimeValue toProto) {
        if (toProto == null) {
            return null;
        }
        return new org.elasticsearch.xpack.sql.proto.core.TimeValue(toProto.duration(), toProto.timeUnit());
    }

    static org.elasticsearch.xcontent.XContentType fromProto(XContentType fromProto) {
        switch (fromProto) {
            case JSON: {
                return org.elasticsearch.xcontent.XContentType.JSON;
            }
            case CBOR: {
                return org.elasticsearch.xcontent.XContentType.CBOR;
            }
        }
        throw new IllegalArgumentException("Unsupported content type " + fromProto);
    }

    static XContentType toProto(org.elasticsearch.xcontent.XContentType toProto) {
        switch (toProto) {
            case JSON: {
                return XContentType.JSON;
            }
            case CBOR: {
                return XContentType.CBOR;
            }
        }
        throw new IllegalArgumentException("Unsupported content type " + toProto);
    }

    static RestApiVersion fromProto(org.elasticsearch.xpack.sql.proto.core.RestApiVersion fromProto) {
        return RestApiVersion.valueOf((String)fromProto.name());
    }

    static org.elasticsearch.xpack.sql.proto.core.RestApiVersion toProto(RestApiVersion toProto) {
        return org.elasticsearch.xpack.sql.proto.core.RestApiVersion.valueOf((String)toProto.name());
    }

    static XContentParser toProto(org.elasticsearch.xcontent.XContentParser toProto) {
        if (toProto == null) {
            return null;
        }
        if (!(toProto instanceof JsonXContentParser)) {
            throw new IllegalArgumentException("Unsupported XContentParser " + toProto);
        }
        return new DelegatingXContentLibParser(toProto);
    }

    static org.elasticsearch.xcontent.XContentLocation fromProto(XContentLocation fromProto) {
        if (fromProto == null) {
            return null;
        }
        return new org.elasticsearch.xcontent.XContentLocation(fromProto.lineNumber, fromProto.columnNumber);
    }

    static XContentLocation toProto(org.elasticsearch.xcontent.XContentLocation toProto) {
        if (toProto == null) {
            return null;
        }
        return new XContentLocation(toProto.lineNumber, toProto.columnNumber);
    }

    static org.elasticsearch.xcontent.XContentBuilder fromProto(org.elasticsearch.xpack.sql.proto.xcontent.ToXContent fromProto, org.elasticsearch.xcontent.XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder protoBuilder = ProtoShim.toProto(builder);
        ToXContent.Params protoParam = ProtoShim.toProto(params);
        fromProto.toXContent(protoBuilder, protoParam);
        return builder;
    }

    static XContentBuilder toProto(org.elasticsearch.xcontent.XContentBuilder toProto) throws IOException {
        if (toProto == null) {
            return null;
        }
        return new DelegatingXContentLibBuilder(toProto);
    }

    static ToXContent.Params fromProto(ToXContent.Params fromProto) {
        if (fromProto == null) {
            return null;
        }
        if (fromProto == org.elasticsearch.xpack.sql.proto.xcontent.ToXContent.EMPTY_PARAMS) {
            return ToXContent.EMPTY_PARAMS;
        }
        return new DelegatingXContentProtoParam(fromProto);
    }

    static ToXContent.Params toProto(ToXContent.Params toProto) {
        if (toProto == null) {
            return null;
        }
        if (toProto == ToXContent.EMPTY_PARAMS) {
            return org.elasticsearch.xpack.sql.proto.xcontent.ToXContent.EMPTY_PARAMS;
        }
        return new DelegatingXContentLibParam(toProto);
    }

    static org.elasticsearch.xpack.sql.proto.xcontent.ToXContent toProto(ToXContent toProto) {
        if (toProto == null) {
            return null;
        }
        if (toProto.isFragment()) {
            throw new IllegalArgumentException("XContent fragments not supported");
        }
        return new DelegatingXContentLibToXContent(toProto);
    }

    private static class DelegatingXContentLibParser
    implements XContentParser {
        private final org.elasticsearch.xcontent.XContentParser esXContentParser;

        private static XContentParser.Token toProto(XContentParser.Token toProto) {
            if (toProto == null) {
                return null;
            }
            return XContentParser.Token.valueOf((String)toProto.name());
        }

        private DelegatingXContentLibParser(org.elasticsearch.xcontent.XContentParser esXContentParser) {
            this.esXContentParser = esXContentParser;
        }

        public XContentType contentType() {
            return ProtoShim.toProto(this.esXContentParser.contentType());
        }

        public void allowDuplicateKeys(boolean allowDuplicateKeys) {
            this.esXContentParser.allowDuplicateKeys(allowDuplicateKeys);
        }

        public XContentParser.Token nextToken() throws IOException {
            return DelegatingXContentLibParser.toProto(this.esXContentParser.nextToken());
        }

        public void skipChildren() throws IOException {
            this.esXContentParser.skipChildren();
        }

        public XContentParser.Token currentToken() {
            return DelegatingXContentLibParser.toProto(this.esXContentParser.currentToken());
        }

        public String currentName() throws IOException {
            return this.esXContentParser.currentName();
        }

        public Map<String, Object> map() throws IOException {
            return this.esXContentParser.map();
        }

        public Map<String, Object> mapOrdered() throws IOException {
            return this.esXContentParser.mapOrdered();
        }

        public Map<String, String> mapStrings() throws IOException {
            return this.esXContentParser.mapStrings();
        }

        public <T> Map<String, T> map(Supplier<Map<String, T>> mapFactory, CheckedFunction<XContentParser, T, IOException> mapValueParser) throws IOException {
            return this.esXContentParser.map(mapFactory, p -> mapValueParser.apply((Object)this));
        }

        public List<Object> list() throws IOException {
            return this.esXContentParser.list();
        }

        public List<Object> listOrderedMap() throws IOException {
            return this.esXContentParser.listOrderedMap();
        }

        public String text() throws IOException {
            return this.esXContentParser.text();
        }

        public String textOrNull() throws IOException {
            return this.esXContentParser.textOrNull();
        }

        public CharBuffer charBufferOrNull() throws IOException {
            return this.esXContentParser.charBufferOrNull();
        }

        public CharBuffer charBuffer() throws IOException {
            return this.esXContentParser.charBuffer();
        }

        public Object objectText() throws IOException {
            return this.esXContentParser.objectText();
        }

        public Object objectBytes() throws IOException {
            return this.esXContentParser.objectBytes();
        }

        public boolean hasTextCharacters() {
            return this.esXContentParser.hasTextCharacters();
        }

        public char[] textCharacters() throws IOException {
            return this.esXContentParser.textCharacters();
        }

        public int textLength() throws IOException {
            return this.esXContentParser.textLength();
        }

        public int textOffset() throws IOException {
            return this.esXContentParser.textOffset();
        }

        public Number numberValue() throws IOException {
            return this.esXContentParser.numberValue();
        }

        public XContentParser.NumberType numberType() throws IOException {
            return XContentParser.NumberType.valueOf((String)this.esXContentParser.numberType().name());
        }

        public short shortValue(boolean coerce) throws IOException {
            return this.esXContentParser.shortValue(coerce);
        }

        public int intValue(boolean coerce) throws IOException {
            return this.esXContentParser.intValue(coerce);
        }

        public long longValue(boolean coerce) throws IOException {
            return this.esXContentParser.longValue(coerce);
        }

        public float floatValue(boolean coerce) throws IOException {
            return this.esXContentParser.floatValue(coerce);
        }

        public double doubleValue(boolean coerce) throws IOException {
            return this.esXContentParser.doubleValue(coerce);
        }

        public short shortValue() throws IOException {
            return this.esXContentParser.shortValue();
        }

        public int intValue() throws IOException {
            return this.esXContentParser.intValue();
        }

        public long longValue() throws IOException {
            return this.esXContentParser.longValue();
        }

        public float floatValue() throws IOException {
            return this.esXContentParser.floatValue();
        }

        public double doubleValue() throws IOException {
            return this.esXContentParser.doubleValue();
        }

        public boolean isBooleanValue() throws IOException {
            return this.esXContentParser.isBooleanValue();
        }

        public boolean booleanValue() throws IOException {
            return this.esXContentParser.booleanValue();
        }

        public byte[] binaryValue() throws IOException {
            return this.esXContentParser.binaryValue();
        }

        public XContentLocation getTokenLocation() {
            return ProtoShim.toProto(this.esXContentParser.getTokenLocation());
        }

        public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
            return (T)this.esXContentParser.namedObject(categoryClass, name, context);
        }

        public NamedXContentRegistry getXContentRegistry() {
            return NamedXContentRegistry.EMPTY;
        }

        public boolean isClosed() {
            return this.esXContentParser.isClosed();
        }

        public org.elasticsearch.xpack.sql.proto.core.RestApiVersion getRestApiVersion() {
            return ProtoShim.toProto(this.esXContentParser.getRestApiVersion());
        }

        public DeprecationHandler getDeprecationHandler() {
            return new DelegatingXContentLibDeprecationHandler(this.esXContentParser.getDeprecationHandler());
        }

        public void close() throws IOException {
            this.esXContentParser.close();
        }
    }

    private static class DelegatingXContentLibBuilder
    extends XContentBuilder {
        private final org.elasticsearch.xcontent.XContentBuilder esDelegate;

        DelegatingXContentLibBuilder(org.elasticsearch.xcontent.XContentBuilder esDelegate) throws IOException {
            super((org.elasticsearch.xpack.sql.proto.xcontent.XContentGenerator)new DelegatingXContentLibGenerator(esDelegate.generator()), esDelegate.getOutputStream(), ProtoShim.toProto(esDelegate.getRestApiVersion()));
            this.esDelegate = esDelegate;
        }
    }

    private static class DelegatingXContentProtoParam
    implements ToXContent.Params {
        private final ToXContent.Params protoDelegate;

        private DelegatingXContentProtoParam(ToXContent.Params protoDelegate) {
            this.protoDelegate = protoDelegate;
        }

        public String param(String key) {
            return this.protoDelegate.param(key);
        }

        public String param(String key, String defaultValue) {
            return this.protoDelegate.param(key, defaultValue);
        }

        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return this.protoDelegate.paramAsBoolean(key, defaultValue);
        }

        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            return this.protoDelegate.paramAsBoolean(key, defaultValue);
        }
    }

    private static class DelegatingXContentLibParam
    implements ToXContent.Params {
        private final ToXContent.Params esDelegate;

        private DelegatingXContentLibParam(ToXContent.Params esDelegate) {
            this.esDelegate = esDelegate;
        }

        public String param(String key) {
            return this.esDelegate.param(key);
        }

        public String param(String key, String defaultValue) {
            return this.esDelegate.param(key, defaultValue);
        }

        public boolean paramAsBoolean(String key, boolean defaultValue) {
            return this.esDelegate.paramAsBoolean(key, defaultValue);
        }

        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            return this.esDelegate.paramAsBoolean(key, defaultValue);
        }
    }

    private static class DelegatingXContentLibToXContent
    implements org.elasticsearch.xpack.sql.proto.xcontent.ToXContent {
        private final ToXContent esDelegate;

        private DelegatingXContentLibToXContent(ToXContent esDelegate) {
            this.esDelegate = esDelegate;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            Object xContentBuilder = null;
            if (!(builder instanceof DelegatingXContentLibBuilder)) {
                throw new IllegalArgumentException("Expecting a wrapped x-content builder");
            }
            this.esDelegate.toXContent(((DelegatingXContentLibBuilder)builder).esDelegate, ProtoShim.fromProto(params));
            return builder;
        }

        public boolean isFragment() {
            return this.esDelegate.isFragment();
        }
    }

    private static class DelegatingXContentLibGenerator
    implements org.elasticsearch.xpack.sql.proto.xcontent.XContentGenerator {
        private final XContentGenerator esDelegate;

        private DelegatingXContentLibGenerator(XContentGenerator esDelegate) {
            this.esDelegate = esDelegate;
        }

        public JsonGenerator getLowLevelGenerator() {
            return null;
        }

        public XContentType contentType() {
            return ProtoShim.toProto(this.esDelegate.contentType());
        }

        public void usePrettyPrint() {
            this.esDelegate.usePrettyPrint();
        }

        public boolean isPrettyPrint() {
            return this.esDelegate.isPrettyPrint();
        }

        public void usePrintLineFeedAtEnd() {
            this.esDelegate.usePrintLineFeedAtEnd();
        }

        public void writeStartObject() throws IOException {
            this.esDelegate.writeStartObject();
        }

        public void writeEndObject() throws IOException {
            this.esDelegate.writeEndObject();
        }

        public void writeStartArray() throws IOException {
            this.esDelegate.writeStartArray();
        }

        public void writeEndArray() throws IOException {
            this.esDelegate.writeEndArray();
        }

        public void writeFieldName(String name) throws IOException {
            this.esDelegate.writeFieldName(name);
        }

        public void writeNull() throws IOException {
            this.esDelegate.writeNull();
        }

        public void writeNullField(String name) throws IOException {
            this.esDelegate.writeNullField(name);
        }

        public void writeBooleanField(String name, boolean value) throws IOException {
            this.esDelegate.writeBooleanField(name, value);
        }

        public void writeBoolean(boolean value) throws IOException {
            this.esDelegate.writeBoolean(value);
        }

        public void writeNumberField(String name, double value) throws IOException {
            this.esDelegate.writeNumberField(name, value);
        }

        public void writeNumber(double value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumberField(String name, float value) throws IOException {
            this.esDelegate.writeNumberField(name, value);
        }

        public void writeNumber(float value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumberField(String name, int value) throws IOException {
            this.esDelegate.writeNumberField(name, value);
        }

        public void writeNumber(int value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumberField(String name, long value) throws IOException {
            this.esDelegate.writeNumberField(name, value);
        }

        public void writeNumber(long value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumber(short value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumber(BigInteger value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumberField(String name, BigInteger value) throws IOException {
            this.esDelegate.writeNumberField(name, value);
        }

        public void writeNumber(BigDecimal value) throws IOException {
            this.esDelegate.writeNumber(value);
        }

        public void writeNumberField(String name, BigDecimal value) throws IOException {
            this.esDelegate.writeNumberField(name, value);
        }

        public void writeStringField(String name, String value) throws IOException {
            this.esDelegate.writeStringField(name, value);
        }

        public void writeString(String value) throws IOException {
            this.esDelegate.writeString(value);
        }

        public void writeString(char[] text, int offset, int len) throws IOException {
            this.esDelegate.writeString(text, offset, len);
        }

        public void writeUTF8String(byte[] value, int offset, int length) throws IOException {
            this.esDelegate.writeUTF8String(value, offset, length);
        }

        public void writeBinaryField(String name, byte[] value) throws IOException {
            this.esDelegate.writeBinaryField(name, value);
        }

        public void writeBinary(byte[] value) throws IOException {
            this.esDelegate.writeBinary(value);
        }

        public void writeBinary(byte[] value, int offset, int length) throws IOException {
            this.esDelegate.writeBinary(value, offset, length);
        }

        @Deprecated
        public void writeRawField(String name, InputStream value) throws IOException {
            this.esDelegate.writeRawField(name, value);
        }

        public void writeRawField(String name, InputStream value, XContentType xContentType) throws IOException {
            this.esDelegate.writeRawField(name, value, ProtoShim.fromProto(xContentType));
        }

        public void writeRawValue(InputStream value, XContentType xContentType) throws IOException {
            this.esDelegate.writeRawValue(value, ProtoShim.fromProto(xContentType));
        }

        public void copyCurrentStructure(XContentParser parser) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeDirectField(String name, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
            this.esDelegate.writeDirectField(name, arg_0 -> writer.accept(arg_0));
        }

        public boolean isClosed() {
            return this.esDelegate.isClosed();
        }

        public void close() throws IOException {
            this.esDelegate.close();
        }

        public void flush() throws IOException {
            this.esDelegate.flush();
        }
    }

    private static class DelegatingXContentLibDeprecationHandler
    implements DeprecationHandler {
        private final org.elasticsearch.xcontent.DeprecationHandler esDelegate;

        private static Supplier<org.elasticsearch.xcontent.XContentLocation> fromProto(Supplier<XContentLocation> location) {
            return () -> ProtoShim.fromProto((XContentLocation)location.get());
        }

        DelegatingXContentLibDeprecationHandler(org.elasticsearch.xcontent.DeprecationHandler esDelegate) {
            this.esDelegate = esDelegate;
        }

        public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName) {
            this.esDelegate.logRenamedField(parserName, DelegatingXContentLibDeprecationHandler.fromProto(location), oldName, currentName);
        }

        public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName) {
            this.esDelegate.logReplacedField(parserName, DelegatingXContentLibDeprecationHandler.fromProto(location), oldName, replacedName);
        }

        public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName) {
            this.esDelegate.logRemovedField(parserName, DelegatingXContentLibDeprecationHandler.fromProto(location), removedName);
        }

        public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName, boolean isCompatibleDeprecation) {
            this.esDelegate.logRenamedField(parserName, DelegatingXContentLibDeprecationHandler.fromProto(location), oldName, currentName, isCompatibleDeprecation);
        }

        public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName, boolean isCompatibleDeprecation) {
            this.esDelegate.logReplacedField(parserName, DelegatingXContentLibDeprecationHandler.fromProto(location), oldName, replacedName, isCompatibleDeprecation);
        }

        public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName, boolean isCompatibleDeprecation) {
            this.esDelegate.logRemovedField(parserName, DelegatingXContentLibDeprecationHandler.fromProto(location), removedName, isCompatibleDeprecation);
        }
    }
}

