/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.action.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.action.ProtoShim;
import org.elasticsearch.xpack.sql.action.Protocol;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public abstract class AbstractSqlQueryRequest
extends AbstractSqlRequest
implements CompositeIndicesRequest,
ToXContentFragment {
    private static final ConstructingObjectParser<SqlTypedParamValue, Void> SQL_PARAM_PARSER = new ConstructingObjectParser("params", true, objects -> new SqlTypedParamValue((String)objects[1], objects[0]));
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField TYPE = new ParseField("type", new String[0]);
    private String query = "";
    private ZoneId zoneId = Protocol.TIME_ZONE;
    private String catalog = null;
    private int fetchSize = 1000;
    private TimeValue requestTimeout = Protocol.REQUEST_TIMEOUT;
    private TimeValue pageTimeout = Protocol.PAGE_TIMEOUT;
    @Nullable
    private QueryBuilder filter = null;
    private List<SqlTypedParamValue> params = Collections.emptyList();
    private Map<String, Object> runtimeMappings = Collections.emptyMap();
    static final ParseField QUERY;
    static final ParseField CURSOR;
    static final ParseField PARAMS;
    static final ParseField TIME_ZONE;
    static final ParseField CATALOG;
    static final ParseField FETCH_SIZE;
    static final ParseField REQUEST_TIMEOUT;
    static final ParseField PAGE_TIMEOUT;
    static final ParseField FILTER;
    static final ParseField MODE;
    static final ParseField CLIENT_ID;
    static final ParseField VERSION;

    public AbstractSqlQueryRequest() {
    }

    public AbstractSqlQueryRequest(String query, List<SqlTypedParamValue> params, QueryBuilder filter, Map<String, Object> runtimeMappings, ZoneId zoneId, String catalog, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout, RequestInfo requestInfo) {
        super(requestInfo);
        this.query = query;
        this.params = params;
        this.zoneId = zoneId;
        this.catalog = catalog;
        this.fetchSize = fetchSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.runtimeMappings = runtimeMappings;
    }

    protected static <R extends AbstractSqlQueryRequest> ObjectParser<R, Void> objectParser(Supplier<R> supplier) {
        ObjectParser parser = new ObjectParser("sql/query", false, supplier);
        parser.declareString(AbstractSqlQueryRequest::query, QUERY);
        parser.declareString((request, mode) -> request.mode(Mode.fromString((String)mode)), MODE);
        parser.declareString(AbstractSqlRequest::clientId, CLIENT_ID);
        parser.declareString(AbstractSqlRequest::version, VERSION);
        parser.declareField(AbstractSqlQueryRequest::params, AbstractSqlQueryRequest::parseParams, PARAMS, ObjectParser.ValueType.VALUE_ARRAY);
        parser.declareString((request, zoneId) -> request.zoneId(ZoneId.of(zoneId)), TIME_ZONE);
        parser.declareString(AbstractSqlQueryRequest::catalog, CATALOG);
        parser.declareInt(AbstractSqlQueryRequest::fetchSize, FETCH_SIZE);
        parser.declareString((request, timeout) -> request.requestTimeout(TimeValue.parseTimeValue((String)timeout, (TimeValue)Protocol.REQUEST_TIMEOUT, (String)"request_timeout")), REQUEST_TIMEOUT);
        parser.declareString((request, timeout) -> request.pageTimeout(TimeValue.parseTimeValue((String)timeout, (TimeValue)Protocol.PAGE_TIMEOUT, (String)"page_timeout")), PAGE_TIMEOUT);
        parser.declareObject(AbstractSqlQueryRequest::filter, (p, c) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), FILTER);
        parser.declareObject(AbstractSqlQueryRequest::runtimeMappings, (p, c) -> p.map(), SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD);
        return parser;
    }

    public String query() {
        return this.query;
    }

    public AbstractSqlQueryRequest query(String query) {
        if (query == null) {
            throw new IllegalArgumentException("query may not be null.");
        }
        this.query = query;
        return this;
    }

    public List<SqlTypedParamValue> params() {
        return this.params;
    }

    public AbstractSqlQueryRequest params(List<SqlTypedParamValue> params) {
        if (params == null) {
            throw new IllegalArgumentException("params may not be null.");
        }
        this.params = params;
        return this;
    }

    private static List<SqlTypedParamValue> parseParams(XContentParser p) throws IOException {
        ArrayList<SqlTypedParamValue> result = new ArrayList<SqlTypedParamValue>();
        XContentParser.Token token = p.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            Object value = null;
            String type = null;
            SqlTypedParamValue previousParam = null;
            SqlTypedParamValue currentParam = null;
            while ((token = p.nextToken()) != XContentParser.Token.END_ARRAY) {
                XContentLocation loc = p.getTokenLocation();
                if (token == XContentParser.Token.START_OBJECT) {
                    currentParam = (SqlTypedParamValue)SQL_PARAM_PARSER.apply(p, null);
                    if (previousParam != null && !previousParam.hasExplicitType() || result.isEmpty()) {
                        currentParam.tokenLocation(ProtoShim.toProto(loc));
                    }
                } else {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        value = p.text();
                        type = "keyword";
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        XContentParser.NumberType numberType = p.numberType();
                        if (numberType == XContentParser.NumberType.INT) {
                            value = p.intValue();
                            type = "integer";
                        } else if (numberType == XContentParser.NumberType.LONG) {
                            value = p.longValue();
                            type = "long";
                        } else if (numberType == XContentParser.NumberType.FLOAT) {
                            value = Float.valueOf(p.floatValue());
                            type = "float";
                        } else if (numberType == XContentParser.NumberType.DOUBLE) {
                            value = p.doubleValue();
                            type = "double";
                        }
                    } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        value = p.booleanValue();
                        type = "boolean";
                    } else if (token == XContentParser.Token.VALUE_NULL) {
                        value = null;
                        type = "null";
                    } else {
                        throw new XContentParseException(loc, "Failed to parse object: unexpected token [" + token + "] found");
                    }
                    currentParam = new SqlTypedParamValue(type, value, false);
                    if (previousParam != null && previousParam.hasExplicitType() || result.isEmpty()) {
                        currentParam.tokenLocation(ProtoShim.toProto(loc));
                    }
                }
                result.add(currentParam);
                previousParam = currentParam;
            }
        }
        return result;
    }

    protected static void validateParams(List<SqlTypedParamValue> params, Mode mode) {
        for (SqlTypedParamValue param : params) {
            if (Mode.isDriver((Mode)mode) && !param.hasExplicitType()) {
                throw new XContentParseException(ProtoShim.fromProto(param.tokenLocation()), "[params] must be an array where each entry is an object with a value/type pair");
            }
            if (Mode.isDriver((Mode)mode) || !param.hasExplicitType()) continue;
            throw new XContentParseException(ProtoShim.fromProto(param.tokenLocation()), "[params] must be an array where each entry is a single field (no objects supported)");
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        Mode mode = this.requestInfo().mode();
        if (Mode.isDedicatedClient((Mode)mode)) {
            if (this.requestInfo().version() == null) {
                if (Strings.hasText((String)this.query())) {
                    validationException = ValidateActions.addValidationError((String)("[version] is required for the [" + mode.toString() + "] client"), (ActionRequestValidationException)validationException);
                }
            } else if (!SqlVersion.isClientCompatible((SqlVersion)SqlVersion.fromId((int)Version.CURRENT.id), (SqlVersion)this.requestInfo().version())) {
                validationException = ValidateActions.addValidationError((String)("The [" + this.requestInfo().version() + "] version of the [" + mode.toString() + "] client is not compatible with Elasticsearch version [" + Version.CURRENT + "]"), (ActionRequestValidationException)validationException);
            }
        }
        if (this.runtimeMappings != null) {
            validationException = AbstractSqlQueryRequest.validateRuntimeMappings(this.runtimeMappings, validationException);
        }
        return validationException;
    }

    private static ActionRequestValidationException validateRuntimeMappings(Map<String, Object> runtimeMappings, ActionRequestValidationException validationException) {
        for (Map.Entry<String, Object> entry : runtimeMappings.entrySet()) {
            String fieldName = entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map propNode = (Map)entry.getValue();
                if (propNode.get("type") != null) continue;
                return ValidateActions.addValidationError((String)("No type specified for runtime field [" + fieldName + "]"), (ActionRequestValidationException)validationException);
            }
            return ValidateActions.addValidationError((String)("Expected map for runtime field [" + fieldName + "] definition but got [" + fieldName.getClass().getSimpleName() + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public AbstractSqlQueryRequest zoneId(ZoneId zoneId) {
        if (zoneId == null) {
            throw new IllegalArgumentException("time zone may not be null.");
        }
        this.zoneId = zoneId;
        return this;
    }

    public String catalog() {
        return this.catalog;
    }

    public AbstractSqlQueryRequest catalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public AbstractSqlQueryRequest fetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("fetch_size must be more than 0.");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public AbstractSqlQueryRequest requestTimeout(TimeValue requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public AbstractSqlQueryRequest pageTimeout(TimeValue pageTimeout) {
        this.pageTimeout = pageTimeout;
        return this;
    }

    public AbstractSqlQueryRequest filter(QueryBuilder filter) {
        this.filter = filter;
        return this;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Map<String, Object> runtimeMappings() {
        return this.runtimeMappings;
    }

    public AbstractSqlQueryRequest runtimeMappings(Map<String, Object> runtimeMappings) {
        this.runtimeMappings = runtimeMappings;
        return this;
    }

    public AbstractSqlQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.query = in.readString();
        this.params = in.readList(AbstractSqlQueryRequest::readSqlTypedParamValue);
        this.zoneId = in.readZoneId();
        if (in.getVersion().onOrAfter(Version.V_7_16_0)) {
            this.catalog = in.readOptionalString();
        }
        this.fetchSize = in.readVInt();
        this.requestTimeout = in.readTimeValue();
        this.pageTimeout = in.readTimeValue();
        this.filter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        if (in.getVersion().onOrAfter(Version.V_7_13_0)) {
            this.runtimeMappings = in.readMap();
        }
    }

    public static void writeSqlTypedParamValue(StreamOutput out, SqlTypedParamValue value) throws IOException {
        out.writeString(value.type);
        out.writeGenericValue(value.value);
        out.writeBoolean(value.hasExplicitType());
    }

    public static SqlTypedParamValue readSqlTypedParamValue(StreamInput in) throws IOException {
        return new SqlTypedParamValue(in.readString(), in.readGenericValue(), in.readBoolean());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.query);
        out.writeVInt(this.params.size());
        for (SqlTypedParamValue param : this.params) {
            AbstractSqlQueryRequest.writeSqlTypedParamValue(out, param);
        }
        out.writeZoneId(this.zoneId);
        if (out.getVersion().onOrAfter(Version.V_7_16_0)) {
            out.writeOptionalString(this.catalog);
        }
        out.writeVInt(this.fetchSize);
        out.writeTimeValue(this.requestTimeout);
        out.writeTimeValue(this.pageTimeout);
        out.writeOptionalNamedWriteable((NamedWriteable)this.filter);
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeMap(this.runtimeMappings);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractSqlQueryRequest that = (AbstractSqlQueryRequest)((Object)o);
        return this.fetchSize == that.fetchSize && Objects.equals(this.query, that.query) && Objects.equals(this.params, that.params) && Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pageTimeout, that.pageTimeout) && Objects.equals(this.filter, that.filter) && Objects.equals(this.runtimeMappings, that.runtimeMappings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.params, this.zoneId, this.catalog, this.fetchSize, this.requestTimeout, this.pageTimeout, this.filter, this.runtimeMappings);
    }

    static {
        SQL_PARAM_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), VALUE, ObjectParser.ValueType.VALUE);
        SQL_PARAM_PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        QUERY = new ParseField("query", new String[0]);
        CURSOR = new ParseField("cursor", new String[0]);
        PARAMS = new ParseField("params", new String[0]);
        TIME_ZONE = new ParseField("time_zone", new String[0]);
        CATALOG = new ParseField("catalog", new String[0]);
        FETCH_SIZE = new ParseField("fetch_size", new String[0]);
        REQUEST_TIMEOUT = new ParseField("request_timeout", new String[0]);
        PAGE_TIMEOUT = new ParseField("page_timeout", new String[0]);
        FILTER = new ParseField("filter", new String[0]);
        MODE = new ParseField("mode", new String[0]);
        CLIENT_ID = new ParseField("client_id", new String[0]);
        VERSION = new ParseField("version", new String[0]);
    }
}

