/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.TDistribution;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.analytics.ttest.TTestState;
import org.elasticsearch.xpack.analytics.ttest.TTestStats;

public class UnpairedTTestState
implements TTestState {
    public static final String NAME = "U";
    private final TTestStats a;
    private final TTestStats b;
    private boolean homoscedastic;
    private int tails;

    public UnpairedTTestState(TTestStats a, TTestStats b, boolean homoscedastic, int tails) {
        this.a = a;
        this.b = b;
        this.homoscedastic = homoscedastic;
        this.tails = tails;
    }

    public UnpairedTTestState(StreamInput in) throws IOException {
        this.a = new TTestStats(in);
        this.b = new TTestStats(in);
        this.homoscedastic = in.readBoolean();
        this.tails = in.readVInt();
    }

    @Override
    public double getValue() {
        if (this.a.count < 2L || this.b.count < 2L) {
            return Double.NaN;
        }
        if (this.homoscedastic) {
            long n = this.a.count + this.b.count - 2L;
            double variance = ((double)(this.a.count - 1L) * this.a.variance() + (double)(this.b.count - 1L) * this.b.variance()) / (double)n;
            double nn = 1.0 / (double)this.a.count + 1.0 / (double)this.b.count;
            return this.p(variance * nn, n);
        }
        double s2an = this.a.variance() / (double)this.a.count;
        double s2bn = this.b.variance() / (double)this.b.count;
        double variance = s2an + s2bn;
        double degreeOfFreedom = variance * variance / (s2an * s2an / (double)(this.a.count - 1L) + s2bn * s2bn / (double)(this.b.count - 1L));
        return this.p(variance, degreeOfFreedom);
    }

    private double p(double sd2, double degreesOfFreedom) {
        if (degreesOfFreedom < 0.0) {
            return Double.NaN;
        }
        double sd = Math.sqrt(sd2);
        double meanDiff = this.a.average() - this.b.average();
        double t = Math.abs(meanDiff / sd);
        TDistribution dist = new TDistribution(degreesOfFreedom);
        return dist.cumulativeProbability(-t) * (double)this.tails;
    }

    @Override
    public TTestState reduce(Stream<TTestState> states) {
        TTestStats.Reducer reducerA = new TTestStats.Reducer();
        TTestStats.Reducer reducerB = new TTestStats.Reducer();
        states.forEach(tTestState -> {
            UnpairedTTestState state = (UnpairedTTestState)tTestState;
            if (state.homoscedastic != this.homoscedastic) {
                throw new IllegalStateException("Incompatible homoscedastic mode in the reduce. Expected " + state.homoscedastic + " reduced with " + this.homoscedastic);
            }
            if (state.tails != this.tails) {
                throw new IllegalStateException("Incompatible tails value in the reduce. Expected " + state.tails + " reduced with " + this.tails);
            }
            reducerA.accept(state.a);
            reducerB.accept(state.b);
        });
        return new UnpairedTTestState(reducerA.result(), reducerB.result(), this.homoscedastic, this.tails);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.a.writeTo(out);
        this.b.writeTo(out);
        out.writeBoolean(this.homoscedastic);
        out.writeVInt(this.tails);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnpairedTTestState that = (UnpairedTTestState)o;
        return this.homoscedastic == that.homoscedastic && this.tails == that.tails && this.a.equals(that.a) && this.b.equals(that.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b, this.homoscedastic, this.tails);
    }
}

