/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xpack.analytics.aggregations.metrics.AbstractHistoBackedTDigestPercentilesAggregator;

public class HistoBackedTDigestPercentilesAggregator
extends AbstractHistoBackedTDigestPercentilesAggregator {
    public HistoBackedTDigestPercentilesAggregator(String name, ValuesSource valuesSource, AggregationContext context, Aggregator parent, double[] percents, double compression, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, compression, keyed, formatter, metadata);
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentiles(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.quantile(Double.parseDouble(name) / 100.0);
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalTDigestPercentiles(this.name, this.keys, new TDigestState(this.compression), this.keyed, this.formatter, this.metadata());
    }
}

