/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.security.authc.saml.SamlMessageBuilder;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;

class SamlLogoutResponseBuilder
extends SamlMessageBuilder {
    private final String inResponseTo;
    private final String statusValue;

    SamlLogoutResponseBuilder(Clock clock, SpConfiguration serviceProvider, EntityDescriptor identityProvider, String inResponseTo, String statusValue) {
        super(identityProvider, serviceProvider, clock);
        this.inResponseTo = inResponseTo;
        this.statusValue = statusValue;
    }

    LogoutResponse build() {
        String destination = this.getLogoutUrl();
        if (Strings.isNullOrEmpty((String)destination)) {
            throw SamlUtils.samlException("Cannot send LogoutResponse because the IDP {} does not provide a logout service", this.identityProvider.getEntityID());
        }
        LogoutResponse res = SamlUtils.buildObject(LogoutResponse.class, LogoutResponse.DEFAULT_ELEMENT_NAME);
        res.setID(this.buildId());
        res.setIssueInstant(this.now());
        res.setDestination(destination);
        res.setIssuer(this.buildIssuer());
        res.setInResponseTo(this.inResponseTo);
        Status status = SamlUtils.buildObject(Status.class, Status.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = SamlUtils.buildObject(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        statusCode.setValue(this.statusValue);
        status.setStatusCode(statusCode);
        res.setStatus(status);
        return res;
    }

    protected String getLogoutUrl() {
        return this.getIdentityProviderEndpoint("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", SSODescriptor::getSingleLogoutServices);
    }
}

