/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.user.User;

public class SecondaryAuthentication {
    public static final String THREAD_CTX_KEY = "_xpack_security_secondary_authc";
    private final SecurityContext securityContext;
    private final Authentication authentication;

    public SecondaryAuthentication(SecurityContext securityContext, Authentication authentication) {
        this.securityContext = Objects.requireNonNull(securityContext);
        this.authentication = Objects.requireNonNull(authentication);
    }

    @Nullable
    public static SecondaryAuthentication readFromContext(SecurityContext securityContext) throws IOException {
        Authentication authentication = SecondaryAuthentication.serializer().readFromContext(securityContext.getThreadContext());
        if (authentication == null) {
            return null;
        }
        return new SecondaryAuthentication(securityContext, authentication);
    }

    public void writeToContext(ThreadContext threadContext) throws IOException {
        SecondaryAuthentication.serializer().writeToContext(this.authentication, threadContext);
    }

    private static AuthenticationContextSerializer serializer() {
        return new AuthenticationContextSerializer(THREAD_CTX_KEY);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public User getUser() {
        return this.authentication.getUser();
    }

    public <T> T execute(Function<ThreadContext.StoredContext, T> body) {
        return this.securityContext.executeWithAuthentication(this.authentication, body);
    }

    public Runnable wrap(Runnable runnable) {
        return () -> this.execute(ignore -> {
            runnable.run();
            return null;
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.authentication + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecondaryAuthentication that = (SecondaryAuthentication)o;
        return this.authentication.equals(that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.authentication);
    }
}

