/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding;

public final class ScriptDetector {
    private ScriptDetector() {
    }

    public static enum Script {
        kScriptError(0),
        kScriptOtherUtf8OneByte(1),
        kScriptOtherUtf8TwoBytes(2),
        kScriptOtherUtf8ThreeBytes(3),
        kScriptOtherUtf8FourBytes(4),
        kScriptGreek(5),
        kScriptCyrillic(6),
        kScriptHebrew(7),
        kScriptArabic(8),
        kScriptHangulJamo(9),
        kScriptHiragana(10),
        kScriptKatakana(11);

        private final int code;

        private Script(int code) {
            this.code = code;
        }

        public int toInt() {
            return this.code;
        }

        public static Script fromCodePoint(int codePoint) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
            if (Character.UnicodeBlock.GREEK.equals(block)) {
                return kScriptGreek;
            }
            if (Character.UnicodeBlock.CYRILLIC.equals(block)) {
                return kScriptCyrillic;
            }
            if (Character.UnicodeBlock.ARABIC.equals(block)) {
                return kScriptArabic;
            }
            if (Character.UnicodeBlock.HEBREW.equals(block)) {
                return kScriptHebrew;
            }
            if (Character.UnicodeBlock.KATAKANA.equals(block)) {
                return kScriptKatakana;
            }
            if (Character.UnicodeBlock.HIRAGANA.equals(block)) {
                return kScriptHiragana;
            }
            if (Character.UnicodeBlock.HANGUL_JAMO.equals(block)) {
                return kScriptHangulJamo;
            }
            if (codePoint > 0) {
                if (codePoint < 128) {
                    return kScriptOtherUtf8OneByte;
                }
                if (codePoint < 2048) {
                    return kScriptOtherUtf8TwoBytes;
                }
                if (codePoint < 65536) {
                    return kScriptOtherUtf8ThreeBytes;
                }
                if (codePoint < 0x110000) {
                    return kScriptOtherUtf8FourBytes;
                }
            }
            return kScriptError;
        }
    }
}

