/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationParameters;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.Regression;

public class Huber
implements EvaluationMetric {
    public static final ParseField NAME = new ParseField(Regression.LossFunction.HUBER.toString(), new String[0]);
    public static final ParseField DELTA = new ParseField("delta", new String[0]);
    private static final double DEFAULT_DELTA = 1.0;
    private static final String PAINLESS_TEMPLATE = "def a = doc[''{0}''].value - doc[''{1}''].value;def delta2 = {2};return delta2 * (Math.sqrt(1.0 + Math.pow(a, 2) / delta2) - 1.0);";
    private static final String AGG_NAME = "regression_" + NAME.getPreferredName();
    private static final ConstructingObjectParser<Huber, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, args -> new Huber((Double)args[0]));
    private final double delta;
    private EvaluationMetricResult result;

    private static String buildScript(Object ... args) {
        return new MessageFormat(PAINLESS_TEMPLATE, Locale.ROOT).format(args);
    }

    public static Huber fromXContent(XContentParser parser) {
        return (Huber)PARSER.apply(parser, null);
    }

    public Huber(StreamInput in) throws IOException {
        this.delta = in.readDouble();
    }

    public Huber() {
        this(1.0);
    }

    public Huber(@Nullable Double delta) {
        this.delta = delta != null ? delta : 1.0;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public Set<String> getRequiredFields() {
        return Sets.newHashSet((Object[])new String[]{EvaluationFields.ACTUAL_FIELD.getPreferredName(), EvaluationFields.PREDICTED_FIELD.getPreferredName()});
    }

    @Override
    public Tuple<List<AggregationBuilder>, List<PipelineAggregationBuilder>> aggs(EvaluationParameters parameters, EvaluationFields fields) {
        if (this.result != null) {
            return Tuple.tuple(Collections.emptyList(), Collections.emptyList());
        }
        String actualField = fields.getActualField();
        String predictedField = fields.getPredictedField();
        return Tuple.tuple(Arrays.asList(AggregationBuilders.avg((String)AGG_NAME).script(new Script(Huber.buildScript(actualField, predictedField, this.delta * this.delta)))), Collections.emptyList());
    }

    @Override
    public void process(Aggregations aggs) {
        NumericMetricsAggregation.SingleValue value = (NumericMetricsAggregation.SingleValue)aggs.get(AGG_NAME);
        this.result = value == null ? new Result(0.0) : new Result(value.value());
    }

    public Optional<EvaluationMetricResult> getResult() {
        return Optional.ofNullable(this.result);
    }

    public String getWriteableName() {
        return MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, NAME);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.delta);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DELTA.getPreferredName(), this.delta);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Huber that = (Huber)o;
        return this.delta == that.delta;
    }

    public int hashCode() {
        return Double.hashCode(this.delta);
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), DELTA);
    }

    public static class Result
    implements EvaluationMetricResult {
        private static final String VALUE = "value";
        private final double value;

        public Result(double value) {
            this.value = value;
        }

        public Result(StreamInput in) throws IOException {
            this.value = in.readDouble();
        }

        public String getWriteableName() {
            return MlEvaluationNamedXContentProvider.registeredMetricName(Regression.NAME, NAME);
        }

        @Override
        public String getMetricName() {
            return NAME.getPreferredName();
        }

        public double getValue() {
            return this.value;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.value);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(VALUE, this.value);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result other = (Result)o;
            return this.value == other.value;
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }
    }
}

