/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.Step;

public final class PhaseCacheManagement {
    private static final Logger logger = LogManager.getLogger(PhaseCacheManagement.class);

    private PhaseCacheManagement() {
    }

    public static ClusterState refreshPhaseDefinition(ClusterState state, String index, LifecyclePolicyMetadata updatedPolicy) {
        IndexMetadata idxMeta = state.metadata().index(index);
        Metadata.Builder metadataBuilder = Metadata.builder((Metadata)state.metadata());
        PhaseCacheManagement.refreshPhaseDefinition(metadataBuilder, idxMeta, updatedPolicy);
        return ClusterState.builder((ClusterState)state).metadata(metadataBuilder.build(false)).build();
    }

    public static void refreshPhaseDefinition(Metadata.Builder metadataBuilder, IndexMetadata idxMeta, LifecyclePolicyMetadata updatedPolicy) {
        String index = idxMeta.getIndex().getName();
        assert (PhaseCacheManagement.eligibleToCheckForRefresh(idxMeta)) : "index " + index + " is missing crucial information needed to refresh phase definition";
        logger.trace("[{}] updating cached phase definition for policy [{}]", (Object)index, (Object)updatedPolicy.getName());
        LifecycleExecutionState currentExState = LifecycleExecutionState.fromIndexMetadata(idxMeta);
        String currentPhase = currentExState.getPhase();
        PhaseExecutionInfo pei = new PhaseExecutionInfo(updatedPolicy.getName(), updatedPolicy.getPolicy().getPhases().get(currentPhase), updatedPolicy.getVersion(), updatedPolicy.getModifiedDate());
        LifecycleExecutionState newExState = LifecycleExecutionState.builder(currentExState).setPhaseDefinition(Strings.toString((ToXContent)pei, (boolean)false, (boolean)false)).build();
        metadataBuilder.put(IndexMetadata.builder((IndexMetadata)idxMeta).putCustom("ilm", newExState.asMap()));
    }

    public static boolean eligibleToCheckForRefresh(IndexMetadata metadata) {
        LifecycleExecutionState executionState = LifecycleExecutionState.fromIndexMetadata(metadata);
        if (executionState == null || executionState.getPhaseDefinition() == null) {
            return false;
        }
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey(executionState);
        if (currentStepKey == null || currentStepKey.getPhase() == null) {
            return false;
        }
        return !"ERROR".equals(currentStepKey.getName());
    }

    public static ClusterState updateIndicesForPolicy(ClusterState state, NamedXContentRegistry xContentRegistry, Client client, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicy, XPackLicenseState licenseState) {
        Metadata.Builder mb = Metadata.builder((Metadata)state.metadata());
        if (PhaseCacheManagement.updateIndicesForPolicy(mb, state, xContentRegistry, client, oldPolicy, newPolicy, licenseState)) {
            return ClusterState.builder((ClusterState)state).metadata(mb.build(false)).build();
        }
        return state;
    }

    public static boolean updateIndicesForPolicy(Metadata.Builder mb, ClusterState currentState, NamedXContentRegistry xContentRegistry, Client client, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicy, XPackLicenseState licenseState) {
        assert (oldPolicy.getName().equals(newPolicy.getName())) : "expected both policies to have the same id but they were: [" + oldPolicy.getName() + "] vs. [" + newPolicy.getName() + "]";
        if (oldPolicy.equals((Object)newPolicy.getPolicy())) {
            logger.debug("policy [{}] is unchanged and no phase definition refresh is needed", (Object)oldPolicy.getName());
            return false;
        }
        List indicesThatCanBeUpdated = currentState.metadata().indices().values().stream().filter(meta -> newPolicy.getName().equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(meta.getSettings()))).filter(meta -> PhaseCacheManagement.isIndexPhaseDefinitionUpdatable(xContentRegistry, client, meta, newPolicy.getPolicy(), licenseState)).collect(Collectors.toList());
        ArrayList<String> refreshedIndices = new ArrayList<String>(indicesThatCanBeUpdated.size());
        for (IndexMetadata index : indicesThatCanBeUpdated) {
            try {
                PhaseCacheManagement.refreshPhaseDefinition(mb, index, newPolicy);
                refreshedIndices.add(index.getIndex().getName());
            }
            catch (Exception e) {
                logger.warn((Message)new ParameterizedMessage("[{}] unable to refresh phase definition for updated policy [{}]", (Object)index, (Object)newPolicy.getName()), (Throwable)e);
            }
        }
        logger.debug("refreshed policy [{}] phase definition for [{}] indices", (Object)newPolicy.getName(), (Object)refreshedIndices.size());
        return refreshedIndices.size() > 0;
    }

    public static boolean isIndexPhaseDefinitionUpdatable(NamedXContentRegistry xContentRegistry, Client client, IndexMetadata metadata, LifecyclePolicy newPolicy, XPackLicenseState licenseState) {
        String index = metadata.getIndex().getName();
        if (!PhaseCacheManagement.eligibleToCheckForRefresh(metadata)) {
            logger.debug("[{}] does not contain enough information to check for eligibility of refreshing phase", (Object)index);
            return false;
        }
        String policyId = newPolicy.getName();
        LifecycleExecutionState executionState = LifecycleExecutionState.fromIndexMetadata(metadata);
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey(executionState);
        String currentPhase = currentStepKey.getPhase();
        Set newStepKeys = newPolicy.toSteps(client, licenseState).stream().map(Step::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!newStepKeys.contains(currentStepKey)) {
            logger.debug("[{}] updated policy [{}] does not contain the current step key [{}], so the policy phase will not be refreshed", (Object)index, (Object)policyId, (Object)currentStepKey);
            return false;
        }
        String phaseDef = executionState.getPhaseDefinition();
        Set<Step.StepKey> oldStepKeys = PhaseCacheManagement.readStepKeys(xContentRegistry, client, phaseDef, currentPhase, licenseState);
        if (oldStepKeys == null) {
            logger.debug("[{}] unable to parse phase definition for cached policy [{}], policy phase will not be refreshed", (Object)index, (Object)policyId);
            return false;
        }
        Set oldPhaseStepKeys = oldStepKeys.stream().filter(sk -> currentPhase.equals(sk.getPhase())).collect(Collectors.toCollection(LinkedHashSet::new));
        PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(policyId, newPolicy.getPhases().get(currentPhase), 1L, 1L);
        String peiJson = Strings.toString((ToXContent)phaseExecutionInfo);
        Set<Step.StepKey> newPhaseStepKeys = PhaseCacheManagement.readStepKeys(xContentRegistry, client, peiJson, currentPhase, licenseState);
        if (newPhaseStepKeys == null) {
            logger.debug((Message)new ParameterizedMessage("[{}] unable to parse phase definition for policy [{}] to determine if it could be refreshed", (Object)index, (Object)policyId));
            return false;
        }
        if (newPhaseStepKeys.equals(oldPhaseStepKeys)) {
            logger.debug("[{}] updated policy [{}] contains the same phase step keys and can be refreshed", (Object)index, (Object)policyId);
            return true;
        }
        logger.debug("[{}] updated policy [{}] has different phase step keys and will NOT refresh phase definition as it differs too greatly. old: {}, new: {}", (Object)index, (Object)policyId, (Object)oldPhaseStepKeys, newPhaseStepKeys);
        return false;
    }

    @Nullable
    static Set<Step.StepKey> readStepKeys(NamedXContentRegistry xContentRegistry, Client client, String phaseDef, String currentPhase, XPackLicenseState licenseState) {
        PhaseExecutionInfo phaseExecutionInfo;
        if (phaseDef == null) {
            return null;
        }
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, phaseDef);){
            phaseExecutionInfo = PhaseExecutionInfo.parse(parser, currentPhase);
        }
        catch (Exception e) {
            logger.trace((Message)new ParameterizedMessage("exception reading step keys checking for refreshability, phase definition: {}", (Object)phaseDef), (Throwable)e);
            return null;
        }
        if (phaseExecutionInfo == null || phaseExecutionInfo.getPhase() == null) {
            return null;
        }
        return phaseExecutionInfo.getPhase().getActions().values().stream().flatMap(a -> a.toSteps(client, phaseExecutionInfo.getPhase().getName(), null, licenseState).stream()).map(Step::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

