/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformMetadata;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.transform.Transform;
import org.elasticsearch.xpack.transform.transforms.TransformNodeAssignments;

public final class TransformNodes {
    private TransformNodes() {
    }

    public static TransformNodeAssignments transformTaskNodes(List<String> transformIds, ClusterState clusterState) {
        HashSet<String> executorNodes = new HashSet<String>();
        HashSet<String> assigned = new HashSet<String>();
        HashSet<String> waitingForAssignment = new HashSet<String>();
        PersistentTasksCustomMetadata tasksMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)clusterState);
        if (tasksMetadata != null) {
            HashSet<String> transformIdsSet = new HashSet<String>(transformIds);
            Collection tasks = tasksMetadata.findTasks("data_frame/transforms", t -> transformIdsSet.contains(t.getId()));
            for (PersistentTasksCustomMetadata.PersistentTask task : tasks) {
                if (task.isAssigned()) {
                    executorNodes.add(task.getExecutorNode());
                    assigned.add(task.getId());
                    continue;
                }
                waitingForAssignment.add(task.getId());
            }
        }
        Set<String> stopped = transformIds.stream().filter(id -> !(assigned.contains(id) || waitingForAssignment.contains(id))).collect(Collectors.toSet());
        return new TransformNodeAssignments(executorNodes, assigned, waitingForAssignment, stopped);
    }

    public static TransformNodeAssignments findPersistentTasks(String transformId, ClusterState clusterState) {
        HashSet<String> executorNodes = new HashSet<String>();
        HashSet<String> assigned = new HashSet<String>();
        HashSet<String> waitingForAssignment = new HashSet<String>();
        PersistentTasksCustomMetadata tasksMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)clusterState);
        if (tasksMetadata != null) {
            Predicate<PersistentTasksCustomMetadata.PersistentTask> taskMatcher = Strings.isAllOrWildcard((String[])new String[]{transformId}) ? t -> true : t -> {
                TransformTaskParams transformParams = (TransformTaskParams)t.getParams();
                return Regex.simpleMatch((String)transformId, (String)transformParams.getId());
            };
            for (PersistentTasksCustomMetadata.PersistentTask task : tasksMetadata.findTasks("data_frame/transforms", taskMatcher)) {
                if (task.isAssigned()) {
                    executorNodes.add(task.getExecutorNode());
                    assigned.add(task.getId());
                    continue;
                }
                waitingForAssignment.add(task.getId());
            }
        }
        return new TransformNodeAssignments(executorNodes, assigned, waitingForAssignment, Collections.emptySet());
    }

    public static PersistentTasksCustomMetadata.Assignment getAssignment(String transformId, ClusterState clusterState) {
        PersistentTasksCustomMetadata tasksMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)clusterState);
        PersistentTasksCustomMetadata.PersistentTask task = tasksMetadata.getTask(transformId);
        if (task != null) {
            return task.getAssignment();
        }
        return PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT;
    }

    public static boolean hasAnyTransformNode(DiscoveryNodes nodes) {
        return StreamSupport.stream(nodes.spliterator(), false).anyMatch(node -> node.getRoles().contains(Transform.TRANSFORM_ROLE));
    }

    public static void warnIfNoTransformNodes(ClusterState clusterState) {
        if (!TransformMetadata.getTransformMetadata((ClusterState)clusterState).isResetMode() && !TransformNodes.hasAnyTransformNode(clusterState.getNodes())) {
            HeaderWarning.addWarning((String)"Transform requires the transform node role for at least 1 node, found no transform nodes", (Object[])new Object[0]);
        }
    }

    public static void throwIfNoTransformNodes(ClusterState clusterState) {
        if (!TransformNodes.hasAnyTransformNode(clusterState.getNodes())) {
            throw ExceptionsHelper.badRequestException((String)"Transform requires the transform node role for at least 1 node, found no transform nodes", (Object[])new Object[0]);
        }
    }

    public static <Request extends TransportRequest, Response extends TransportResponse> boolean redirectToAnotherNodeIfNeeded(ClusterState clusterState, Settings nodeSettings, boolean requiresRemote, TransportService transportService, String actionName, Request request, Writeable.Reader<Response> reader, ActionListener<Response> listener) {
        boolean isTransformNode = DiscoveryNode.hasRole((Settings)nodeSettings, (DiscoveryNodeRole)Transform.TRANSFORM_ROLE);
        boolean isRemoteClusterClientNode = DiscoveryNode.isRemoteClusterClient((Settings)nodeSettings);
        DiscoveryNodes nodes = clusterState.nodes();
        if (!isTransformNode || requiresRemote && !isRemoteClusterClientNode) {
            Optional<DiscoveryNode> appropriateNode = TransformNodes.selectAnyNodeThatCanRunThisTransform(nodes, requiresRemote);
            if (appropriateNode.isPresent()) {
                transportService.sendRequest(appropriateNode.get(), actionName, request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, reader));
            } else {
                TreeMap<String, String> explain = new TreeMap<String, String>();
                for (DiscoveryNode node : nodes) {
                    TransformNodes.nodeCanRunThisTransform(node, Version.V_7_13_0, requiresRemote, explain);
                }
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"No appropriate node to run on, reasons [{}]", (Object[])new Object[]{explain.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining("|"))}));
            }
            return true;
        }
        return false;
    }

    static Optional<DiscoveryNode> selectAnyNodeThatCanRunThisTransform(DiscoveryNodes nodes, boolean requiresRemote) {
        return StreamSupport.stream(nodes.spliterator(), false).filter(node -> TransformNodes.nodeCanRunThisTransform(node, Version.V_7_13_0, requiresRemote, null)).findAny();
    }

    public static boolean nodeCanRunThisTransform(DiscoveryNode node, Version minRequiredVersion, boolean requiresRemote, Map<String, String> explain) {
        if (!node.getVersion().onOrAfter(minRequiredVersion)) {
            if (explain != null) {
                explain.put(node.getId(), "node has version: " + node.getVersion() + " but transform requires at least " + minRequiredVersion);
            }
            return false;
        }
        if (!node.getRoles().contains(Transform.TRANSFORM_ROLE)) {
            if (explain != null) {
                explain.put(node.getId(), "not a transform node");
            }
            return false;
        }
        if (requiresRemote && !node.isRemoteClusterClient()) {
            if (explain != null) {
                explain.put(node.getId(), "transform requires a remote connection but remote is disabled");
            }
            return false;
        }
        return true;
    }

    public static boolean nodeCanRunThisTransformPre77(DiscoveryNode node, Version minRequiredVersion, Map<String, String> explain) {
        if (!node.canContainData()) {
            if (explain != null) {
                explain.put(node.getId(), "not a data node");
            }
            return false;
        }
        if (!node.getVersion().onOrAfter(minRequiredVersion)) {
            if (explain != null) {
                explain.put(node.getId(), "node has version: " + node.getVersion() + " but transform requires at least " + minRequiredVersion);
            }
            return false;
        }
        return true;
    }
}

