/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.modelsnapshots;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.List;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestRevertModelSnapshotAction
extends BaseRestHandler {
    private static final boolean DELETE_INTERVENING_DEFAULT = false;

    public java.util.List<RestHandler.Route> routes() {
        return List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/model_snapshots/{" + RevertModelSnapshotAction.Request.SNAPSHOT_ID + "}/_revert")).replaces(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/model_snapshots/{" + RevertModelSnapshotAction.Request.SNAPSHOT_ID + "}/_revert", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_revert_model_snapshot_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RevertModelSnapshotAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String snapshotId = restRequest.param(RevertModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = RevertModelSnapshotAction.Request.parseRequest((String)jobId, (String)snapshotId, (XContentParser)parser);
        } else {
            request = new RevertModelSnapshotAction.Request(jobId, snapshotId);
            request.setDeleteInterveningResults(restRequest.paramAsBoolean(RevertModelSnapshotAction.Request.DELETE_INTERVENING.getPreferredName(), false));
        }
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        request.masterNodeTimeout(restRequest.paramAsTime("master_timeout", request.masterNodeTimeout()));
        return channel -> client.execute((ActionType)RevertModelSnapshotAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

