/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;

public abstract class AbstractTransportSearchableSnapshotsAction<Request extends BroadcastRequest<Request>, Response extends BroadcastResponse, ShardOperationResult extends Writeable>
extends TransportBroadcastByNodeAction<Request, Response, ShardOperationResult> {
    private final IndicesService indicesService;
    private final XPackLicenseState licenseState;

    AbstractTransportSearchableSnapshotsAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, Writeable.Reader<Request> request, String executor, IndicesService indicesService, XPackLicenseState licenseState) {
        super(actionName, clusterService, transportService, actionFilters, resolver, request, executor);
        this.indicesService = indicesService;
        this.licenseState = Objects.requireNonNull(licenseState);
    }

    AbstractTransportSearchableSnapshotsAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, Writeable.Reader<Request> request, String executor, IndicesService indicesService, XPackLicenseState licenseState, boolean canTripCircuitBreaker) {
        super(actionName, clusterService, transportService, actionFilters, resolver, request, executor, canTripCircuitBreaker);
        this.indicesService = indicesService;
        this.licenseState = Objects.requireNonNull(licenseState);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, Request request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, Request request, String[] indices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, indices);
    }

    protected ShardsIterator shards(ClusterState state, Request request, String[] concreteIndices) {
        ArrayList<String> searchableSnapshotIndices = new ArrayList<String>();
        for (String concreteIndex : concreteIndices) {
            Settings indexSettings;
            IndexMetadata indexMetaData = state.metadata().index(concreteIndex);
            if (indexMetaData == null || !SearchableSnapshotsSettings.isSearchableSnapshotStore((Settings)(indexSettings = indexMetaData.getSettings()))) continue;
            searchableSnapshotIndices.add(concreteIndex);
        }
        if (searchableSnapshotIndices.isEmpty()) {
            throw new ResourceNotFoundException("No searchable snapshots indices found", new Object[0]);
        }
        return state.routingTable().allShards(searchableSnapshotIndices.toArray(new String[0]));
    }

    protected void shardOperation(Request request, ShardRouting shardRouting, Task task, ActionListener<ShardOperationResult> listener) {
        ActionListener.completeWith(listener, () -> {
            SearchableSnapshots.ensureValidLicense(this.licenseState);
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.index()).getShard(shardRouting.id());
            SearchableSnapshotDirectory directory = SearchableSnapshotDirectory.unwrapDirectory(indexShard.store().directory());
            assert (directory != null);
            assert (directory.getShardId().equals((Object)shardRouting.shardId()));
            return this.executeShardOperation(request, shardRouting, directory);
        });
    }

    protected abstract ShardOperationResult executeShardOperation(Request var1, ShardRouting var2, SearchableSnapshotDirectory var3) throws IOException;
}

