/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.AuthorityKeyIdentifierExtension;
import com.unboundid.util.ssl.cert.BasicConstraintsExtension;
import com.unboundid.util.ssl.cert.CRLDistributionPointsExtension;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.ExtendedKeyUsageExtension;
import com.unboundid.util.ssl.cert.IssuerAlternativeNameExtension;
import com.unboundid.util.ssl.cert.KeyUsageExtension;
import com.unboundid.util.ssl.cert.SubjectAlternativeNameExtension;
import com.unboundid.util.ssl.cert.SubjectKeyIdentifierExtension;
import java.io.Serializable;
import java.util.ArrayList;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class X509CertificateExtension
implements Serializable {
    private static final long serialVersionUID = -4044598072050168580L;
    private final boolean isCritical;
    private final byte[] value;
    private final OID oid;

    protected X509CertificateExtension(X509CertificateExtension extension) {
        this.oid = extension.oid;
        this.isCritical = extension.isCritical;
        this.value = extension.value;
    }

    public X509CertificateExtension(OID oid, boolean isCritical, byte[] value) {
        this.oid = oid;
        this.isCritical = isCritical;
        this.value = value;
    }

    static X509CertificateExtension decode(ASN1Element extensionElement) throws CertException {
        X509CertificateExtension extension;
        OID oid;
        try {
            byte[] value;
            boolean isCritical;
            ASN1Element[] elements = extensionElement.decodeAsSequence().elements();
            oid = elements[0].decodeAsObjectIdentifier().getOID();
            if (elements[1].getType() == 1) {
                isCritical = elements[1].decodeAsBoolean().booleanValue();
                value = elements[2].decodeAsOctetString().getValue();
            } else {
                isCritical = false;
                value = elements[1].decodeAsOctetString().getValue();
            }
            extension = new X509CertificateExtension(oid, isCritical, value);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_EXTENSION_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (oid.equals(AuthorityKeyIdentifierExtension.AUTHORITY_KEY_IDENTIFIER_OID)) {
            try {
                return new AuthorityKeyIdentifierExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(SubjectKeyIdentifierExtension.SUBJECT_KEY_IDENTIFIER_OID)) {
            try {
                return new SubjectKeyIdentifierExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(KeyUsageExtension.KEY_USAGE_OID)) {
            try {
                return new KeyUsageExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(SubjectAlternativeNameExtension.SUBJECT_ALTERNATIVE_NAME_OID)) {
            try {
                return new SubjectAlternativeNameExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(IssuerAlternativeNameExtension.ISSUER_ALTERNATIVE_NAME_OID)) {
            try {
                return new IssuerAlternativeNameExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(BasicConstraintsExtension.BASIC_CONSTRAINTS_OID)) {
            try {
                return new BasicConstraintsExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(ExtendedKeyUsageExtension.EXTENDED_KEY_USAGE_OID)) {
            try {
                return new ExtendedKeyUsageExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        } else if (oid.equals(CRLDistributionPointsExtension.CRL_DISTRIBUTION_POINTS_OID)) {
            try {
                return new CRLDistributionPointsExtension(extension);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return extension;
    }

    public final OID getOID() {
        return this.oid;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final byte[] getValue() {
        return this.value;
    }

    ASN1Sequence encode() throws CertException {
        try {
            ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
            elements.add(new ASN1ObjectIdentifier(this.oid));
            if (this.isCritical) {
                elements.add(ASN1Boolean.UNIVERSAL_BOOLEAN_TRUE_ELEMENT);
            }
            elements.add(new ASN1OctetString(this.value));
            return new ASN1Sequence(elements);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_EXTENSION_ENCODE_ERROR.get(this.toString(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getExtensionName() {
        return this.oid.toString();
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("X509CertificateExtension(oid='");
        buffer.append(this.oid.toString());
        buffer.append("', isCritical=");
        buffer.append(this.isCritical);
        if (StaticUtils.isPrintableString(this.value)) {
            buffer.append(", value='");
            buffer.append(StaticUtils.toUTF8String(this.value));
            buffer.append('\'');
        } else {
            buffer.append(", valueLength=");
            buffer.append(this.value.length);
        }
        buffer.append(')');
    }
}

