/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsControlMessageWriter;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcess;
import org.elasticsearch.xpack.ml.process.AbstractNativeProcess;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.process.ProcessResultsParser;

abstract class AbstractNativeAnalyticsProcess<Result>
extends AbstractNativeProcess
implements AnalyticsProcess<Result> {
    private final String name;
    private final ProcessResultsParser<Result> resultsParser;

    protected AbstractNativeAnalyticsProcess(String name, ConstructingObjectParser<Result, Void> resultParser, String jobId, ProcessPipes processPipes, int numberOfFields, List<Path> filesToDelete, Consumer<String> onProcessCrash, NamedXContentRegistry namedXContentRegistry) {
        super(jobId, processPipes, numberOfFields, filesToDelete, onProcessCrash);
        this.name = Objects.requireNonNull(name);
        this.resultsParser = new ProcessResultsParser<Result>(Objects.requireNonNull(resultParser), namedXContentRegistry);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void persistState() {
    }

    @Override
    public void persistState(long timestamp, String id, String description) {
    }

    @Override
    public void writeEndOfDataMessage() throws IOException {
        new AnalyticsControlMessageWriter(this.recordWriter(), this.numberOfFields()).writeEndOfData();
    }

    @Override
    public Iterator<Result> readAnalyticsResults() {
        return this.resultsParser.parseResults(this.processOutStream());
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.consumeAndCloseOutputStream();
        }
    }
}

