/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class Set {
    public static <T> java.util.Set<T> of() {
        return Collections.emptySet();
    }

    public static <T> java.util.Set<T> of(T e1) {
        return Collections.singleton(e1);
    }

    public static <T> java.util.Set<T> of(T e1, T e2) {
        return Set.of(new Object[]{e1, e2});
    }

    @SafeVarargs
    public static <T> java.util.Set<T> of(T ... entries) {
        switch (entries.length) {
            case 0: {
                return Set.of();
            }
            case 1: {
                return Set.of(entries[0]);
            }
        }
        return Collections.unmodifiableSet(new HashSet<T>(Arrays.asList(entries)));
    }

    public static <T> java.util.Set<T> copyOf(Collection<? extends T> coll) {
        switch (coll.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(coll.iterator().next());
            }
        }
        return Collections.unmodifiableSet(new HashSet<T>(coll));
    }
}

