/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;

final class ParallelPoolCloserTask
implements Runnable {
    private final boolean unbind;
    private final LDAPConnection connection;

    ParallelPoolCloserTask(LDAPConnection connection, boolean unbind) {
        this.connection = connection;
        this.unbind = unbind;
    }

    @Override
    public void run() {
        LDAPConnectionPoolStatistics stats;
        AbstractConnectionPool pool = this.connection.getConnectionPool();
        if (pool != null && (stats = pool.getConnectionPoolStatistics()) != null) {
            stats.incrementNumConnectionsClosedUnneeded();
        }
        this.connection.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
        if (this.unbind) {
            this.connection.terminate(null);
        } else {
            this.connection.setClosed();
        }
    }
}

