/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class JsonProcessor
extends AbstractProcessor {
    public static final String TYPE = "json";
    private final String field;
    private final String targetField;
    private final boolean addToRoot;
    private final ConflictStrategy addToRootConflictStrategy;
    private final boolean allowDuplicateKeys;

    JsonProcessor(String tag, String description, String field, String targetField, boolean addToRoot, ConflictStrategy addToRootConflictStrategy, boolean allowDuplicateKeys) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.addToRoot = addToRoot;
        this.addToRootConflictStrategy = addToRootConflictStrategy;
        this.allowDuplicateKeys = allowDuplicateKeys;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    boolean isAddToRoot() {
        return this.addToRoot;
    }

    public ConflictStrategy getAddToRootConflictStrategy() {
        return this.addToRootConflictStrategy;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object apply(Object fieldValue, boolean allowDuplicateKeys) {
        BytesArray bytesRef = fieldValue == null ? new BytesArray("null") : new BytesArray(fieldValue.toString());
        try (StreamInput stream = bytesRef.streamInput();){
            String string;
            block27: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)stream);
                try {
                    parser.allowDuplicateKeys(allowDuplicateKeys);
                    XContentParser.Token token = parser.nextToken();
                    Object value = null;
                    if (token == XContentParser.Token.VALUE_NULL) {
                        value = null;
                    } else if (token == XContentParser.Token.VALUE_STRING) {
                        value = parser.text();
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        value = parser.numberValue();
                    } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        value = parser.booleanValue();
                    } else if (token == XContentParser.Token.START_OBJECT) {
                        value = parser.map();
                    } else if (token == XContentParser.Token.START_ARRAY) {
                        value = parser.list();
                    } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                        throw new IllegalArgumentException("cannot read binary value");
                    }
                    string = value;
                    if (parser == null) break block27;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void apply(Map<String, Object> ctx, String fieldName, boolean allowDuplicateKeys, ConflictStrategy conflictStrategy) {
        Object value = JsonProcessor.apply(ctx.get(fieldName), allowDuplicateKeys);
        if (value instanceof Map) {
            Map map = (Map)value;
            if (conflictStrategy == ConflictStrategy.MERGE) {
                JsonProcessor.recursiveMerge(ctx, map);
            } else {
                ctx.putAll(map);
            }
        } else {
            throw new IllegalArgumentException("cannot add non-map fields to root of document");
        }
    }

    public static void recursiveMerge(Map<String, Object> target, Map<String, Object> from) {
        for (String key : from.keySet()) {
            if (target.containsKey(key)) {
                Object targetValue = target.get(key);
                Object fromValue = from.get(key);
                if (targetValue instanceof Map && fromValue instanceof Map) {
                    Map targetMap = (Map)targetValue;
                    Map fromMap = (Map)fromValue;
                    JsonProcessor.recursiveMerge(targetMap, fromMap);
                    continue;
                }
                target.put(key, fromValue);
                continue;
            }
            target.put(key, from.get(key));
        }
    }

    public IngestDocument execute(IngestDocument document) throws Exception {
        if (this.addToRoot) {
            JsonProcessor.apply(document.getSourceAndMetadata(), this.field, this.allowDuplicateKeys, this.addToRootConflictStrategy);
        } else {
            document.setFieldValue(this.targetField, JsonProcessor.apply(document.getFieldValue(this.field, Object.class), this.allowDuplicateKeys));
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static enum ConflictStrategy {
        REPLACE,
        MERGE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static ConflictStrategy fromString(String conflictStrategy) {
            return ConflictStrategy.valueOf(conflictStrategy.toUpperCase(Locale.ROOT));
        }
    }

    public static final class Factory
    implements Processor.Factory {
        public JsonProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            ConflictStrategy addToRootConflictStrategy;
            boolean hasConflictStrategy;
            String field = ConfigurationUtils.readStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            boolean addToRoot = ConfigurationUtils.readBooleanProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"add_to_root", (boolean)false);
            boolean allowDuplicateKeys = ConfigurationUtils.readBooleanProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"allow_duplicate_keys", (boolean)false);
            String conflictStrategyString = ConfigurationUtils.readOptionalStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"add_to_root_conflict_strategy");
            boolean bl = hasConflictStrategy = conflictStrategyString != null;
            if (conflictStrategyString == null) {
                conflictStrategyString = ConflictStrategy.REPLACE.name();
            }
            try {
                addToRootConflictStrategy = ConflictStrategy.fromString(conflictStrategyString);
            }
            catch (IllegalArgumentException e) {
                throw ConfigurationUtils.newConfigurationException((String)JsonProcessor.TYPE, (String)processorTag, (String)"add_to_root_conflict_strategy", (String)("conflict strategy [" + conflictStrategyString + "] not supported, cannot convert field."));
            }
            if (addToRoot && targetField != null) {
                throw ConfigurationUtils.newConfigurationException((String)JsonProcessor.TYPE, (String)processorTag, (String)"target_field", (String)"Cannot set a target field while also setting `add_to_root` to true");
            }
            if (!addToRoot && hasConflictStrategy) {
                throw ConfigurationUtils.newConfigurationException((String)JsonProcessor.TYPE, (String)processorTag, (String)"add_to_root_conflict_strategy", (String)"Cannot set `add_to_root_conflict_strategy` if `add_to_root` is false");
            }
            if (targetField == null) {
                targetField = field;
            }
            return new JsonProcessor(processorTag, description, field, targetField, addToRoot, addToRootConflictStrategy, allowDuplicateKeys);
        }
    }
}

